/*
 * Decompiled with CFR 0.152.
 */
package ntr.ttme;

import javax.microedition.lcdui.Graphics;
import ntr.ttme.DoubleRectangle;

public class View {
    public static final double WORLD_MIN_X = -32768.0;
    public static final double WORLD_MAX_X = 32767.0;
    public static final double WORLD_MIN_Y = -32768.0;
    public static final double WORLD_MAX_Y = 32767.0;
    public static final double NO_ZOOM = 1.0;
    public static final double MAX_ZOOM_IN = 8.0;
    public static final double MAX_ZOOM_OUT = 0.0625;
    public static final int COLOR_WHITE = 0xFFFFFF;
    public static final int DEFAULT_BACKBUFFER_COLOR = 0xFFFFFF;
    private int viewWidth;
    private int viewHeight;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private DoubleRectangle visibleWorld;
    private double viewCenterWorldX;
    private double viewCenterWorldY;
    private double zoomFactor;
    private boolean forcedResolution;
    private double WYSIWYGScaleX;
    private double WYSIWYGScaleY;
    private Graphics frontBuffer;
    private Graphics backBuffer;
    private int backBufferColor;

    public View(int w, int h, double zoomFactor, double viewWorldX, double viewWorldY) {
        this.forcedResolution = false;
        this.viewWidth = w;
        this.viewHeight = h;
        this.setZoomFactor(zoomFactor);
        this.configureWYSIWYG();
        this.minX = -32768.0;
        this.maxX = 32767.0;
        this.minY = -32768.0;
        this.maxY = 32767.0;
        this.viewCenterWorldX = viewWorldX;
        this.viewCenterWorldY = viewWorldY;
        this.visibleWorld = new DoubleRectangle();
        this.centerViewPoint();
    }

    public View(int w, int h) {
        this(w, h, 1.0, 0.0, 0.0);
    }

    public View(int w, int h, double zoomFactor) {
        this(w, h, zoomFactor, 0.0, 0.0);
    }

    public View(int w, int h, double zoomFactor, double viewWorldX, double viewWorldY, int xRes, int yRes) {
        this.forcedResolution = true;
        this.viewWidth = w;
        this.viewHeight = h;
        this.setZoomFactor(zoomFactor);
        this.WYSIWYGScaleX = xRes;
        this.WYSIWYGScaleY = yRes;
        this.minX = -32768.0;
        this.maxX = 32767.0;
        this.minY = -32768.0;
        this.maxY = 32767.0;
        this.viewCenterWorldX = viewWorldX;
        this.viewCenterWorldY = viewWorldY;
        this.visibleWorld = new DoubleRectangle();
        this.centerViewPoint();
    }

    public void setFrontBuffer(Graphics frontBuffer) {
        this.frontBuffer = frontBuffer;
    }

    public Graphics getFrontBuffer() {
        if (!this.hasFrontBuffer()) {
            throw new IllegalStateException("FrontBuffer NOT set!");
        }
        return this.frontBuffer;
    }

    public void setBackBuffer(Graphics backBuffer) {
        this.setBackBuffer(backBuffer, 0xFFFFFF);
    }

    public void setBackBuffer(Graphics backBuffer, int backBufferColor) {
        this.backBuffer = backBuffer;
        this.backBufferColor = backBufferColor;
        this.clearBackBuffer();
    }

    public Graphics getBackBuffer() {
        if (!this.hasBackBuffer()) {
            throw new IllegalStateException("BackBuffer NOT set!");
        }
        return this.backBuffer;
    }

    public void setBuffers(Graphics frontBuffer, Graphics backBuffer) {
        this.setFrontBuffer(frontBuffer);
        this.setBackBuffer(backBuffer);
    }

    public void setBuffers(Graphics frontBuffer, Graphics backBuffer, int backBufferColor) {
        this.setFrontBuffer(frontBuffer);
        this.setBackBuffer(backBuffer, backBufferColor);
    }

    public boolean hasFrontBuffer() {
        return this.frontBuffer != null;
    }

    public boolean hasBackBuffer() {
        return this.backBuffer != null;
    }

    public boolean hasBuffers() {
        return this.hasFrontBuffer() && this.hasBackBuffer();
    }

    public void clearBackBuffer() {
        this.clearBackBuffer(this.backBufferColor);
    }

    public void clearBackBuffer(int color) {
        if (!this.hasBackBuffer()) {
            throw new IllegalStateException("BackBuffer NOT set, unable to clear!");
        }
        this.backBuffer.setColor(color);
        this.backBuffer.fillRect(0, 0, this.viewWidth, this.viewHeight);
    }

    public int convertXWorldToView(double worldXCoord) {
        return (int)((worldXCoord - this.visibleWorld.x) * this.zoomFactor * this.WYSIWYGScaleX);
    }

    public int convertYWorldToView(double worldYCoord) {
        return (int)((worldYCoord - this.visibleWorld.y) * this.zoomFactor * this.WYSIWYGScaleY);
    }

    public int convertXDistanceWorldToView(double distance) {
        return (int)(distance * this.zoomFactor * this.WYSIWYGScaleX);
    }

    public int convertYDistanceWorldToView(double distance) {
        return (int)(distance * this.zoomFactor * this.WYSIWYGScaleY);
    }

    public int convertMinDistanceWorldToView(double distance) {
        if (this.WYSIWYGScaleX < this.WYSIWYGScaleX) {
            return this.convertXDistanceWorldToView(distance);
        }
        return this.convertYDistanceWorldToView(distance);
    }

    public double convertXViewToWorld(int viewXCoord) {
        return this.visibleWorld.x + (double)viewXCoord / (this.zoomFactor * this.WYSIWYGScaleX);
    }

    public double convertYViewToWorld(int viewYCoord) {
        return this.visibleWorld.y + (double)viewYCoord / (this.zoomFactor * this.WYSIWYGScaleY);
    }

    public double convertXDistanceViewToWorld(int distance) {
        return (double)distance / (this.zoomFactor * this.WYSIWYGScaleX);
    }

    public double convertYDistanceViewToWorld(int distance) {
        return (double)distance / (this.zoomFactor * this.WYSIWYGScaleY);
    }

    public double convertMaxDistanceViewToWorld(int distance) {
        if (this.WYSIWYGScaleX < this.WYSIWYGScaleY) {
            return this.convertXDistanceViewToWorld(distance);
        }
        return this.convertYDistanceViewToWorld(distance);
    }

    public void setWorldViewPoint(double worldViewPointX, double worldViewPointY) {
        this.visibleWorld.x = 0.0;
        this.visibleWorld.y = 0.0;
        this.visibleWorld.width = this.convertXDistanceViewToWorld(this.viewWidth);
        this.visibleWorld.height = this.convertYDistanceViewToWorld(this.viewHeight);
        this.visibleWorld.x = this.minX <= worldViewPointX ? (this.maxX >= worldViewPointX ? worldViewPointX - this.visibleWorld.width / 2.0 : this.maxX - this.visibleWorld.width / 2.0) : this.minX - this.visibleWorld.width / 2.0;
        this.visibleWorld.y = this.minY <= worldViewPointY ? (this.maxY >= worldViewPointY ? worldViewPointY - this.visibleWorld.height / 2.0 : this.maxY - this.visibleWorld.height / 2.0) : this.minY - this.visibleWorld.height / 2.0;
        this.viewCenterWorldX = this.visibleWorld.x + this.visibleWorld.width / 2.0;
        this.viewCenterWorldY = this.visibleWorld.y + this.visibleWorld.height / 2.0;
    }

    public void pan(int viewXDistance, int viewYDistance) {
        this.setWorldViewPoint(this.viewCenterWorldX - this.convertXDistanceViewToWorld(viewXDistance), this.viewCenterWorldY - this.convertYDistanceViewToWorld(viewYDistance));
    }

    public void setZoomFactor(double zoomFactor) {
        this.zoomFactor = zoomFactor >= 1.0 ? Math.min(zoomFactor, 8.0) : Math.max(zoomFactor, 0.0625);
    }

    public boolean zoomIn(int x, int y) {
        if (this.zoomFactor < 8.0) {
            this.setZoomFactor(this.zoomFactor * 2.0);
            this.setWorldViewPoint(this.convertXViewToWorld(x), this.convertYViewToWorld(y));
            return true;
        }
        return false;
    }

    public void centerViewPoint() {
        this.setWorldViewPoint(this.viewCenterWorldX, this.viewCenterWorldY);
    }

    public boolean zoomIn() {
        if (this.zoomFactor < 8.0) {
            this.setZoomFactor(this.zoomFactor * 2.0);
            this.centerViewPoint();
            return true;
        }
        return false;
    }

    public boolean zoomOut() {
        if (this.zoomFactor > 0.0625) {
            this.setZoomFactor(this.zoomFactor / 2.0);
            this.centerViewPoint();
            return true;
        }
        return false;
    }

    public boolean noZoom() {
        if (this.zoomFactor != 1.0) {
            this.setZoomFactor(1.0);
            this.centerViewPoint();
            return true;
        }
        return false;
    }

    public boolean setXFitZoom(double xDistanceToFit) {
        double oldZoomFactor = this.zoomFactor;
        this.setZoomFactor((double)this.viewWidth / (Math.abs(xDistanceToFit) * this.WYSIWYGScaleX));
        return this.zoomFactor != oldZoomFactor;
    }

    public boolean setYFitZoom(double yDistanceToFit) {
        double oldZoomFactor = this.zoomFactor;
        this.setZoomFactor((double)this.viewHeight / (Math.abs(yDistanceToFit) * this.WYSIWYGScaleY));
        return this.zoomFactor != oldZoomFactor;
    }

    public boolean setXYFitZoom(double xDistanceToFit, double yDistanceToFit) {
        double oldZoomFactor = this.zoomFactor;
        this.setZoomFactor(Math.min((double)this.viewWidth / (Math.abs(xDistanceToFit) * this.WYSIWYGScaleX), (double)this.viewHeight / (Math.abs(yDistanceToFit) * this.WYSIWYGScaleY)));
        return this.zoomFactor != oldZoomFactor;
    }

    private void configureWYSIWYG() {
        if (!this.forcedResolution) {
            this.WYSIWYGScaleY = this.WYSIWYGScaleX = 72.0;
        }
    }

    public boolean setRanges(double areaX, double areaY, double areaW, double areaH) {
        if (areaW > 0.0 && areaH > 0.0) {
            double x = areaX - areaW;
            double y = areaY - areaH;
            double w = areaW * 3.0;
            double h = areaH * 3.0;
            this.minX = x;
            this.maxX = x + w;
            this.minY = y;
            this.maxY = y + h;
            return true;
        }
        return false;
    }

    public double getViewCenterWorldX() {
        return this.viewCenterWorldX;
    }

    public double getViewCenterWorldY() {
        return this.viewCenterWorldY;
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMaxY() {
        return this.maxY;
    }
}

