/*
 * Decompiled with CFR 0.152.
 */
package ntr.ttme;

class DoubleMatrix3x3 {
    private static final DoubleMatrix3x3 ZERO = new DoubleMatrix3x3(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static final DoubleMatrix3x3 IDENTITY = new DoubleMatrix3x3(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
    double[][] element = new double[3][3];

    public DoubleMatrix3x3() {
    }

    public DoubleMatrix3x3(double m11, double m12, double m13, double m21, double m22, double m23, double m31, double m32, double m33) {
        this.set(m11, m12, m13, m21, m22, m23, m31, m32, m33);
    }

    public DoubleMatrix3x3(DoubleMatrix3x3 m) {
        this.set(m);
    }

    public void set(double m11, double m12, double m13, double m21, double m22, double m23, double m31, double m32, double m33) {
        this.element[0][0] = m11;
        this.element[0][1] = m12;
        this.element[0][2] = m13;
        this.element[1][0] = m21;
        this.element[1][1] = m22;
        this.element[1][2] = m23;
        this.element[2][0] = m31;
        this.element[2][1] = m32;
        this.element[2][2] = m33;
    }

    public void set(DoubleMatrix3x3 m) {
        this.element[0][0] = m.element[0][0];
        this.element[0][1] = m.element[0][1];
        this.element[0][2] = m.element[0][2];
        this.element[1][0] = m.element[1][0];
        this.element[1][1] = m.element[1][1];
        this.element[1][2] = m.element[1][2];
        this.element[2][0] = m.element[2][0];
        this.element[2][1] = m.element[2][1];
        this.element[2][2] = m.element[2][2];
    }

    public DoubleMatrix3x3 add(DoubleMatrix3x3 m) {
        double[] dArray = this.element[0];
        dArray[0] = dArray[0] + m.element[0][0];
        double[] dArray2 = this.element[0];
        dArray2[1] = dArray2[1] + m.element[0][1];
        double[] dArray3 = this.element[0];
        dArray3[2] = dArray3[2] + m.element[0][2];
        double[] dArray4 = this.element[1];
        dArray4[0] = dArray4[0] + m.element[1][0];
        double[] dArray5 = this.element[1];
        dArray5[1] = dArray5[1] + m.element[1][1];
        double[] dArray6 = this.element[1];
        dArray6[2] = dArray6[2] + m.element[1][2];
        double[] dArray7 = this.element[2];
        dArray7[0] = dArray7[0] + m.element[2][0];
        double[] dArray8 = this.element[2];
        dArray8[1] = dArray8[1] + m.element[2][1];
        double[] dArray9 = this.element[2];
        dArray9[2] = dArray9[2] + m.element[2][2];
        return this;
    }

    public DoubleMatrix3x3 sub(DoubleMatrix3x3 m) {
        double[] dArray = this.element[0];
        dArray[0] = dArray[0] - m.element[0][0];
        double[] dArray2 = this.element[0];
        dArray2[1] = dArray2[1] - m.element[0][1];
        double[] dArray3 = this.element[0];
        dArray3[2] = dArray3[2] - m.element[0][2];
        double[] dArray4 = this.element[1];
        dArray4[0] = dArray4[0] - m.element[1][0];
        double[] dArray5 = this.element[1];
        dArray5[1] = dArray5[1] - m.element[1][1];
        double[] dArray6 = this.element[1];
        dArray6[2] = dArray6[2] - m.element[1][2];
        double[] dArray7 = this.element[2];
        dArray7[0] = dArray7[0] - m.element[2][0];
        double[] dArray8 = this.element[2];
        dArray8[1] = dArray8[1] - m.element[2][1];
        double[] dArray9 = this.element[2];
        dArray9[2] = dArray9[2] - m.element[2][2];
        return this;
    }

    public DoubleMatrix3x3 rightMul(DoubleMatrix3x3 m) {
        double r11 = this.element[0][0] * m.element[0][0] + this.element[0][1] * m.element[1][0] + this.element[0][2] * m.element[2][0];
        double r12 = this.element[0][0] * m.element[0][1] + this.element[0][1] * m.element[1][1] + this.element[0][2] * m.element[2][1];
        double r13 = this.element[0][0] * m.element[0][2] + this.element[0][1] * m.element[1][2] + this.element[0][2] * m.element[2][2];
        double r21 = this.element[1][0] * m.element[0][0] + this.element[1][1] * m.element[1][0] + this.element[1][2] * m.element[2][0];
        double r22 = this.element[1][0] * m.element[0][1] + this.element[1][1] * m.element[1][1] + this.element[1][2] * m.element[2][1];
        double r23 = this.element[1][0] * m.element[0][2] + this.element[1][1] * m.element[1][2] + this.element[1][2] * m.element[2][2];
        double r31 = this.element[2][0] * m.element[0][0] + this.element[2][1] * m.element[1][0] + this.element[2][2] * m.element[2][0];
        double r32 = this.element[2][0] * m.element[0][1] + this.element[2][1] * m.element[1][1] + this.element[2][2] * m.element[2][1];
        double r33 = this.element[2][0] * m.element[0][2] + this.element[2][1] * m.element[1][2] + this.element[2][2] * m.element[2][2];
        this.set(r11, r12, r13, r21, r22, r23, r31, r32, r33);
        return this;
    }

    public DoubleMatrix3x3 leftMul(DoubleMatrix3x3 m) {
        double r11 = m.element[0][0] * this.element[0][0] + m.element[0][1] * this.element[1][0] + m.element[0][2] * this.element[2][0];
        double r12 = m.element[0][0] * this.element[0][1] + m.element[0][1] * this.element[1][1] + m.element[0][2] * this.element[2][1];
        double r13 = m.element[0][0] * this.element[0][2] + m.element[0][1] * this.element[1][2] + m.element[0][2] * this.element[2][2];
        double r21 = m.element[1][0] * this.element[0][0] + m.element[1][1] * this.element[1][0] + m.element[1][2] * this.element[2][0];
        double r22 = m.element[1][0] * this.element[0][1] + m.element[1][1] * this.element[1][1] + m.element[1][2] * this.element[2][1];
        double r23 = m.element[1][0] * this.element[0][2] + m.element[1][1] * this.element[1][2] + m.element[1][2] * this.element[2][2];
        double r31 = m.element[2][0] * this.element[0][0] + m.element[2][1] * this.element[1][0] + m.element[2][2] * this.element[2][0];
        double r32 = m.element[2][0] * this.element[0][1] + m.element[2][1] * this.element[1][1] + m.element[2][2] * this.element[2][1];
        double r33 = m.element[2][0] * this.element[0][2] + m.element[2][1] * this.element[1][2] + m.element[2][2] * this.element[2][2];
        this.set(r11, r12, r13, r21, r22, r23, r31, r32, r33);
        return this;
    }

    public static DoubleMatrix3x3 add(DoubleMatrix3x3 m1, DoubleMatrix3x3 m2) {
        return new DoubleMatrix3x3(m1).add(m2);
    }

    public static DoubleMatrix3x3 sub(DoubleMatrix3x3 m1, DoubleMatrix3x3 m2) {
        return new DoubleMatrix3x3(m1).sub(m2);
    }

    public static DoubleMatrix3x3 mul(DoubleMatrix3x3 m1, DoubleMatrix3x3 m2) {
        return new DoubleMatrix3x3(m1).rightMul(m2);
    }

    public static DoubleMatrix3x3 createIdentityMatrix() {
        return new DoubleMatrix3x3(IDENTITY);
    }

    public static DoubleMatrix3x3 createZeroMatrix() {
        return new DoubleMatrix3x3(ZERO);
    }

    public static DoubleMatrix3x3 translate(double dx, double dy) {
        DoubleMatrix3x3 result = DoubleMatrix3x3.createIdentityMatrix();
        result.element[0][2] = dx;
        result.element[1][2] = dy;
        return result;
    }

    public static DoubleMatrix3x3 rotate(double angle) {
        DoubleMatrix3x3 result = DoubleMatrix3x3.createIdentityMatrix();
        double cosa = Math.cos(angle);
        double sina = Math.sin(angle);
        result.element[0][0] = cosa;
        result.element[0][1] = -sina;
        result.element[1][0] = sina;
        result.element[1][1] = cosa;
        return result;
    }

    public static DoubleMatrix3x3 rotate(double angle, double x, double y) {
        return DoubleMatrix3x3.translate(-x, -y).leftMul(DoubleMatrix3x3.rotate(angle)).leftMul(DoubleMatrix3x3.translate(x, y));
    }

    public static DoubleMatrix3x3 scale(double xFactor, double yFactor) {
        DoubleMatrix3x3 result = DoubleMatrix3x3.createIdentityMatrix();
        result.element[0][0] = xFactor;
        result.element[1][1] = yFactor;
        return result;
    }

    public static DoubleMatrix3x3 scale(double xFactor, double yFactor, double originX, double originY, double dx, double dy) {
        return DoubleMatrix3x3.translate(-originX, -originY).leftMul(DoubleMatrix3x3.scale(xFactor, yFactor)).leftMul(DoubleMatrix3x3.translate(originX + dx, originY + dy));
    }

    public static DoubleMatrix3x3 skew(double angle) {
        DoubleMatrix3x3 result = DoubleMatrix3x3.createIdentityMatrix();
        result.element[0][1] = 1.0 / Math.tan(angle);
        return result;
    }

    public static DoubleMatrix3x3 skew(double angle, double originX, double originY) {
        return DoubleMatrix3x3.translate(-originX, -originY).leftMul(DoubleMatrix3x3.skew(angle)).leftMul(DoubleMatrix3x3.translate(originX, originY));
    }
}

