/*
 * Decompiled with CFR 0.152.
 */
package ntr.ttme;

import ntr.ttme.DoublePoint;

public class DoubleRectangle {
    double x;
    double y;
    double width;
    double height;

    public DoubleRectangle() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public DoubleRectangle(DoubleRectangle r) {
        this(r.x, r.y, r.width, r.height);
    }

    public DoubleRectangle(double x, double y, double width, double height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public DoubleRectangle(double width, double height) {
        this(0.0, 0.0, width, height);
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public DoubleRectangle getBounds() {
        return new DoubleRectangle(this.x, this.y, this.width, this.height);
    }

    public void copyFrom(DoubleRectangle r) {
        this.reshape(r.x, r.y, r.width, r.height);
    }

    public void reshape(double x, double y, double width, double height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void setLocation(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void setSize(double width, double height) {
        this.width = width;
        this.height = height;
    }

    public void translate(double dx, double dy) {
        this.x += dx;
        this.y += dy;
    }

    public boolean contains(DoublePoint p) {
        return this.contains(p.x, p.y);
    }

    public boolean contains(double x, double y) {
        return x >= this.x && y >= this.y && x - this.x < this.width && y - this.y < this.height;
    }

    public boolean intersects(DoubleRectangle r) {
        return !(r.x + r.width <= this.x || r.y + r.height <= this.y || r.x >= this.x + this.width || r.y >= this.y + this.height);
    }

    public DoubleRectangle intersection(DoubleRectangle r) {
        double x1 = Math.max(this.x, r.x);
        double x2 = Math.min(this.x + this.width, r.x + r.width);
        double y1 = Math.max(this.y, r.y);
        double y2 = Math.min(this.y + this.height, r.y + r.height);
        return new DoubleRectangle(x1, y1, x2 - x1, y2 - y1);
    }

    public boolean containsRectangle(DoubleRectangle r) {
        return this.contains(r.x, r.y) && this.contains(r.x + r.width, r.y) && this.contains(r.x + r.width, r.y + r.height) && this.contains(r.x, r.y + r.height);
    }

    public DoubleRectangle union(DoubleRectangle r) {
        double x1 = Math.min(this.x, r.x);
        double x2 = Math.max(this.x + this.width, r.x + r.width);
        double y1 = Math.min(this.y, r.y);
        double y2 = Math.max(this.y + this.height, r.y + r.height);
        return new DoubleRectangle(x1, y1, x2 - x1, y2 - y1);
    }

    public void add(DoubleRectangle r) {
        double x1 = Math.min(this.x, r.x);
        double x2 = Math.max(this.x + this.width, r.x + r.width);
        double y1 = Math.min(this.y, r.y);
        double y2 = Math.max(this.y + this.height, r.y + r.height);
        this.x = x1;
        this.y = y1;
        this.width = x2 - x1;
        this.height = y2 - y1;
    }

    public boolean isEmpty() {
        return this.width <= 0.0 || this.height <= 0.0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DoubleRectangle) {
            DoubleRectangle r = (DoubleRectangle)obj;
            return this.x == r.x && this.y == r.y && this.width == r.width && this.height == r.height;
        }
        return false;
    }
}

