/*
 * Decompiled with CFR 0.152.
 */
package ntr.ttme;

import javax.microedition.lcdui.Graphics;

public class LineRenderer {
    public static final void renderHorizontalDashedLine(Graphics g, int x1, int x2, int y, int dashLength, int c) {
        int lineLength = x2 - x1;
        int direction = Math.min(1, Math.max(-1, lineLength));
        g.setColor(c);
        boolean penDown = true;
        int currentX = x1;
        int endX = x1 + (lineLength += direction);
        while (currentX != endX) {
            int currentStep = Math.min(dashLength, Math.abs(endX - currentX));
            if (penDown) {
                g.drawLine(currentX, y, currentX + direction * (currentStep - 1), y);
            }
            penDown = !penDown;
            currentX += direction * currentStep;
        }
    }

    public static final void renderVerticalDashedLine(Graphics g, int x, int y1, int y2, int dashLength, int c) {
        int lineLength = y2 - y1;
        int direction = Math.min(1, Math.max(-1, lineLength));
        g.setColor(c);
        boolean penDown = true;
        int currentY = y1;
        int endY = y1 + (lineLength += direction);
        while (currentY != endY) {
            int currentStep = Math.min(dashLength, Math.abs(endY - currentY));
            if (penDown) {
                g.drawLine(x, currentY, x, currentY + direction * (currentStep - 1));
            }
            penDown = !penDown;
            currentY += direction * currentStep;
        }
    }

    public static final void renderDottedLine(Graphics g, int x1, int y1, int x2, int y2, int c) {
        if (y1 == y2) {
            LineRenderer.renderHorizontalDashedLine(g, x1, x2, y1, 1, c);
        } else if (x1 == x2) {
            LineRenderer.renderVerticalDashedLine(g, x1, y1, y2, 1, c);
        } else {
            int xd = Math.abs(x2 - x1);
            int yd = Math.abs(y2 - y1);
            boolean penDown = true;
            g.setColor(c);
            if (xd > yd) {
                if (x1 > x2) {
                    int tmp = x1;
                    x1 = x2;
                    x2 = tmp;
                    tmp = y1;
                    y1 = y2;
                    y2 = tmp;
                }
                int direction = (y2 - y1) / yd;
                ++yd;
                int measure = ++xd;
                int currentY = y1;
                int i = x1;
                while (i <= x2) {
                    if (penDown) {
                        g.drawLine(i, currentY, i, currentY);
                    }
                    boolean bl = penDown = !penDown;
                    if (measure >= yd) {
                        measure -= yd;
                    } else {
                        measure += xd;
                        measure -= yd;
                        currentY += direction;
                    }
                    ++i;
                }
            } else {
                if (y1 > y2) {
                    int tmp = y1;
                    y1 = y2;
                    y2 = tmp;
                    tmp = x1;
                    x1 = x2;
                    x2 = tmp;
                }
                int direction = (x2 - x1) / xd;
                ++xd;
                int measure = ++yd;
                int currentX = x1;
                int i = y1;
                while (i <= y2) {
                    if (penDown) {
                        g.drawLine(currentX, i, currentX, i);
                    }
                    boolean bl = penDown = !penDown;
                    if (measure >= xd) {
                        measure -= xd;
                    } else {
                        measure += yd;
                        measure -= xd;
                        currentX += direction;
                    }
                    ++i;
                }
            }
        }
    }
}

