/*
 * Decompiled with CFR 0.152.
 */
package com.telecom;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;

public class FileSystemAccessor {
    private FileConnection connection;
    private String location;

    public FileSystemAccessor(String string) {
        this.location = string;
    }

    private void close() {
        try {
            this.connection.close();
            this.connection = null;
        }
        catch (Exception exception) {
            System.out.println("Close connection failed: " + exception.getMessage());
        }
    }

    private void open(int n) {
        try {
            this.connection = (FileConnection)Connector.open((String)("file://" + this.location), (int)n);
        }
        catch (Exception exception) {
            this.connection = null;
            System.out.println("Open connection '" + this.location + "' failed: " + exception.getMessage());
        }
    }

    private void open() {
        this.open(1);
    }

    public long availableSize() {
        long l = -1L;
        this.open();
        if (this.connection != null) {
            l = this.connection.availableSize();
            this.close();
        }
        return l;
    }

    public boolean canRead() {
        boolean bl = false;
        this.open();
        if (this.connection != null) {
            bl = this.connection.canRead();
            this.close();
        }
        return bl;
    }

    public boolean canWrite() {
        boolean bl = false;
        this.open();
        if (this.connection != null) {
            bl = this.connection.canWrite();
            this.close();
        }
        return bl;
    }

    public boolean create() {
        this.open(3);
        if (this.connection != null) {
            if (!this.connection.exists()) {
                this.connection.create();
            }
            this.close();
        }
        return true;
    }

    public boolean delete() {
        this.open(3);
        if (this.connection != null) {
            if (this.connection.exists()) {
                this.connection.delete();
            }
            this.close();
        }
        return true;
    }

    public long directorySize(boolean bl) {
        long l = -1L;
        this.open();
        if (this.connection != null) {
            l = this.connection.directorySize(bl);
            this.close();
        }
        return l;
    }

    public boolean exists() {
        boolean bl = false;
        this.open();
        if (this.connection != null) {
            bl = this.connection.exists();
            this.close();
        }
        return bl;
    }

    public long fileSize() {
        long l = -1L;
        this.open();
        if (this.connection != null) {
            l = this.connection.fileSize();
            this.close();
        }
        return l;
    }

    public boolean isDirectory() {
        boolean bl = false;
        this.open();
        if (this.connection != null) {
            bl = this.connection.isDirectory();
            this.close();
        }
        return bl;
    }

    public boolean isHidden() {
        boolean bl = false;
        this.open();
        if (this.connection != null) {
            bl = this.connection.isHidden();
            this.close();
        }
        return bl;
    }

    public long lastModified() {
        long l = -1L;
        this.open();
        if (this.connection != null) {
            l = this.connection.lastModified();
            this.close();
        }
        return l;
    }

    public String[] list() {
        String[] stringArray = null;
        this.open();
        if (this.connection != null) {
            Vector vector = new Vector();
            Enumeration enumeration = this.connection.list("*", true);
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
            this.close();
            stringArray = new String[vector.size()];
            int n = 0;
            while (n < vector.size()) {
                stringArray[n] = this.location + vector.elementAt(n);
                ++n;
            }
        }
        return stringArray;
    }

    public static String[] listRoots() {
        String[] stringArray = null;
        Vector vector = new Vector();
        Enumeration enumeration = FileSystemRegistry.listRoots();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        stringArray = new String[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            stringArray[n] = "/" + vector.elementAt(n);
            ++n;
        }
        return stringArray;
    }

    public boolean mkdir() {
        this.open(3);
        if (this.connection != null) {
            if (!this.connection.exists()) {
                this.connection.mkdir();
            }
            this.close();
        }
        return true;
    }

    public byte[] read() {
        byte[] byArray = null;
        try {
            this.open();
            long l = this.connection.fileSize();
            byArray = new byte[(int)l];
            DataInputStream dataInputStream = this.connection.openDataInputStream();
            if (l != (long)dataInputStream.read(byArray)) {
                byArray = null;
            }
            dataInputStream.close();
            dataInputStream = null;
            this.close();
        }
        catch (Exception exception) {
            byArray = null;
            System.out.println("Read from '" + this.location + "' failed: " + exception.getMessage());
        }
        return byArray;
    }

    public boolean rename(String string) {
        this.open(3);
        if (this.connection != null) {
            int n = string.lastIndexOf(47);
            if (n != -1) {
                string = string.substring(n + 1);
            }
            this.connection.rename(string);
            this.close();
        }
        return true;
    }

    public boolean write(byte[] byArray) {
        boolean bl = false;
        try {
            this.open(3);
            if (this.connection.exists()) {
                this.connection.delete();
            }
            this.connection.create();
            DataOutputStream dataOutputStream = this.connection.openDataOutputStream();
            dataOutputStream.write(byArray, 0, byArray.length);
            dataOutputStream.flush();
            dataOutputStream.close();
            this.close();
            bl = true;
        }
        catch (Exception exception) {
            System.out.println("Write to '" + this.location + "' failed: " + exception.getMessage());
        }
        return bl;
    }

    public void setHidden(boolean bl) {
        this.open();
        if (this.connection != null) {
            this.connection.setHidden(bl);
            this.close();
        }
    }

    public void setReadable(boolean bl) {
        this.open();
        if (this.connection != null) {
            this.connection.setReadable(bl);
            this.close();
        }
    }

    public void setWriteable(boolean bl) {
        this.open();
        if (this.connection != null) {
            this.connection.setWriteable(bl);
            this.close();
        }
    }

    public long totalSize() {
        long l = -1L;
        this.open();
        if (this.connection != null) {
            l = this.connection.totalSize();
            this.close();
        }
        return l;
    }

    public long usedSize() {
        long l = -1L;
        this.open();
        if (this.connection != null) {
            l = this.connection.usedSize();
            this.close();
        }
        return l;
    }

    public InputStream openInputStream() {
        InputStream inputStream;
        try {
            this.open();
            inputStream = this.connection.openInputStream();
        }
        catch (Exception exception) {
            inputStream = null;
            System.out.println("openInputStream from '" + this.location + "' failed: " + exception.getMessage());
        }
        return inputStream;
    }

    public OutputStream openOutputStream() {
        OutputStream outputStream;
        try {
            this.open(3);
            if (this.connection.exists()) {
                this.connection.delete();
            }
            this.connection.create();
            outputStream = this.connection.openOutputStream();
        }
        catch (Exception exception) {
            outputStream = null;
            System.out.println("openOutputStream on '" + this.location + "' failed: " + exception.getMessage());
        }
        return outputStream;
    }

    public void closeInputStream(InputStream inputStream) {
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("closeInputStream from '" + this.location + "' failed: " + iOException.getMessage());
        }
        this.close();
    }

    public void closeOutputStream(OutputStream outputStream) {
        try {
            outputStream.flush();
            outputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("closeOutputStream on '" + this.location + "' failed: " + iOException.getMessage());
        }
        this.close();
    }
}

