/*
 * Decompiled with CFR 0.152.
 */
package Coral.Audio;

import Coral.Audio.iAudio;
import Coral.Audio.iAudioLoader;
import Coral.Util.crlBinArray;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;

public class crlMMSimpleAudioManager
implements iAudio {
    private static final String[] _AUDIO_TYPE = new String[]{"audio/amr", "audio/midi", "audio/mpeg", "audio/x-wav", "Nokia tone format"};
    private static final int[] _VOLUME_MAP = new int[]{0, 25, 50, 100};
    private int _mState;
    private int _mPlayers;
    private Player _mPlayer;
    private int _mPlayerLoop;
    private int[] _mPlayerType;
    private crlBinArray[] _mPlayerData;
    private boolean _mPlaying;
    private int _mRequestedSound;
    private int _mCurrentSound;
    private long _mRequestTime;

    public void open(int n) {
        this._mPlayerType = new int[n];
        this._mPlayerData = new crlBinArray[n];
        this._mPlayers = 0;
        this._mCurrentSound = -1;
        this._mRequestedSound = -1;
        this._mState = 0;
    }

    public int load(iAudioLoader iAudioLoader2, long[] lArray, int[] nArray) {
        if (this._mPlayers != 0) {
            this.unload();
        }
        this._mPlayers = lArray.length;
        for (int i = 0; i < this._mPlayers; ++i) {
            this._mPlayerType[i] = nArray[i];
            this._mPlayerData[i] = iAudioLoader2.getAudioBinByID(lArray[i]);
        }
        this._mRequestedSound = -1;
        this._mState = 1;
        return 0;
    }

    public void play(int n, int n2, int n3) {
        if (this._mRequestTime > System.currentTimeMillis()) {
            return;
        }
        if (n3 == -1 && this.isStarted(n) && this._mPlayerLoop != -1) {
            this.stop(n);
        }
        if (n3 == -1) {
            n3 = -1;
        }
        this._mPlayerLoop = n3;
        this._mRequestedSound = n;
    }

    public boolean isStarted(int n) {
        return n == this._mCurrentSound && this._mPlayer != null && (this._mPlaying && this._mPlayerLoop == -1 || this._mPlayer.getState() == 400);
    }

    public void pause() {
        if (this._mState == 1) {
            this._pause();
            this._mState = 3;
        }
    }

    public void resume() {
        if (this._mState == 3) {
            this._mState = 4;
        }
    }

    public void stop(int n) {
        if (n == this._mCurrentSound) {
            this._stopPlayer();
            this._mPlayerLoop = 0;
        }
        if (this._mRequestedSound == n) {
            this._mRequestedSound = -1;
        }
    }

    public void stopAll() {
        if (this._mCurrentSound != -1) {
            this.stop(this._mCurrentSound);
        }
        this._mRequestedSound = -1;
    }

    public int unload() {
        this._killPlayer();
        for (int i = 0; i < this._mPlayers; ++i) {
            this._mPlayerType[i] = -1;
            this._mPlayerData[i] = null;
        }
        this._mPlayers = 0;
        this._mState = 0;
        return 0;
    }

    public int update() {
        switch (this._mState) {
            case 1: {
                if (this._mRequestedSound == -1 || this.isStarted(this._mCurrentSound)) break;
                if (this._mRequestedSound != this._mCurrentSound) {
                    if (this._isLoaded()) {
                        this._killPlayer();
                        break;
                    }
                    this._loadPlayer(this._mRequestedSound);
                    break;
                }
                if (this._startPlayer() != 0) break;
                this._mRequestedSound = -1;
                this._mRequestTime = System.currentTimeMillis() + 1500L;
                break;
            }
            case 2: {
                this._pause();
                this._mState = 3;
                break;
            }
            case 4: {
                this._resume();
                this._mState = 1;
                break;
            }
            case 5: {
                if (this._killPlayer() != 0) break;
                this._mState = 1;
                break;
            }
        }
        return 0;
    }

    private int _loadPlayer(int n) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this._mPlayerData[n].getArray(), this._mPlayerData[n].getOffset(), this._mPlayerData[n].getLength());
            this._mPlayer = Manager.createPlayer((InputStream)byteArrayInputStream, (String)_AUDIO_TYPE[this._mPlayerType[n]]);
            this._mPlayer.realize();
            this._mPlayer.prefetch();
            byteArrayInputStream.close();
            byteArrayInputStream = null;
            this._mCurrentSound = this._mRequestedSound;
        }
        catch (Exception exception) {
            this._mPlayer = null;
            this._mRequestedSound = -1;
            this._mCurrentSound = -1;
            return -1;
        }
        return 0;
    }

    private void _pause() {
        this._stopPlayer();
    }

    private void _resume() {
        if (this._mPlayerLoop == -1 && this._mRequestedSound == -1) {
            this._mRequestedSound = this._mCurrentSound;
        }
    }

    private void _stopPlayer() {
        try {
            this._mPlayer.stop();
            this._mPlaying = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int _killPlayer() {
        if (this._mPlayer != null) {
            try {
                this._mPlayer.stop();
                this._mPlaying = false;
                this._mPlayer.deallocate();
                this._mPlayer.close();
            }
            catch (Exception exception) {
                return -1;
            }
            this._mPlayer = null;
        }
        this._mCurrentSound = -1;
        return 0;
    }

    private boolean _isLoaded() {
        return this._mPlayer != null && this._mPlayer.getState() != 0;
    }

    private int _startPlayer() {
        if (this.isStarted(this._mCurrentSound)) {
            return -1;
        }
        try {
            this._mPlayer.setLoopCount(this._mPlayerLoop);
            this._mPlayer.start();
            this._mPlaying = true;
        }
        catch (Exception exception) {
            return -1;
        }
        return 0;
    }
}

