/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mid.sound;

import com.nokia.mid.sound.SoundListener;

public class Sound {
    static final int FORMAT_TONE = 1;
    static final int SOUND_PLAYING = 0;
    static final int SOUND_STOPPED = 1;
    static final int SOUND_UNINITIALIZED = 3;
    static final int SEMITONE_CONST = 17;
    static final int MAX_VOLUME = 100;
    static final int MAX_GAIN = 255;
    static final int MAX_NOTE = 127;
    static final int MAX_FREQ = 13288;
    private int sound_state = 3;
    private int note;
    private int duration;
    private int volume;

    public Sound(int freq, long duration) {
        this.init(freq, duration);
    }

    public void init(int freq, long duration) {
        this.note = freq * 127 / 13288;
        this.duration = (int)duration;
        this.sound_state = 1;
    }

    public int getState() {
        return this.sound_state;
    }

    public void setGain(int gain) {
        this.volume = gain * 100 / 255;
    }

    public int getGain() {
        return this.volume * 255 / 100;
    }

    public static int getConcurrentSoundCount(int type) {
        return 1;
    }

    public static int[] getSupportedFormats() {
        int[] formats = new int[]{1};
        return formats;
    }

    public void play(int loop) {
        if (loop == 0) {
            loop = 1000;
        }
        this.sound_state = 0;
        try {
            int i = 0;
            while (i < loop) {
                ++i;
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        this.sound_state = 1;
    }

    public void stop() {
        this.sound_state = 1;
    }

    public void setSoundListener(SoundListener listener) {
    }

    public Sound(byte[] data, int type) {
    }

    public void init(byte[] data, int type) {
    }

    public void resume() {
    }

    public void release() {
    }
}

