/*
 * Decompiled with CFR 0.152.
 */
package com.ice.tar;

import com.ice.tar.InvalidHeaderException;

public class TarHeader {
    public static final int NAMELEN = 100;
    public static final int NAMEOFFSET = 0;
    public static final int PREFIXLEN = 155;
    public static final int PREFIXOFFSET = 345;
    public static final int MODELEN = 8;
    public static final int UIDLEN = 8;
    public static final int GIDLEN = 8;
    public static final int CHKSUMLEN = 8;
    public static final int SIZELEN = 12;
    public static final int MAGICLEN = 8;
    public static final int MODTIMELEN = 12;
    public static final int UNAMELEN = 32;
    public static final int GNAMELEN = 32;
    public static final int DEVLEN = 8;
    public static final byte LF_OLDNORM = 0;
    public static final byte LF_NORMAL = 48;
    public static final byte LF_LINK = 49;
    public static final byte LF_SYMLINK = 50;
    public static final byte LF_CHR = 51;
    public static final byte LF_BLK = 52;
    public static final byte LF_DIR = 53;
    public static final byte LF_FIFO = 54;
    public static final byte LF_CONTIG = 55;
    public static final String TMAGIC = "ustar";
    public static final String GNU_TMAGIC = "ustar  ";
    public StringBuffer name;
    public int mode;
    public int userId;
    public int groupId;
    public long size;
    public long modTime;
    public int checkSum;
    public byte linkFlag;
    public StringBuffer linkName;
    public StringBuffer magic = new StringBuffer("ustar");
    public StringBuffer userName;
    public StringBuffer groupName;
    public int devMajor;
    public int devMinor;

    public TarHeader() {
        this.name = new StringBuffer();
        this.linkName = new StringBuffer();
        String string = "xmlcreator";
        if (string.length() > 31) {
            string = string.substring(0, 31);
        }
        this.userId = 0;
        this.groupId = 0;
        this.userName = new StringBuffer(string);
        this.groupName = new StringBuffer("");
    }

    public String getName() {
        return this.name.toString();
    }

    public static long parseOctal(byte[] byArray, int n, int n2) throws InvalidHeaderException {
        long l = 0L;
        boolean bl = true;
        int n3 = n + n2;
        for (int i = n; i < n3 && byArray[i] != 0; ++i) {
            if (byArray[i] == 32 || byArray[i] == 48) {
                if (bl) continue;
                if (byArray[i] == 32) break;
            }
            bl = false;
            l = (l << 3) + (long)(byArray[i] - 48);
        }
        return l;
    }

    public static StringBuffer parseFileName(byte[] byArray) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(256);
        if (byArray[345] != 0) {
            for (n = 345; n < 500 && byArray[n] != 0; ++n) {
                stringBuffer.append((char)byArray[n]);
            }
            stringBuffer.append("/");
        }
        for (n = 0; n < 100 && byArray[n] != 0; ++n) {
            stringBuffer.append((char)byArray[n]);
        }
        return stringBuffer;
    }

    public static StringBuffer parseName(byte[] byArray, int n, int n2) throws InvalidHeaderException {
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = n + n2;
        for (int i = n; i < n3 && byArray[i] != 0; ++i) {
            stringBuffer.append((char)byArray[i]);
        }
        return stringBuffer;
    }

    public static int getFileNameBytes(String string, byte[] byArray) throws InvalidHeaderException {
        if (string.length() > 100) {
            int n = string.indexOf("/", string.length() - 100);
            if (n == -1) {
                throw new InvalidHeaderException("file name is greater than 100 characters, " + string);
            }
            String string2 = string.substring(n + 1);
            String string3 = string.substring(0, n);
            if (string3.length() > 155) {
                throw new InvalidHeaderException("file prefix is greater than 155 characters");
            }
            TarHeader.getNameBytes(new StringBuffer(string2), byArray, 0, 100);
            TarHeader.getNameBytes(new StringBuffer(string3), byArray, 345, 155);
        } else {
            TarHeader.getNameBytes(new StringBuffer(string), byArray, 0, 100);
        }
        return 100;
    }

    public static int getNameBytes(StringBuffer stringBuffer, byte[] byArray, int n, int n2) {
        int n3;
        for (n3 = 0; n3 < n2 && n3 < stringBuffer.length(); ++n3) {
            byArray[n + n3] = (byte)stringBuffer.charAt(n3);
        }
        while (n3 < n2) {
            byArray[n + n3] = 0;
            ++n3;
        }
        return n + n2;
    }

    public static int getOctalBytes(long l, byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        int n3 = n2 - 1;
        byArray[n + n3] = 0;
        byArray[n + --n3] = 32;
        --n3;
        if (l == 0L) {
            byArray[n + n3] = 48;
            --n3;
        } else {
            for (long i = l; n3 >= 0 && i > 0L; i >>= 3, --n3) {
                byArray[n + n3] = (byte)(48 + (byte)(i & 7L));
            }
        }
        while (n3 >= 0) {
            byArray[n + n3] = 32;
            --n3;
        }
        return n + n2;
    }

    public static int getLongOctalBytes(long l, byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2 + 1];
        TarHeader.getOctalBytes(l, byArray2, 0, n2 + 1);
        System.arraycopy(byArray2, 0, byArray, n, n2);
        return n + n2;
    }

    public static int getCheckSumOctalBytes(long l, byte[] byArray, int n, int n2) {
        TarHeader.getOctalBytes(l, byArray, n, n2);
        byArray[n + n2 - 1] = 32;
        byArray[n + n2 - 2] = 0;
        return n + n2;
    }
}

