/*
 * Decompiled with CFR 0.152.
 */
package com.gowtham.jmp3tag;

import com.gowtham.jmp3tag.Frame;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.lcdui.Gauge;

public class Tag {
    private String file;
    private String title;
    private String album;
    private String artist;
    private String year;
    private String comment;
    private String composer;
    private boolean tagExists;
    private boolean extendedHeaderExists;
    private int tagSize;
    private long originalTagSize;
    private byte[] header;
    private byte[] extendedHeader;
    private byte[] tagData;
    private Vector frames;
    private byte[] tagSizeBuffer;
    private int padding;

    public Tag(String string) {
        this.file = string;
        this.tagExists = false;
        this.header = new byte[10];
        this.extendedHeader = new byte[10];
        this.frames = new Vector();
        this.tagSizeBuffer = new byte[4];
        this.padding = 0;
    }

    public void deleteAPICFrame() {
        this.deleteFrame("APIC");
    }

    public String getTitile() {
        return this.title;
    }

    public String getAlbum() {
        return this.album;
    }

    public String getArtist() {
        return this.artist;
    }

    public String getYear() {
        return this.year;
    }

    public String getComment() {
        return this.comment;
    }

    public String getComposer() {
        return this.composer;
    }

    public boolean tagExists() {
        return this.tagExists;
    }

    public boolean Read() throws IOException {
        FileConnection fileConnection = (FileConnection)Connector.open((String)this.file, (int)1);
        if (!fileConnection.exists()) {
            throw new IOException("File " + this.file + " does not exist!");
        }
        InputStream inputStream = fileConnection.openInputStream();
        int n = inputStream.read(this.header, 0, 3);
        if (n < 3) {
            throw new IOException("Less than 3 bytes read in the first call!");
        }
        String string = new String(this.header);
        string = string.trim();
        System.out.println("First text = " + string);
        if (string.compareTo("ID3") == 0) {
            this.tagExists = true;
            inputStream.read(this.header, 3, 7);
            System.out.println("Header = " + new String(this.header));
            this.tagSize = this.calculateTagSize(this.header, 6, 9);
            System.out.println("Tag size = " + this.tagSize);
            this.extendedHeaderExists = (this.header[5] & 0x40) != 0;
            System.out.println("Extended header = " + this.extendedHeaderExists);
            if (this.extendedHeaderExists) {
                inputStream.read(this.extendedHeader, 0, 10);
            }
            int n2 = this.tagSize;
            this.originalTagSize = n2 + 10;
            this.tagData = new byte[n2];
            inputStream.read(this.tagData, 0, n2);
            this.populateTags(this.tagData, n2);
            System.out.println("Title = [" + this.title + "]");
            System.out.println("Album = [" + this.album + "]");
            System.out.println("Artist = [" + this.artist + "]");
        }
        inputStream.close();
        fileConnection.close();
        return true;
    }

    public int calculateTagSize(byte[] byArray, int n, int n2) {
        int n3 = 0;
        for (int i = n; i <= n2; ++i) {
            int n4 = byArray[i];
            n4 &= 0x7F;
            if (i > n) {
                n3 <<= 7;
            }
            n3 += n4;
        }
        return n3;
    }

    public byte[] getFrameData(byte[] byArray, int n, int n2) {
        int n3 = n2 - n;
        byte[] byArray2 = new byte[n3 + 1];
        for (int i = n; i <= n2; ++i) {
            byArray2[i - n] = byArray[i];
        }
        return byArray2;
    }

    public void populateTags(byte[] byArray, int n) {
        int n2 = 0;
        byte[] byArray2 = new byte[4];
        byte[] byArray3 = new byte[4];
        byte[] byArray4 = new byte[2];
        while (n2 < n) {
            String string;
            byArray2 = this.getFrameData(byArray, n2 + 0, n2 + 3);
            byArray3 = this.getFrameData(byArray, n2 + 4, n2 + 7);
            byArray4 = this.getFrameData(byArray, n2 + 8, n2 + 9);
            String string2 = new String(byArray2);
            if (!Frame.isValidFrame(string2)) {
                System.out.println("Invalid frame " + string2);
                this.padding += 10;
                if (n - (n2 += 10) >= 10) continue;
                break;
            }
            System.out.println("Frame " + byArray2);
            int n3 = Frame.calculateFrameSize(byArray3, 0, 3);
            System.out.println("Size " + n3);
            byte[] byArray5 = new byte[n3];
            System.out.println("data size = " + byArray.length);
            System.out.println("i+10 = " + (n2 + 10));
            System.out.println("i+10+frameSizeInt-1 = " + (n2 + 10 + n3 - 1));
            byArray5 = this.getFrameData(byArray, n2 + 10, n2 + 10 + n3 - 1);
            boolean bl = this.isEditableTag(string2);
            if (bl) {
                string = this.myBinary2String(byArray5);
                System.out.println(string2 + " is editable");
            } else {
                string = new String(byArray5);
                System.out.println(string2 + " is NOT editable");
            }
            string = string.trim();
            System.out.println("FRAME = " + string2 + " size " + n3 + " value " + string);
            if (string2.equalsIgnoreCase("TALB")) {
                this.album = string;
            } else if (string2.equalsIgnoreCase("TCOM")) {
                this.composer = string;
            } else if (string2.equalsIgnoreCase("TIT2")) {
                this.title = string;
            } else if (string2.equalsIgnoreCase("TYER")) {
                this.year = string;
            } else if (string2.equalsIgnoreCase("COMM")) {
                if (string.startsWith("eng")) {
                    string = string.substring(string.indexOf(103) + 1);
                }
                this.comment = string;
            } else if (string2.equalsIgnoreCase("TPE1")) {
                this.artist = string;
            }
            Frame frame = new Frame(string2, byArray4, string, byArray5, bl);
            this.frames.addElement(frame);
            if (n - (n2 += n3 + 10) < 10) break;
            System.out.println("i = " + n2);
        }
    }

    public String myBinary2String(byte[] byArray) {
        int n = byArray.length;
        for (int i = 0; i < byArray.length; ++i) {
            System.out.println("Data : " + i + " " + byArray[i]);
        }
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        int n3 = 0;
        if ((byArray[0] == 1 || byArray[0] == 0) && (byArray[1] == -1 && byArray[2] == -2 || byArray[1] == -2 && byArray[2] == -1)) {
            System.out.println("Unicode");
            n3 = 3;
        }
        if (byArray[0] == 0) {
            System.out.println("ISO-8859");
            n3 = 1;
        }
        while (n3 < n) {
            if (byArray[n3] != 0) {
                byArray2[n2] = byArray[n3];
                ++n2;
            }
            ++n3;
        }
        return new String(byArray2);
    }

    public void setTitile(String string) {
        this.title = string;
        this.setFrame("TIT2", this.title);
    }

    public void setAlbum(String string) {
        this.album = string;
        this.setFrame("TALB", this.album);
    }

    public void setArtist(String string) {
        this.artist = string;
        this.setFrame("TPE1", this.artist);
    }

    public void setYear(String string) {
        this.year = string;
        this.setFrame("TYER", this.year);
    }

    public void setComment(String string) {
        byte[] byArray = new byte[]{0};
        this.comment = string;
        this.setFrame("COMM", "eng" + new String(byArray) + this.comment);
    }

    public void setComposer(String string) {
        this.composer = string;
        this.setFrame("TCOM", this.composer);
    }

    public boolean Save(Gauge gauge, boolean bl) throws IOException {
        Object object;
        int n;
        int n2;
        String string = this.file;
        int n3 = this.file.indexOf(46, 0);
        if (n3 == -1) {
            throw new IOException("File name has no . (dot)");
        }
        string = this.file.substring(0, n3) + "_edited.mp3";
        FileConnection fileConnection = (FileConnection)Connector.open((String)string, (int)3);
        if (fileConnection.exists() && !bl) {
            throw new IOException("Tags not saved because file " + string + " already exists. Set overwrite mode ON to overwrite existing files");
        }
        if (!fileConnection.exists()) {
            fileConnection.create();
        }
        FileConnection fileConnection2 = (FileConnection)Connector.open((String)this.file, (int)3);
        OutputStream outputStream = fileConnection.openOutputStream();
        InputStream inputStream = fileConnection2.openInputStream();
        long l = fileConnection2.fileSize();
        System.out.println("complieTag started");
        this.compileTag();
        System.out.println("complieTag ended");
        if (this.header[3] < 3) {
            this.header[3] = 3;
        }
        outputStream.write(this.header, 0, 6);
        outputStream.write(this.tagSizeBuffer);
        if (this.extendedHeaderExists) {
            outputStream.write(this.extendedHeader);
        }
        for (n2 = 0; n2 < this.frames.size(); ++n2) {
            System.out.println("Writing frame " + n2);
            Frame frame = (Frame)this.frames.elementAt(n2);
            outputStream.write(frame.serialize());
        }
        for (n2 = 0; n2 < this.padding; ++n2) {
            outputStream.write(0);
        }
        long l2 = l;
        if (this.tagExists) {
            long l3 = inputStream.skip(this.originalTagSize);
            if (l3 < this.originalTagSize) {
                long l4 = inputStream.skip(this.originalTagSize - l3);
                l3 += l4;
            }
            l2 -= this.originalTagSize;
        }
        long l5 = 0L;
        boolean bl2 = true;
        int n4 = 4096;
        do {
            object = new byte[n4];
            n = inputStream.read((byte[])object, 0, n4);
            int n5 = (int)((float)(l5 += (long)n) / (float)l * 100.0f);
            System.out.println("Percentage " + n5);
            gauge.setValue(n5);
            System.out.println("Read = " + n + " " + "Buffer " + ((byte[])object).length + " " + l5 + "/" + l);
            if (n == -1) continue;
            if (n < n4) {
                System.out.println("Read < size " + n + " " + n4);
                for (int i = 0; i < n; ++i) {
                    outputStream.write(object[i]);
                }
            } else {
                outputStream.write((byte[])object, 0, n);
            }
        } while (n != -1);
        inputStream.close();
        outputStream.close();
        System.out.println("Output size " + fileConnection.fileSize());
        fileConnection2.delete();
        fileConnection2.close();
        object = this.file.substring(this.file.lastIndexOf(47) + 1);
        System.out.println("Base = " + (String)object);
        fileConnection.rename((String)object);
        fileConnection.close();
        return true;
    }

    public void compileTag() {
        if (!this.tagExists()) {
            this.header[0] = 73;
            this.header[1] = 68;
            this.header[2] = 51;
            this.header[3] = 3;
            this.header[4] = 0;
            this.header[5] = 0;
            this.extendedHeaderExists = false;
        }
        System.out.println("calculateNewTagSize() started");
        this.tagSize = this.calculateNewTagSize();
        System.out.println("calculateNewTagSize() done");
        System.out.println("getTagSizeBuffer() started");
        this.tagSizeBuffer = this.getTagSizeBuffer(this.tagSize);
        System.out.println("getTagSizeBuffer() done");
    }

    private byte[] getTagSizeBuffer(int n) {
        byte[] byArray = new byte[4];
        System.out.println("X = " + n);
        for (int i = 0; i < 4; ++i) {
            byte by = (byte)(n & 0x7F);
            System.out.println(by);
            byArray[3 - i] = by;
            n >>= 7;
        }
        return byArray;
    }

    private boolean deleteFrame(String string) {
        boolean bl = false;
        for (int i = 0; i < this.frames.size(); ++i) {
            Frame frame = (Frame)this.frames.elementAt(i);
            if (!frame.getFrameID().equalsIgnoreCase(string)) continue;
            bl = true;
            this.frames.removeElement(frame);
        }
        return bl;
    }

    private int calculateNewTagSize() {
        int n = 0;
        for (int i = 0; i < this.frames.size(); ++i) {
            Frame frame = (Frame)this.frames.elementAt(i);
            int n2 = frame.getFrameSize() + 10;
            String string = frame.getFrameID();
            System.out.println("Frame " + string + " size = " + n2);
            n += n2;
        }
        System.out.println("Padding " + this.padding);
        System.out.println("New tagsize = " + (n += this.padding));
        return n;
    }

    private void setFrame(String string, String string2) {
        Object object;
        boolean bl = false;
        for (int i = 0; i < this.frames.size(); ++i) {
            object = (Frame)this.frames.elementAt(i);
            if (object.getFrameID().compareTo(string) != 0) continue;
            object.setData(string2);
            bl = true;
            break;
        }
        if (!bl) {
            object = new byte[]{false, false};
            Frame frame = new Frame(string, (byte[])object, string2, null, true);
            this.frames.addElement(frame);
        }
    }

    private boolean isEditableTag(String string) {
        Vector<String> vector = new Vector<String>();
        vector.addElement(new String("TALB"));
        vector.addElement(new String("TCOM"));
        vector.addElement(new String("COMM"));
        vector.addElement(new String("TIT2"));
        vector.addElement(new String("TPE1"));
        vector.addElement(new String("TYER"));
        for (int i = 0; i < vector.size(); ++i) {
            String string2 = (String)vector.elementAt(i);
            if (string2.compareTo(string) != 0) continue;
            return true;
        }
        return false;
    }

    public byte[] getFrame(String string) {
        for (int i = 0; i < this.frames.size(); ++i) {
            Frame frame = (Frame)this.frames.elementAt(i);
            if (frame.getFrameID().compareTo(string) != 0) continue;
            return frame.getBytes();
        }
        return null;
    }

    public void addTag(Frame frame) {
        this.frames.addElement(frame);
    }
}

