/*
 * Decompiled with CFR 0.152.
 */
package mwnw.sg;

import javax.microedition.lcdui.Graphics;
import mwnw.sg.Enemy;
import mwnw.sg.EnemySettings;
import mwnw.sg.Globals;
import mwnw.sg.Graphic;
import mwnw.sg.Point;

class EnemyMgr {
    private byte monstersSpawned = 0;
    private byte monstersToSpawn = 0;
    private byte monstersToKill = 0;
    private static final byte MAX_ENEMIES = 8;
    public static final byte AI_TYPE_NORMAL = 0;
    public static final byte AI_TYPE_MOVE_AROUND = 1;
    public static final byte AI_TYPE_MOVE_AROUND_SOMETIMES = 2;
    public static final byte AI_TYPE_BAIT = 3;
    public static final byte ENEMY_SNAKEMAN = 0;
    public static final byte ENEMY_APOPHIS = 1;
    public static final byte ENEMY_PEASANT = 2;
    public static final byte ENEMY_TARANTULA = 3;
    public static final byte ENEMY_PEON = 4;
    public static final byte ENEMY_ATEN = 5;
    public static final byte ENEMY_TARANTULA2 = 6;
    public static final byte ENEMY_GRAPHIC_TYPES = 7;
    public static final byte ENEMY_GRAPHIC_ROBOGUN = 7;
    public static final byte ENEMY_GRAPHIC_EXPLODING = 8;
    public static final byte ENEMY_GRAPHIC_BAIT = 9;
    public static final byte ENEMY_GRAPHIC_ATTRACTOR = 10;
    public static final byte ENEMY_SETTINGS_COUNT = 11;
    public static final short ENEMY_DEFAULT_ANIM_DELAY = 200;
    public static final byte ENEMY_SHOOT_DISTANCE_PIXELS = 0;
    public static final byte ENEMY_SHOOT_TOO_CLOSE_DISTANCE_PIXELS = 0;
    public static final byte ENEMY_HEIGHT_SHOOT_SPACING = 16;
    public static final short FARTHEST_AWAY = 10000;
    public static final short RUN_AWAY_MS = 2200;
    public static final byte ANIM_NOT_USED = 127;
    private static final byte MELEE_ATTACK = -2;
    public static final byte SPAWN_BOSS_LAST = -2;
    private static final byte DISTANCE_REQUIRED_FOR_BAIT_X = 30;
    private static final byte DISTANCE_REQUIRED_FOR_BAIT_Y = 20;
    private static final byte ENEMY_LOGIC_NORMAL = 0;
    private static final byte ENEMY_LOGIC_WAIT_TO_EXIT = 1;
    private static final byte ENEMY_LOGIC_SPAWN_BOSS = 2;
    private static final byte ENEMY_FANMAN_HIT_DISTANCE = 12;
    private long spawnTimer = 0L;
    private short spawnRate = (short)2100;
    private Enemy[] enemies = new Enemy[8];
    private long curTick;
    private short playerConvertedX;
    private short playerY;
    private EnemySettings[] settings = new EnemySettings[11];
    private byte monsterTypeToSpawn;
    private byte monsterTypeToSpawnSecondary;
    private byte oddsOfSpawningSecondary;
    private byte totalMonstersToKill;
    private byte monstersKilled;
    private byte maxEnemiesOnScreen;
    private byte monstersActiveNow;
    private byte monsterBulletType;
    private short tempOldX;
    private short tempOldY;
    private byte monsterBulletTypeSecondary;
    private byte logic;
    private long logicTimer;
    private Graphic[] images = new Graphic[7];

    public EnemyMgr() {
        for (byte by = 0; by < 11; by = (byte)(by + 1)) {
            this.settings[by] = new EnemySettings(by);
        }
    }

    public boolean Init() {
        try {
            this.Kill();
            this.monstersKilled = 0;
            this.monstersSpawned = 0;
            this.monstersActiveNow = 0;
            this.logic = 0;
            this.SetMonstersToKillCount(Globals.logic.monstersToKill);
            this.maxEnemiesOnScreen = (byte)this.MaxEnemiesOnScreenAdjusted(4);
            this.spawnRate = (short)this.SpawnRateAdjusted(2100);
            this.monsterBulletType = (byte)2;
            this.monsterBulletTypeSecondary = (byte)-2;
            this.monsterTypeToSpawnSecondary = (byte)127;
            this.monsterTypeToSpawn = Globals.logic.monsters[0];
            this.monsterTypeToSpawnSecondary = (byte)127;
            this.oddsOfSpawningSecondary = Globals.logic.spawnOdds;
            switch (Globals.logic.monsters[0]) {
                case 3: {
                    this.monsterBulletType = (byte)-2;
                }
            }
            if (!this.LoadMonsterType(this.monsterTypeToSpawn)) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public void Kill() {
        int n;
        for (n = 0; n < 8; ++n) {
            if (this.enemies[n] == null) continue;
            this.enemies[n].state = 0;
            if (this.enemies[n].graphic != null) {
                this.enemies[n].graphic.Kill();
            }
            this.enemies[n].graphic = null;
        }
        for (n = 0; n < 7; ++n) {
            if (this.images[n] != null) {
                this.images[n].Kill();
            }
            this.images[n] = null;
        }
        System.gc();
    }

    public boolean Add(byte by, byte by2, short s, short s2, Graphic graphic) {
        for (int i = 0; i < 8; ++i) {
            if (this.enemies[i] == null) {
                this.enemies[i] = new Enemy();
                this.enemies[i].di.index = (byte)i;
            }
            if (this.enemies[i].state != 0) continue;
            Enemy enemy = this.enemies[i];
            enemy.type = by;
            enemy.x = s;
            enemy.y = s2;
            enemy.health = this.settings[by].defaultHealth;
            enemy.subState = 0;
            enemy.state = (byte)8;
            enemy.stateTimer = 0L;
            enemy.animTimer = 0L;
            enemy.speedDivisor = this.settings[by].speedDivider;
            enemy.spawnedItem = 0;
            enemy.curAnim = 0;
            enemy.curFrame = 0;
            enemy.projectileType = by2;
            if (by == 6) {
                enemy.projectileType = (byte)-2;
            }
            enemy.timesShot = 0;
            enemy.animSpeedMs = (short)200;
            enemy.hitTimer = 0L;
            if (graphic == null) {
                if (by < 7) {
                    enemy.graphic = this.images[enemy.type];
                }
            } else {
                enemy.graphic = graphic;
            }
            this.monstersActiveNow = (byte)(this.monstersActiveNow + 1);
            return true;
        }
        return false;
    }

    public void Update() {
        int n;
        this.curTick = Globals.GetTick();
        this.playerConvertedX = Globals.curMap.WorldToScreenX(Globals.thePlayer.x);
        this.playerY = Globals.thePlayer.y;
        if (this.logic == 1) {
            if (this.logicTimer < this.curTick) {
                this.logic = (byte)2;
                Globals.runScriptASAP = true;
            }
        } else if (this.spawnTimer < this.curTick) {
            this.spawnTimer = this.curTick + (long)this.spawnRate + (long)Globals.RandInt(this.spawnRate);
            if (this.monstersSpawned < this.monstersToSpawn && this.monstersActiveNow < this.maxEnemiesOnScreen) {
                n = 0;
                short s = Globals.logic.forceSpawnX;
                short s2 = Globals.logic.forceSpawnY;
                if (s != 0 || s2 != 0) {
                    n = 1;
                } else {
                    s = (short)(Globals.thePlayer.x + Globals.screenWidth + Globals.RandInt(20));
                    s2 = (short)(Globals.thePlayer.y + Globals.RandInt(50) - 25);
                    if (Globals.RandInt(3) != 0) {
                        n = Globals.curMap.ValidPosition(s, s2) ? 1 : 0;
                    }
                    if (n == 0) {
                        s = (short)(Globals.thePlayer.x - Globals.screenWidth - Globals.RandInt(20));
                        n = Globals.curMap.ValidPosition(s, s2) ? 1 : 0;
                    }
                }
                if (n != 0) {
                    byte by = this.monsterTypeToSpawn;
                    byte by2 = this.monsterBulletType;
                    if (this.Add(by, by2, s, s2, null)) {
                        this.monstersSpawned = (byte)(this.monstersSpawned + 1);
                    } else {
                        this.spawnTimer = this.curTick + 3500L;
                    }
                }
            }
        }
        if (this.enemies != null) {
            for (n = 0; n < 8; n = (int)((byte)(n + 1))) {
                if (this.enemies[n] == null || this.enemies[n].state == 0) continue;
                switch (this.enemies[n].type) {
                    case 2: {
                        this.PeasantThink(this.enemies[n]);
                        break;
                    }
                    default: {
                        this.EnemyThink(this.enemies[n]);
                    }
                }
                this.enemies[n].di.y = this.enemies[n].y;
                Globals.drawSort.Add(this.enemies[n].di);
            }
        }
    }

    public void RenderEnemy(Graphics graphics, byte by) {
        if (this.enemies[by].state == 0 || this.enemies[by] == null) {
            return;
        }
        Point point = Globals.curMap.WorldToScreen(this.enemies[by].x, this.enemies[by].y);
        this.enemies[by].graphic.blit(graphics, point.x, point.y, this.enemies[by].curFrame, this.enemies[by].curAnim, true);
    }

    short CheckCollision(short s, short s2, short s3) {
        short s4 = Globals.curMap.WorldToScreenX(s);
        for (short s5 = 0; s5 < 8; s5 = (short)((short)(s5 + 1))) {
            if (this.enemies[s5] == null || this.enemies[s5].state == 0 || this.enemies[s5].state == 2) continue;
            short s6 = Globals.curMap.WorldToScreenX(this.enemies[s5].x);
            short s7 = (short)Math.abs(s4 - s6);
            short s8 = (short)Math.abs(s2 - this.enemies[s5].y);
            if (s7 >= s3 || s8 >= s3) continue;
            return s5;
        }
        return -1;
    }

    void AddDamageToEnemy(short s, byte by) {
        Globals.thePlayer.AddHit();
        Enemy enemy = this.enemies[s];
        if (enemy == null) {
            return;
        }
        enemy.health = (short)(enemy.health - by);
        if (enemy.health < 1) {
            enemy.animSpeedMs = this.settings[enemy.type].deathAnimMs;
            Globals.thePlayer.AddKill();
            enemy.state = (byte)2;
            this.AddTrophy(enemy);
            enemy.stateTimer = Globals.GetTick() + 5000L;
            if (enemy.lastDir == 0) {
                enemy.curAnim = this.settings[enemy.type].leftDeathAnim;
                enemy.curFrame = this.settings[enemy.type].dieLeftStartFrame;
            } else {
                enemy.curAnim = this.settings[enemy.type].rightDeathAnim;
                enemy.curFrame = this.settings[enemy.type].dieRightStartFrame;
            }
            enemy.framesInAnim = this.settings[enemy.type].deathFrames;
            enemy.animStartFrame = enemy.curFrame;
            enemy.animTimer = Globals.GetTick() + (long)enemy.animSpeedMs;
            if (enemy.type == 2) {
                Globals.GetGameCanvas().SetStatusMessage("Civilian Killed!", 0);
                this.monstersSpawned = (byte)(this.monstersSpawned - 1);
                Globals.thePlayer.civilianDeaths = (short)(Globals.thePlayer.civilianDeaths + 1);
                if (Globals.thePlayer.civilianDeaths >= 10) {
                    if (!Globals.logic.LoadScript((byte)4)) {
                        // empty if block
                    }
                    Globals.runScriptASAP = true;
                }
            }
        } else {
            enemy.targetY = 0;
            enemy.stateTimer = Globals.GetTick() + (long)this.settings[enemy.type].painStunMs;
            enemy.subState = 0;
            if (enemy.lastDir == 0) {
                enemy.curAnim = this.settings[enemy.type].walkLeftAnim;
                enemy.curFrame = this.settings[enemy.type].walkLeftStartFrame;
            } else {
                enemy.curAnim = this.settings[enemy.type].walkRightAnim;
                enemy.curFrame = this.settings[enemy.type].walkRightStartFrame;
            }
            if (enemy.hitTimer < this.curTick) {
                enemy.hitTimer = this.curTick + (long)(this.settings[enemy.type].painStunMs * 2);
                if (this.settings[enemy.type].painFrames != 127) {
                    if (enemy.lastDir == 0) {
                        enemy.curAnim = this.settings[enemy.type].painLeftAnim;
                        enemy.curFrame = this.settings[enemy.type].painLeftStartFrame;
                    } else {
                        enemy.curAnim = this.settings[enemy.type].painRightAnim;
                        enemy.curFrame = this.settings[enemy.type].painRightStartFrame;
                    }
                    enemy.framesInAnim = this.settings[enemy.type].painFrames;
                    enemy.animStartFrame = enemy.curFrame;
                    enemy.animTimer = Globals.GetTick() + 200L;
                    if (enemy.state == 8) {
                        enemy.state = (byte)5;
                    }
                }
            }
        }
    }

    Point GetXYOffsetToClosestEnemy(short s, short s2, short s3) {
        Point point = new Point();
        point.x = (short)10000;
        short s4 = Globals.curMap.WorldToScreenX(s);
        for (int i = 0; i < 8; ++i) {
            short s5;
            if (this.enemies[i] == null || this.enemies[i].state == 0 || this.enemies[i].state == 2 || this.settings[this.enemies[i].type].aiType == 3 || Math.abs((s5 = Globals.curMap.WorldToScreenX(this.enemies[i].x)) - s4) >= point.x || Math.abs(this.enemies[i].y - s2) >= s3) continue;
            point.x = (short)(s5 - s4);
            point.y = (short)(this.enemies[i].y - s2);
        }
        return point;
    }

    void ExitAndRunScript(int n) {
        this.logicTimer = Globals.GetTick() + (long)n;
        this.logic = 1;
    }

    public void SetMonstersToKillCount(byte by) {
        this.monstersSpawned = 0;
        this.monstersKilled = 0;
        this.monstersToKill = this.monstersToSpawn = this.AdjustForDifficulty(by);
    }

    private void SpawnRandomItem(Enemy enemy) {
        if (enemy == null) {
            return;
        }
        if (enemy.type == 2) {
            return;
        }
        if (Globals.RandInt(5) == 1) {
            byte by = 0;
            Globals.projectileMgr.Add((byte)1, (byte)1, by, enemy.x, enemy.y, null);
        }
    }

    private void EnemyUpdateAnim(Enemy enemy) {
        if (enemy == null) {
            return;
        }
        if (enemy.animTimer < Globals.GetTick()) {
            enemy.curFrame = (byte)(Math.abs((enemy.curFrame + 1 - enemy.animStartFrame) % enemy.framesInAnim) + enemy.animStartFrame);
            enemy.animTimer = Globals.GetTick() + (long)enemy.animSpeedMs;
        }
    }

    private void EnemyThink(Enemy enemy) {
        if (enemy == null) {
            return;
        }
        short s = Globals.curMap.WorldToScreenX(enemy.x);
        if (enemy.state == 2) {
            this.ProcessEnemyDeath(enemy);
            return;
        }
        if (enemy.stateTimer < this.curTick) {
            if (enemy.state == 8) {
                Enemy enemy2 = this.GetClosestBait(enemy);
                if (enemy2 != null) {
                    enemy.convertedTargetX = Globals.curMap.WorldToScreenX(enemy2.x);
                    enemy.targetY = enemy2.y;
                    enemy.subState = 1;
                } else {
                    enemy.state = (byte)5;
                }
                enemy.stateTimer = 0L;
            } else if (enemy.subState == 2) {
                if (this.settings[enemy.type].aiType == 1 && enemy.timesShot > 0) {
                    this.RunAwayFromPlayer(enemy);
                    enemy.stateTimer = this.curTick + 2200L + (long)Globals.RandInt(2200);
                    enemy.timesShot = 0;
                } else if (this.settings[enemy.type].aiType == 2 && enemy.timesShot > 1 && Globals.RandInt(2) == 1) {
                    this.RunAwayFromPlayer(enemy);
                    enemy.stateTimer = this.curTick + 2200L + (long)Globals.RandInt(2200);
                    enemy.timesShot = 0;
                } else {
                    this.HitCloseBait(enemy);
                    enemy.subState = 1;
                    enemy.stateTimer = this.curTick + 200L + (long)Globals.RandInt(400);
                }
            } else {
                if (enemy.targetY != 0) {
                    enemy.stateTimer = this.curTick + 200L + (long)Globals.RandInt(400);
                }
                if (enemy.state == 5) {
                    this.MoveTowardsTargetDiagonal(enemy, this.playerConvertedX, this.playerY);
                    if (Math.abs(this.playerConvertedX - s) < 0 + this.settings[enemy.type].enemyAttackDistancePixelsMod) {
                        if (Math.abs(this.playerConvertedX - s) < 0 + this.settings[enemy.type].enemyAttackTooClosePixelsMod) {
                            if (s < this.playerConvertedX) {
                                this.SetDir(enemy, (byte)0);
                            } else {
                                this.SetDir(enemy, (byte)1);
                            }
                            enemy.subState = 1;
                            enemy.stateTimer = this.curTick + 600L + (long)Globals.RandInt(2000);
                        } else {
                            boolean bl = this.IsOnSameYAsPlayer(enemy);
                            enemy.subState = 0;
                            if (!bl) {
                                enemy.framesInAnim = this.settings[enemy.type].framesInDirAnim;
                                enemy.stateTimer = this.curTick + 100L;
                                enemy.subState = 1;
                            } else {
                                enemy.dir = s - this.playerConvertedX < 0 ? (byte)1 : 0;
                                this.SetupSwing(enemy, enemy.dir);
                                if (enemy.projectileType != -2) {
                                    Globals.projectileMgr.Add(enemy.dir, (byte)1, enemy.projectileType, enemy.x, enemy.y, null);
                                }
                                enemy.animTimer = Globals.GetTick() + 200L;
                                enemy.subState = (byte)2;
                                enemy.stateTimer = (long)(this.settings[enemy.type].shootAnimFrames * enemy.animSpeedMs) + Globals.GetTick() + (long)this.settings[enemy.type].shootSpeedMs;
                                enemy.alreadyAttacked = 0;
                            }
                        }
                    } else {
                        enemy.subState = 1;
                    }
                }
            }
        }
        if (enemy.subState == 1) {
            if (enemy.targetY != 0 && enemy.stateTimer < this.curTick) {
                this.MoveTowardsTargetDiagonal(enemy, enemy.convertedTargetX, enemy.targetY);
                if (Math.abs(s - enemy.convertedTargetX) < 30 && Math.abs(enemy.y - enemy.targetY) < 20) {
                    enemy.targetY = 0;
                    this.SetupSwing(enemy, enemy.lastDir);
                    enemy.animTimer = Globals.GetTick() + 200L;
                    enemy.state = (byte)5;
                    enemy.subState = (byte)2;
                    enemy.stateTimer = (long)(this.settings[enemy.type].shootAnimFrames * enemy.animSpeedMs) + Globals.GetTick() + (long)this.settings[enemy.type].shootSpeedMs;
                    enemy.alreadyAttacked = 0;
                    return;
                }
            }
            this.EnemyUpdateAnim(enemy);
            this.tempOldX = enemy.x;
            this.tempOldY = enemy.y;
            int n = (int)(Globals.deltaMs / (long)enemy.speedDivisor);
            switch (enemy.dir) {
                case 1: {
                    enemy.lastAnim = enemy.curAnim = this.settings[enemy.type].walkRightAnim;
                    enemy.lastDir = 1;
                    enemy.x = (short)(enemy.x + n);
                    break;
                }
                case 4: {
                    enemy.lastAnim = enemy.curAnim = this.settings[enemy.type].walkRightAnim;
                    enemy.lastDir = 1;
                    enemy.x = (short)(enemy.x + n);
                    enemy.y = (short)(enemy.y - n);
                    break;
                }
                case 5: {
                    enemy.lastAnim = enemy.curAnim = this.settings[enemy.type].walkRightAnim;
                    enemy.lastDir = 1;
                    enemy.x = (short)(enemy.x + n);
                    enemy.y = (short)(enemy.y + n);
                    break;
                }
                case 7: {
                    enemy.lastAnim = enemy.curAnim = this.settings[enemy.type].walkLeftAnim;
                    enemy.lastDir = 0;
                    enemy.x = (short)(enemy.x - n);
                    enemy.y = (short)(enemy.y + n);
                    break;
                }
                case 6: {
                    enemy.lastAnim = enemy.curAnim = this.settings[enemy.type].walkLeftAnim;
                    enemy.lastDir = 0;
                    enemy.x = (short)(enemy.x - n);
                    enemy.y = (short)(enemy.y - n);
                    break;
                }
                case 0: {
                    enemy.lastAnim = enemy.curAnim = this.settings[enemy.type].walkLeftAnim;
                    enemy.lastDir = 0;
                    enemy.x = (short)(enemy.x - n);
                    break;
                }
                case 2: {
                    enemy.curAnim = enemy.lastAnim;
                    enemy.y = (short)(enemy.y - n);
                    break;
                }
                case 3: {
                    enemy.curAnim = enemy.lastAnim;
                    enemy.y = (short)(enemy.y + n);
                }
            }
            if (Globals.curMap.mapId == 0 && enemy.x > 664 && (enemy.y <= 114 || enemy.y >= 123)) {
                enemy.y = (short)120;
            }
            if (!Globals.curMap.ValidPosition(enemy.x, enemy.y)) {
                enemy.x = this.tempOldX;
                enemy.y = this.tempOldY;
                enemy.dir = Globals.RandInt(2) == 1 ? (byte)3 : (byte)2;
                enemy.stateTimer = this.curTick + 1000L + (long)Globals.RandInt(1000);
            }
        } else if (enemy.subState == 2) {
            if (enemy.lastDir == 0 && enemy.curFrame + 1 < this.settings[enemy.type].leftShootAnimStartFrame + this.settings[enemy.type].shootAnimFrames || enemy.lastDir == 1 && enemy.curFrame + 1 < this.settings[enemy.type].rightShootAnimStartFrame + this.settings[enemy.type].shootAnimFrames) {
                this.EnemyUpdateAnim(enemy);
            } else if (enemy.projectileType == -2 && enemy.alreadyAttacked == 0) {
                if (Math.abs(s - this.playerConvertedX) < 0 + this.settings[enemy.type].enemyAttackDistancePixelsMod) {
                    if (!(Math.abs(s - this.playerConvertedX) < 0 + this.settings[enemy.type].enemyAttackTooClosePixelsMod) && this.IsOnSameYAsPlayer(enemy)) {
                        Globals.thePlayer.ModifyDamage(-this.settings[enemy.type].damage);
                    }
                    enemy.alreadyAttacked = 1;
                }
                this.HitCloseBait(enemy);
                enemy.timesShot = (byte)(enemy.timesShot + 1);
            }
        }
    }

    private void SetDir(Enemy enemy, byte by) {
        if (enemy == null) {
            return;
        }
        enemy.dir = by;
        enemy.framesInAnim = this.settings[enemy.type].framesInDirAnim;
        switch (by) {
            case 1: 
            case 4: 
            case 5: {
                enemy.animStartFrame = this.settings[enemy.type].walkRightStartFrame;
                break;
            }
            case 0: 
            case 6: 
            case 7: {
                enemy.animStartFrame = this.settings[enemy.type].walkLeftStartFrame;
            }
        }
    }

    private boolean LoadMonsterType(byte by) {
        switch (by) {
            case 0: {
                if (this.images[0] == null) {
                    this.images[0] = new Graphic();
                }
                this.images[0].Load("/chars/snake.png", 10, 1);
                break;
            }
            case 4: {
                if (this.images[4] == null) {
                    this.images[4] = new Graphic();
                }
                this.images[4].Load("/chars/snake.png", 10, 1);
                break;
            }
            case 1: {
                if (this.images[1] == null) {
                    this.images[1] = new Graphic();
                }
                this.images[1].Load("/chars/apophis.png", 12, 1);
                break;
            }
            case 5: {
                if (this.images[5] == null) {
                    this.images[5] = new Graphic();
                }
                this.images[5].Load("/chars/apophis.png", 12, 1);
                break;
            }
            case 3: {
                if (this.images[3] == null) {
                    this.images[3] = new Graphic();
                }
                this.images[3].Load("/chars/taran.png", 6, 1);
                break;
            }
            case 6: {
                if (this.images[6] == null) {
                    this.images[6] = new Graphic();
                }
                this.images[6].Load("/chars/taran.png", 6, 1);
                break;
            }
            case 127: {
                break;
            }
        }
        return true;
    }

    private byte AdjustForDifficulty(byte by) {
        if (by <= 2) {
            return by;
        }
        switch (Globals.difficulty) {
            case 0: {
                return by;
            }
            case 1: {
                return (byte)(by + by / 2);
            }
            case 2: {
                return (byte)(by + by);
            }
            case 3: {
                return (byte)(by + by + by / 3);
            }
            case 4: {
                return (byte)(by * 3);
            }
        }
        return by;
    }

    private void SpawnKeycardOrAnim(Enemy enemy) {
        if (enemy == null) {
            return;
        }
        if (enemy.spawnedItem == 0) {
            enemy.spawnedItem = 1;
            this.monstersKilled = (byte)(this.monstersKilled + 1);
            if (this.monstersKilled == this.monstersToKill) {
                switch (Globals.logic.killAllBehavior) {
                    case 0: {
                        Globals.projectileMgr.Add((byte)1, (byte)1, (byte)1, enemy.x, enemy.y, null);
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        this.ExitAndRunScript(3000);
                    }
                }
            } else {
                this.SpawnRandomItem(enemy);
            }
        }
    }

    private boolean IsOnSameYAsPlayer(Enemy enemy) {
        if (enemy == null) {
            return true;
        }
        boolean bl = true;
        if (enemy.y < this.playerY - 16) {
            bl = false;
        } else if (enemy.y > this.playerY + 16) {
            bl = false;
        }
        return bl;
    }

    private void AddTrophy(Enemy enemy) {
        if (enemy == null) {
            return;
        }
        Globals.thePlayer.finalScore += this.settings[enemy.type].points;
    }

    private void RunAwayFromPlayer(Enemy enemy) {
        if (enemy == null) {
            return;
        }
        if (Globals.curMap.WorldToScreenX(enemy.x) < this.playerConvertedX) {
            this.SetDir(enemy, (byte)0);
        } else {
            this.SetDir(enemy, (byte)1);
        }
        enemy.subState = 1;
    }

    private void MoveTowardsTargetDiagonal(Enemy enemy, short s, short s2) {
        if (enemy == null) {
            return;
        }
        short s3 = (short)(Globals.curMap.WorldToScreenX(enemy.x) - s);
        short s4 = (short)(enemy.y - s2);
        if (s4 < 10 && s4 > -10) {
            if (s3 < 0) {
                this.SetDir(enemy, (byte)1);
            } else {
                this.SetDir(enemy, (byte)0);
            }
            return;
        }
        if (s3 < 0) {
            if (s4 > 0) {
                this.SetDir(enemy, (byte)4);
            } else {
                this.SetDir(enemy, (byte)5);
            }
        } else if (s4 > 0) {
            this.SetDir(enemy, (byte)6);
        } else {
            this.SetDir(enemy, (byte)7);
        }
    }

    private void SetupSwing(Enemy enemy, byte by) {
        if (enemy == null) {
            return;
        }
        if (by == 1) {
            enemy.curAnim = this.settings[enemy.type].rightShootAnim;
            enemy.curFrame = this.settings[enemy.type].rightShootAnimStartFrame;
        } else if (by == 0) {
            enemy.curAnim = this.settings[enemy.type].leftShootAnim;
            enemy.curFrame = this.settings[enemy.type].leftShootAnimStartFrame;
        }
        enemy.animStartFrame = enemy.curFrame;
        enemy.framesInAnim = this.settings[enemy.type].shootAnimFrames;
    }

    private boolean HitCloseBait(Enemy enemy) {
        if (enemy == null) {
            return false;
        }
        short s = Globals.curMap.WorldToScreenX(enemy.x);
        boolean bl = false;
        for (short s2 = 0; s2 < 8; s2 = (short)((short)(s2 + 1))) {
            short s3;
            if (this.enemies[s2] == null || this.enemies[s2].state == 0 || this.settings[this.enemies[s2].type].aiType != 3 || this.enemies[s2].health <= 0 || Math.abs((s3 = Globals.curMap.WorldToScreenX(this.enemies[s2].x)) - s) >= 30 || Math.abs(enemy.y - this.enemies[s2].y) >= 20) continue;
            this.AddDamageToEnemy(s2, this.settings[enemy.type].damage);
            bl = true;
        }
        return bl;
    }

    private void ProcessEnemyDeath(Enemy enemy) {
        if (enemy == null) {
            return;
        }
        if (enemy.curFrame + 1 < enemy.framesInAnim + enemy.animStartFrame) {
            this.EnemyUpdateAnim(enemy);
        } else {
            this.SpawnKeycardOrAnim(enemy);
        }
        if (enemy.stateTimer < this.curTick) {
            enemy.state = 0;
            this.monstersActiveNow = (byte)(this.monstersActiveNow - 1);
        }
    }

    private int MaxEnemiesOnScreenAdjusted(int n) {
        if (n == 1) {
            return 1;
        }
        switch (Globals.difficulty) {
            case 0: {
                return n;
            }
            case 1: {
                return n + 1;
            }
            case 2: {
                return n + 1;
            }
            case 3: {
                return n + 2;
            }
            case 4: {
                return n + 3;
            }
        }
        return n;
    }

    private int SpawnRateAdjusted(int n) {
        if (n == 1) {
            return 1;
        }
        switch (Globals.difficulty) {
            case 0: {
                return n;
            }
            case 1: {
                return n - n / 3;
            }
            case 2: {
                return n / 2;
            }
            case 3: {
                return n / 3;
            }
            case 4: {
                return n / 4;
            }
        }
        return n;
    }

    private void PeasantThink(Enemy enemy) {
        int n;
        if (enemy == null) {
            return;
        }
        short s = Globals.curMap.WorldToScreenX(enemy.x);
        if (enemy.state == 2) {
            this.ProcessEnemyDeath(enemy);
            return;
        }
        if (enemy.stateTimer < this.curTick) {
            enemy.stateTimer = this.curTick + 1000L + (long)Globals.RandInt(800);
            if (enemy.state == 8) {
                enemy.state = (byte)6;
                enemy.subState = 1;
            }
            if (Math.abs(this.playerConvertedX - s) > 80) {
                if (Math.abs(this.playerConvertedX - s) > 170) {
                    enemy.state = 0;
                    enemy.curFrame = (byte)127;
                    enemy.stateTimer = 0L;
                    this.ProcessEnemyDeath(enemy);
                    return;
                }
                if (this.playerConvertedX > s) {
                    this.SetDir(enemy, (byte)1);
                } else {
                    this.SetDir(enemy, (byte)0);
                }
            } else if (enemy.subState == 0) {
                n = Globals.RandInt(2);
                switch (n) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        enemy.animSpeedMs = (short)200;
                        enemy.animTimer = 0L;
                        enemy.subState = 1;
                        if (Globals.RandInt(2) == 0) {
                            this.SetDir(enemy, (byte)0);
                            break;
                        }
                        this.SetDir(enemy, (byte)1);
                    }
                }
            } else if (Globals.RandInt(2) == 0) {
                enemy.subState = 0;
                enemy.animTimer = 0L;
                this.SetIdle(enemy, enemy.dir);
            }
        }
        this.EnemyUpdateAnim(enemy);
        if (enemy.subState == 0) {
            return;
        }
        this.tempOldX = enemy.x;
        this.tempOldY = enemy.y;
        n = (int)(Globals.deltaMs / (long)enemy.speedDivisor);
        if (enemy.dir == 1) {
            enemy.lastAnim = enemy.curAnim = this.settings[enemy.type].walkRightAnim;
            enemy.lastDir = 1;
            enemy.x = (short)(enemy.x + n);
        } else if (enemy.dir == 0) {
            enemy.curAnim = this.settings[enemy.type].walkLeftAnim;
            enemy.x = (short)(enemy.x - n);
            enemy.lastAnim = enemy.curAnim;
            enemy.lastDir = 0;
        } else if (enemy.dir == 2) {
            enemy.curAnim = enemy.lastAnim;
            enemy.y = (short)(enemy.y - n);
        } else if (enemy.dir == 3) {
            enemy.curAnim = enemy.lastAnim;
            enemy.y = (short)(enemy.y + n);
        }
        if (!Globals.curMap.ValidPosition(enemy.x, enemy.y)) {
            enemy.x = this.tempOldX;
            enemy.y = this.tempOldY;
            if (Globals.RandInt(2) == 0) {
                this.SetDir(enemy, (byte)0);
            } else {
                this.SetDir(enemy, (byte)1);
            }
        }
    }

    private void SetIdle(Enemy enemy, byte by) {
        if (enemy == null) {
            return;
        }
        enemy.dir = by;
        enemy.framesInAnim = (byte)2;
        enemy.animSpeedMs = (short)600;
        if (enemy.dir == 1) {
            enemy.animStartFrame = (byte)8;
        } else if (enemy.dir == 0) {
            enemy.animStartFrame = (byte)10;
        }
    }

    private Enemy GetClosestBait(Enemy enemy) {
        if (enemy == null) {
            return null;
        }
        int n = 10000;
        short s = Globals.curMap.WorldToScreenX(enemy.x);
        Enemy enemy2 = null;
        for (int i = 0; i < 8; ++i) {
            short s2;
            if (this.enemies[i] == null || this.enemies[i].state == 0 || this.enemies[i].state == 2 || this.settings[this.enemies[i].type].aiType != 3 || Math.abs((s2 = Globals.curMap.WorldToScreenX(this.enemies[i].x)) - s) >= n) continue;
            enemy2 = this.enemies[i];
            n = s2 - s;
        }
        return enemy2;
    }
}

