/*
 * Decompiled with CFR 0.152.
 */
package mwnw.sg;

import java.util.Random;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.midlet.MIDlet;
import mwnw.sg.GameCanvas;
import mwnw.sg.Globals;
import mwnw.sg.ResMgr;
import mwnw.sg.SoundPlayer;
import mwnw.sg.SplashCanvas;

public class Stargate
extends MIDlet
implements CommandListener {
    private Form menuForm;
    private List menuList;
    public static final int MENU_PREVIOUS = -1;
    private int prevState = 0;
    private static final byte MISSIONS_PER_DOWNLOAD = 2;
    private boolean isFirst = false;

    public Stargate() {
        Globals.display = Display.getDisplay((MIDlet)this);
        Globals.paused = false;
        Globals.app = this;
        Globals.rand = new Random();
        Globals.rand.setSeed(System.currentTimeMillis());
        try {
            this.InitResourceManager();
            Globals.resources.LoadSettings();
            SoundPlayer.loadSounds();
            SoundPlayer.valid = false;
        }
        catch (Exception exception) {
            Globals.ShowError(exception.getMessage());
        }
    }

    private void InitResourceManager() {
        if (Globals.resources != null) {
            Globals.resources.Close();
            Globals.resources = null;
            System.gc();
        }
        if (!(Globals.resources = new ResMgr()).InitRecordStore()) {
            this.ExitMIDlet();
        }
    }

    public void startApp() {
        if (!Globals.paused) {
            if (!this.isFirst) {
                this.StartSplash(1, false, (byte)2);
            }
        } else {
            this.isFirst = true;
            Globals.paused = false;
            if (Globals.CurrentCanvas() != null) {
                if (Globals.GetSplashCanvas() != null) {
                    Globals.display.setCurrent((Displayable)Globals.CurrentCanvas());
                    Globals.GetSplashCanvas().resume();
                } else if (Globals.GetGameCanvas().timer != null || Globals.isLoading) {
                    Globals.display.setCurrent((Displayable)Globals.CurrentCanvas());
                    if (Globals.gameState == 0 && !Globals.isLoading) {
                        Globals.GetGameCanvas().pause();
                        Globals.app.ShowMenu(22, 0);
                    } else if (!Globals.isLoading && Globals.gameState != 9 && Globals.gameState != 8) {
                        Globals.GetGameCanvas().resume();
                    }
                } else if (Globals.splashLoading) {
                    this.ShowMenu(2, 0);
                } else {
                    this.ShowMenu(Globals.gameState, 0);
                }
            } else if (Globals.splashLoading) {
                this.ShowMenu(2, 0);
            } else {
                this.ShowMenu(Globals.gameState, 0);
            }
        }
    }

    public void StartSplash(int n, boolean bl, byte by) {
        Globals.KillCurrentCanvas();
        System.gc();
        Globals.SetCanvas(new SplashCanvas(n, bl, by));
        Globals.display.setCurrent((Displayable)Globals.CurrentCanvas());
    }

    public void EndSplash(byte by) {
        Globals.KillCurrentCanvas();
        this.ShowMenu(by, 0);
        SoundPlayer.playMidi(SoundPlayer.THEME);
        System.gc();
    }

    public void pauseApp() {
        SoundPlayer.stopPlayer();
        Globals.paused = true;
    }

    public void destroyApp(boolean bl) {
        if (Globals.resources != null) {
            Globals.resources.Close();
            Globals.resources = null;
            System.gc();
        }
        this.notifyDestroyed();
    }

    public void ExitMIDlet() {
        this.destroyApp(true);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (!Globals.enterInput) {
            return;
        }
        if (command == List.SELECT_COMMAND || command.getCommandType() == 4) {
            if (this.menuList != null) {
                this.HandleMenuSelect(this.menuList.getSelectedIndex());
            } else {
                this.HandleMenuSelect(0);
            }
            return;
        }
        if (command.getCommandType() == 2) {
            this.HandleMenuSelect(-1);
            return;
        }
        if (command.getCommandType() == 7) {
            if (Globals.gameState != 11) {
                this.ShowMenu(11, 0);
            }
            return;
        }
    }

    public void HandleMenuSelect(int n) {
        block0 : switch (Globals.gameState) {
            case 2: {
                switch (n) {
                    case -1: 
                    case 4: {
                        this.ShowMenu(11, 0);
                        break;
                    }
                    case 0: {
                        this.ShowMenu(7, 0);
                        break;
                    }
                    case 1: {
                        this.ShowMenu(4, 0);
                        break;
                    }
                    case 2: {
                        this.ShowMenu(13, 0);
                        break;
                    }
                    case 3: {
                        this.ShowMenu(12, 0);
                    }
                }
                break;
            }
            case 7: {
                if (n == -1) {
                    this.ShowMenu(2, 0);
                    break;
                }
                Globals.difficulty = (byte)n;
                this.ShowMenu(20, 0);
                break;
            }
            case 8: {
                break;
            }
            case 22: {
                this.KillActiveMenu();
                switch (n) {
                    case 0: {
                        Globals.display.setCurrent((Displayable)Globals.CurrentCanvas());
                        Globals.GetGameCanvas().resume();
                        return;
                    }
                    case 1: {
                        if (Globals.logic != null) {
                            Globals.logic.ResetLevel();
                        } else {
                            Globals.KillGame();
                        }
                        SoundPlayer.playMidi(SoundPlayer.THEME);
                        Globals.PauseTimer(false);
                        this.ShowMenu(2, 0);
                    }
                }
                break;
            }
            case 9: {
                break;
            }
            case 11: {
                if (n == -1) {
                    this.ShowMenu(2, 0);
                    break;
                }
                switch (n) {
                    case 0: {
                        this.ShowMenu(this.prevState, 0);
                        break block0;
                    }
                    case 1: {
                        this.ExitMIDlet();
                        return;
                    }
                }
                break;
            }
            case 12: 
            case 13: {
                this.ShowMenu(2, 0);
                break;
            }
            case 14: {
                switch (n) {
                    case -1: {
                        this.ShowMenu(4, 0);
                        return;
                    }
                    case 0: {
                        Globals.soundActive = true;
                        break;
                    }
                    case 1: {
                        Globals.soundActive = false;
                    }
                }
                Globals.resources.SaveSettings();
                this.ShowMenu(4, 0);
                break;
            }
            case 6: {
                switch (n) {
                    case -1: {
                        this.ShowMenu(4, 0);
                        return;
                    }
                    case 0: {
                        SoundPlayer.playMidi(SoundPlayer.THEME);
                        Globals.vibrateActive = true;
                        SoundPlayer.playMidi(SoundPlayer.THEME);
                        break;
                    }
                    case 1: {
                        SoundPlayer.stopPlayer();
                        Globals.vibrateActive = false;
                    }
                }
                if (ResMgr.memoryFull) {
                    this.ShowMenu(25, 0);
                    break;
                }
                Globals.resources.SaveSettings();
                this.ShowMenu(4, 0);
                break;
            }
            case 25: {
                this.ShowMenu(2, 0);
                break;
            }
            case 18: {
                break;
            }
            case 20: {
                if (n == -1) {
                    this.ShowMenu(7, 0);
                    return;
                }
                Globals.missionId = (byte)n;
                this.StartGame((byte)n);
                break;
            }
            case 4: {
                if (SoundPlayer.valid) {
                    if (n == 2 || n == -1) {
                        this.ShowMenu(2, 0);
                    } else if (n == 0) {
                        this.ShowMenu(14, 0);
                    } else {
                        this.ShowMenu(6, 0);
                    }
                    return;
                }
                if (n == 1 || n == -1) {
                    this.ShowMenu(2, 0);
                    break;
                }
                this.ShowMenu(6, 0);
                break;
            }
            case 21: {
                break;
            }
            case 23: {
                this.ShowMenu(4, 0);
                break;
            }
            case 24: {
                this.ShowMenu(2, 0);
            }
        }
    }

    public void KillActiveMenu() {
        if (this.menuForm != null) {
            Globals.ClearCommands((Displayable)this.menuForm);
            this.menuForm = null;
        }
        if (this.menuList != null) {
            Globals.ClearCommands((Displayable)this.menuList);
            this.menuList = null;
        }
        System.gc();
    }

    public void ShowMenu(int n, int n2) {
        this.KillActiveMenu();
        String string = "In order to download a mission pack, enable network access when prompted.";
        Globals.isLoading = false;
        switch (n) {
            case 2: {
                this.menuList = new List("Stargate SG-1(TM)", 3, new String[]{"New Game", "Settings", "Help", "Credits", "Exit"}, null);
                Globals.enterInput = true;
                break;
            }
            case 4: {
                String[] stringArray = null;
                stringArray = SoundPlayer.valid ? new String[]{"Sound", "Vibration", "Back"} : new String[]{"Sound", "Back"};
                this.menuList = new List("Settings Menu: ", 3, stringArray, null);
                break;
            }
            case 6: {
                this.menuList = new List("Sound: ", 3, new String[]{"On", "Off"}, null);
                break;
            }
            case 14: {
                this.menuList = new List("Sound: ", 3, new String[]{"On", "Off"}, null);
                break;
            }
            case 7: {
                this.menuList = new List("Difficulty: ", 3, new String[]{"Super Easy", "Easy", "Normal", "Hard", "Very Hard"}, null);
                break;
            }
            case 11: {
                this.prevState = Globals.gameState;
                this.menuList = new List("Exit?", 3, new String[]{"No", "Yes"}, null);
                break;
            }
            case 22: {
                this.menuList = new List("Paused:", 3, new String[]{"Continue", "End Mission"}, null);
                break;
            }
            case 12: {
                String string2 = "Stargate SG-1 (TM)\n\nVersion " + this.getAppProperty("MIDlet-Version") + '\n' + '\n' + "J2ME Version licensed to Skyzone Entertainment." + '\n' + '\n' + "www.skyzonemobile.com" + '\n' + '\n' + "Produced under license from MGM Interactive." + '\n' + "-------------" + '\n' + "Producer:" + '\n' + "Andreas Vahsen" + '\n' + '\n' + "machineworksnorthwest.com" + '\n' + '\n' + "Project Manager:" + '\n' + "Kalvin Kim" + '\n' + '\n' + "Programmer:" + '\n' + "Mark Fassett" + '\n' + '\n' + "BREW Programming:" + '\n' + "Seth Robinson" + '\n' + '\n' + "Level Editor:" + '\n' + "Ben Milstead" + '\n' + '\n' + "Artists:" + '\n' + "Les Pardue" + '\n' + "Weston Tracy" + '\n' + "Akiko Robinson" + '\n' + '\n' + "QA:" + '\n' + "Charles Shin" + '\n' + '\n' + "Ported by:" + '\n' + "Joon Im";
                StringItem stringItem = new StringItem(null, string2);
                this.menuForm = new Form("Credits:");
                this.menuForm.append((Item)stringItem);
                break;
            }
            case 13: {
                String string3 = "Select/OK - Fire\nControl Pad - Movement\n\n-- Numeric Pad --\n\n2(up) - Move Up\n8(down) - Move Down\n4(left) - Move Left\n6(right) - Move Right\n5 - Fire\n\nSkip cutscenes with the fire button\n\nHelp:\nsupport@skyzonemobile.com";
                if (Globals.screenWidth > 200) {
                    string3 = "Select/OK - Fire\nControl Pad - Movement\n\n\nW(up) - Move Up\nX(down) - Move Down\nA(left) - Move Left\nD(right) - Move Right\nS - Fire\n\nSkip cutscenes with the fire button\n\nHelp:\nsupport@skyzonemobile.com";
                }
                StringItem stringItem = new StringItem(null, string3);
                this.menuForm = new Form("Help:");
                this.menuForm.append((Item)stringItem);
                break;
            }
            case 25: {
                String string4 = "Memory is Full\nCannot Save\nInformation\n";
                StringItem stringItem = new StringItem(null, string4);
                this.menuForm = new Form("Message:");
                this.menuForm.append((Item)stringItem);
                break;
            }
            case 23: {
                String string5 = "Required resources failed to download.\n" + string + '\n' + "Please exit the game and restart.";
                StringItem stringItem = new StringItem(null, string5);
                this.menuForm = new Form("Download Error");
                this.menuForm.append((Item)stringItem);
                break;
            }
            case 24: {
                StringItem stringItem = new StringItem(null, Globals.errorString);
                this.menuForm = new Form("Error");
                this.menuForm.append((Item)stringItem);
                break;
            }
            case 20: {
                String string6 = "Mission ";
                int n3 = Globals.resources.downloadId * 2;
                this.menuList = new List("Choose Mission: ", 3, new String[]{string6 + 1, string6 + 2, string6 + 3, string6 + 4, string6 + 5, string6 + 6}, null);
                Globals.buildStargate = false;
                break;
            }
            case 21: {
                this.ShowMenu(2, 0);
                SoundPlayer.playMidi(SoundPlayer.THEME);
                SoundPlayer.playMidi(SoundPlayer.THEME);
                return;
            }
        }
        if (this.menuForm != null) {
            Globals.display.setCurrent((Displayable)this.menuForm);
            Globals.SetCommands(n, (Displayable)this.menuForm, this);
        }
        if (this.menuList != null) {
            Globals.display.setCurrent((Displayable)this.menuList);
            Globals.SetCommands(n, (Displayable)this.menuList, this);
        }
        Globals.gameState = (byte)n;
        Globals.splashLoading = false;
    }

    public void StartGame(byte by) {
        this.KillActiveMenu();
        if (Globals.CurrentCanvas() != null) {
            Globals.KillCurrentCanvas();
            System.gc();
        }
        Globals.SetCanvas(new GameCanvas());
        GameCanvas gameCanvas = Globals.GetGameCanvas();
        Globals.isLoading = true;
        Globals.display.setCurrent((Displayable)gameCanvas);
        gameCanvas.LoadMission(by);
        gameCanvas.resume();
    }
}

