/*
 * Decompiled with CFR 0.152.
 */
import java.util.Hashtable;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;

public class M4ATagger
extends FileBrowser
implements CommandListener {
    private static final String APP_TITLE = "M4A Tag Editor Ru by [M.A.X]";
    private static final String M4A = "m4a";
    private static final String TAG_TITLE = "\u00a9nam";
    private static final String TAG_ARTIST = "\u00a9ART";
    private static final String TAG_ALBUM = "\u00a9alb";
    private Form frmView;
    private Command cmdClose;
    private Command cmdSave;
    private TextField tbFileName;
    private TextField tbTitle;
    private TextField tbArtist;
    private TextField tbAlbum;
    private M4ATagReader tagReader;
    private M4ATagWriter tagWriter;
    private int tagDataLength = 0;
    private Hashtable tags;

    protected String getTitle() {
        return APP_TITLE;
    }

    protected String getExtension() {
        return M4A;
    }

    public void viewFile(String fileName) {
        if (this.frmView != null) {
            this.frmView.setTitle(APP_TITLE);
            this.tbFileName.setString(fileName);
            this.tbTitle.setString("");
            this.tbArtist.setString("");
            this.tbAlbum.setString("");
        } else {
            this.frmView = new Form("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440");
            this.cmdClose = new Command("\u041d\u0430\u0437\u0430\u0434", 2, 1);
            this.cmdSave = new Command("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c", 4, 1);
            this.frmView.addCommand(this.cmdClose);
            this.frmView.addCommand(this.cmdSave);
            this.frmView.setCommandListener((CommandListener)this);
            this.tbFileName = new TextField("\u0418\u043c\u044f", fileName, 255, 131072);
            this.tbTitle = new TextField("\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a", "", 255, 0);
            this.tbArtist = new TextField("\u0410\u0440\u0442\u0438\u0441\u0442", "", 255, 0);
            this.tbAlbum = new TextField("\u0410\u043b\u044c\u0431\u043e\u043c", "", 255, 0);
            this.frmView.append((Item)this.tbFileName);
            this.frmView.append((Item)this.tbTitle);
            this.frmView.append((Item)this.tbArtist);
            this.frmView.append((Item)this.tbAlbum);
            this.tags = new Hashtable(4);
            this.tagReader = new M4ATagReader();
            this.tagWriter = new M4ATagWriter();
        }
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.frmView);
        this.tags.clear();
        this.tags.put(TAG_TITLE, "");
        this.tags.put(TAG_ARTIST, "");
        this.tags.put(TAG_ALBUM, "");
        this.tagDataLength = this.tagReader.readTags("file://localhost/" + this.getCurrentDirName() + fileName, this.tags);
        this.tbTitle.setString((String)this.tags.get(TAG_TITLE));
        this.tbArtist.setString((String)this.tags.get(TAG_ARTIST));
        this.tbAlbum.setString((String)this.tags.get(TAG_ALBUM));
    }

    private void saveTags() {
        List frmSelect = this.getSelectionForm();
        String currFile = frmSelect.getString(frmSelect.getSelectedIndex());
        Alert frmWriting = new Alert("\u0417\u0430\u043f\u0438\u0441\u044c \u0442\u0435\u0433\u043e\u0432", "\u0416\u0434\u0438\u0442\u0435...", null, AlertType.WARNING);
        Gauge pbWriting = new Gauge(null, false, -1, 2);
        frmWriting.setIndicator(pbWriting);
        Display.getDisplay((MIDlet)this).setCurrent(frmWriting, (Displayable)frmSelect);
        this.tags.put(TAG_TITLE, this.tbTitle.getString());
        this.tags.put(TAG_ARTIST, this.tbArtist.getString());
        this.tags.put(TAG_ALBUM, this.tbAlbum.getString());
        boolean doneOK = false;
        try {
            doneOK = this.tagWriter.writeTags("file://localhost/" + this.getCurrentDirName() + currFile, this.tags, this.tagDataLength);
        }
        catch (Exception e) {
            e.printStackTrace();
            doneOK = false;
        }
        frmWriting.setIndicator(null);
        if (doneOK) {
            frmWriting.setType(AlertType.INFO);
            frmWriting.setString("\u0422\u0435\u0433\u0438 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0437\u0430\u043f\u0438\u0441\u0430\u043d\u044b.");
        } else {
            frmWriting.setType(AlertType.ERROR);
            frmWriting.setString("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u0438\u0441\u0438 \u0442\u0435\u0433\u043e\u0432!");
        }
        frmWriting.setTimeout(3000);
    }

    public void commandAction(Command arg0, Displayable arg1) {
        if (arg0 == this.cmdClose) {
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.getSelectionForm());
        } else if (arg0 == this.cmdSave) {
            new Thread(new Runnable(){

                public void run() {
                    M4ATagger.this.saveTags();
                }
            }).start();
        } else {
            super.commandAction(arg0, arg1);
        }
    }
}

