/*
 * Decompiled with CFR 0.152.
 */
package z;

import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import z.Console;
import z.Math3D;
import z.Resources;
import z.SniperMIDlet;

public class LoadingCanvas
extends Canvas
implements Runnable {
    private static final int _Bullet_W_ = 4;
    private static final int _Bar_W_ = 126;
    private static final int _Bar_H_ = 29;
    private static final int _Bar_X_ = 57;
    private static final int _Gap_Y_ = 10;
    private static final int _Bar_Y_ = 281;
    private static final int _Bullet_X_ = 59;
    private static final int _Bullet_Y_ = 284;
    private static final int _Vertical_Gap_ = 10;
    private static final int _H_Gap1_ = 10;
    private static final int _H_Gap2_ = 10;
    private static final int _Width_To_Fill_ = 120;
    private static final int _Bullets_Number_ = 24;
    private static final int _Hint_W_ = 220;
    private static final int _Hint_H_ = 271;
    private static final int _Hint_X_ = 10;
    private static final int _Hint_Y_ = 10;
    private static final long _Wait_Time_ = 500L;
    private int totalSteps;
    private int actualStep;
    private int bulletsToRender;
    private boolean firstTime;
    private boolean stepUpdated;
    private boolean running;
    private boolean finalStepReached;
    private long initTime;
    private String hintToRender;
    private Image iLoadingBar;
    private Image iBullet;

    public LoadingCanvas() {
        this.setFullScreenMode(true);
        this.hintToRender = this.selectHintToRender();
        this.bulletsToRender = 0;
        this.actualStep = 0;
        this.firstTime = true;
        this.running = false;
        this.finalStepReached = false;
        this.stepUpdated = false;
        this.loadLoadingCanvasResources();
    }

    public final void unloadLoadingCanvasResources() {
        this.iLoadingBar = null;
        this.iBullet = null;
        this.hintToRender = null;
        SniperMIDlet.cleanMemory();
    }

    private final String selectHintToRender() {
        int hintIndex = Math3D.getRandNumber(43, 47);
        return Resources.getString(32) + "\n\n" + Resources.getString(hintIndex);
    }

    public final void loadLoadingCanvasResources() {
        this.iBullet = Resources.loadImage("/x/bulletBar.png");
        this.iLoadingBar = Resources.loadImage("/x/emptyBar.png");
    }

    public final void setNumberOfSteps(int aStepNumber) {
        this.totalSteps = aStepNumber;
    }

    protected void keyPressed(int keyCode) {
    }

    protected void keyReleased(int keyCode) {
    }

    public void udpateActualStep() {
        ++this.actualStep;
        if (this.actualStep == this.totalSteps) {
            this.finalStepReached = true;
            this.initTime = System.currentTimeMillis();
            float coef = (float)this.actualStep * 1.0f / ((float)this.totalSteps * 1.0f);
            this.bulletsToRender = Math3D.linearInterpolation(0, 24, coef);
            this.stepUpdated = true;
        } else {
            float coef = (float)this.actualStep * 1.0f / ((float)this.totalSteps * 1.0f);
            this.bulletsToRender = Math3D.linearInterpolation(0, 24, coef);
            this.stepUpdated = true;
            this.repaint();
        }
    }

    protected final void paint(Graphics g) {
        if (this.firstTime) {
            g.setColor(-16777216);
            g.fillRect(0, 0, 240, 320);
            this.renderHint(g);
            this.renderEmptyBar(g);
            this.firstTime = false;
        }
        this.renderActualProgress(g);
        Console.draw(g);
    }

    private final void renderHint(Graphics g) {
        g.setClip(0, 0, 240, 320);
        SniperMIDlet.gameFont.drawString(g, this.hintToRender, 10, 10, 220, 271, 3);
    }

    private final void renderEmptyBar(Graphics g) {
        g.drawImage(this.iLoadingBar, 57, 281, 20);
    }

    private final void renderActualProgress(Graphics g) {
        if (this.stepUpdated) {
            for (int i = 0; i < this.bulletsToRender; ++i) {
                g.drawImage(this.iBullet, 59 + i * 5, 284, 20);
            }
            g.drawImage(this.iLoadingBar, 57, 281, 20);
            this.stepUpdated = false;
        }
    }

    private final void updateProgressBar() {
        long elapsedTime;
        if (this.finalStepReached && (elapsedTime = System.currentTimeMillis() - this.initTime) > 500L) {
            this.running = false;
        }
    }

    public final boolean loadingCanvasRunning() {
        return this.running;
    }

    public final void run() {
        try {
            this.running = true;
            while (this.running) {
                this.updateProgressBar();
                this.repaint();
                try {
                    Thread.sleep(75L);
                }
                catch (InterruptedException ie) {}
            }
            this.unloadLoadingCanvasResources();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

