/*
 * Decompiled with CFR 0.152.
 */
package SAF_Engine;

import SAF_Core.C;
import SAF_Engine.Layer;
import SAF_Engine.LayerCollision;
import SAF_Engine.LayerTemplates;
import SAF_Engine.LayerTile;
import SAF_Engine.LayerTrigger;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.util.Vector;

public class Core {
    public static final String N = "";
    public static final String EXT = ".slf";
    private Vector layers = new Vector();

    private Layer layerCreate(DataInputStream dataInputStream) {
        Layer layer = null;
        try {
            byte[] byArray = new byte[]{dataInputStream.readByte(), dataInputStream.readByte(), dataInputStream.readByte()};
            switch (Layer.getLayerType(byArray)) {
                case 0: {
                    layer = new LayerTile();
                    break;
                }
                case 2: {
                    layer = new LayerCollision();
                    break;
                }
                case 3: {
                    layer = new LayerTrigger();
                    break;
                }
                case 4: {
                    layer = new LayerTemplates();
                }
            }
            if (layer != null) {
                ((Layer)layer).init(dataInputStream);
            }
        }
        catch (Exception exception) {
            layer = null;
        }
        return layer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadLevel(String string) {
        InputStream inputStream = null;
        FilterInputStream filterInputStream = null;
        try {
            inputStream = C.getMidlet().getClass().getResourceAsStream(string);
            filterInputStream = new DataInputStream(inputStream);
            ((DataInputStream)filterInputStream).readByte();
            ((DataInputStream)filterInputStream).readByte();
            ((DataInputStream)filterInputStream).readByte();
            ((DataInputStream)filterInputStream).readByte();
            int n = ((DataInputStream)filterInputStream).readByte();
            for (int i = 0; i < n; ++i) {
                this.addLayer(this.layerCreate((DataInputStream)filterInputStream));
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (filterInputStream != null) {
                    filterInputStream.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void addLayer(Layer layer) {
        this.layers.addElement(layer);
    }

    public void insertLayer(Layer layer, int n) {
        this.layers.insertElementAt(layer, n);
    }

    public Layer getLayer(int n) {
        return (Layer)this.layers.elementAt(n);
    }

    public void removeLayer(int n) {
        try {
            this.layers.removeElementAt(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

