/*
 * Decompiled with CFR 0.152.
 */
package bbs.framework.models;

import bbs.framework.helper.BBSKeys;
import bbs.framework.interfaces.BBSIMenu;
import bbs.framework.models.BBSGame;
import java.util.Hashtable;
import javax.microedition.lcdui.Graphics;

public abstract class BBSMenu
implements BBSIMenu {
    protected Hashtable imgCache = new Hashtable();
    protected int lastGameState;
    protected String[][] menus = this.getMenuSchema();
    protected int directory = 1;
    protected int selection = 1;

    public BBSMenu(BBSGame game) {
        this.lastGameState = game.gameState;
        game.gameState = 1;
        this.initialize(game);
    }

    protected void drawMenuItems(BBSGame game, Graphics g, int x, int y, int align, int hSpace, int passiveFont, int activeFont, int shadowFont) {
        for (int cnt = 0; cnt < this.menus[this.directory - 1].length; ++cnt) {
            int font = passiveFont;
            if (cnt == this.selection - 1) {
                font = activeFont;
            }
            if (shadowFont != 0) {
                game.drawText(g, x + 2, y + cnt * hSpace + 2, this.menus[this.directory - 1][cnt], null, shadowFont, align);
            }
            game.drawText(g, x, y + cnt * hSpace, this.menus[this.directory - 1][cnt], null, font, align);
        }
    }

    public final void freeResources(BBSGame game) {
        this.imgCache.clear();
        System.gc();
        game.gameState = this.lastGameState;
    }

    public void initialize(BBSGame game) {
    }

    public abstract String[][] getMenuSchema();

    public abstract void doMenuAction(BBSGame var1, int var2, int var3);

    public abstract void menuClosed(BBSGame var1);

    public abstract void doAnimation(BBSGame var1, int var2);

    public abstract void drawScreen(BBSGame var1, Graphics var2);

    public abstract void keyPress(BBSGame var1, BBSKeys var2, int var3);
}

