/*
 * Decompiled with CFR 0.152.
 */
package bbs.framework.library;

import bbs.framework.library.BBSFonts;
import bbs.framework.models.BBSGame;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class BBSBaloon {
    private String[][] dText;
    private int fDelay;
    private long lastShown;
    private int slide;
    private int[][] bSize;
    private int bFont;
    private int cr = 255;
    private int cg = 255;
    private int cb = 255;
    private int x1;
    private int x2;
    private int y1;
    private int y2;
    private int x3;
    private int y3;
    private int index;
    private int xCenter;
    private int yTop;

    public void initialize(BBSGame game, String[] texts, int limitWidth, int delay, int font) {
        BBSFonts fonts = game.loadFont(font);
        if (fonts.fontSet != null) {
            this.dText = null;
            this.bSize = null;
            this.bFont = font;
            this.fDelay = delay;
            Vector<String> vText = new Vector<String>();
            this.lastShown = 0L;
            this.slide = -1;
            this.dText = new String[texts.length][];
            this.bSize = new int[texts.length][2];
            if (limitWidth == 0) {
                limitWidth = game.w - 10;
            }
            for (int cnt = 0; cnt < texts.length; ++cnt) {
                int lastDivide = 0;
                int lastBlank = 0;
                int totalWidth = 0;
                int rows = 0;
                for (int lastStop = 0; lastStop < texts[cnt].length(); ++lastStop) {
                    char c = texts[cnt].charAt(lastStop);
                    this.index = fonts.letters.indexOf(c);
                    if (this.index >= 0) {
                        totalWidth += 7 * fonts.map[this.index][2] / 10;
                    }
                    if (lastStop == texts[cnt].length() - 1 || c == ' ' || c == ',' || c == '.') {
                        lastBlank = lastStop;
                    }
                    if (lastStop != texts[cnt].length() - 1 && totalWidth <= limitWidth) continue;
                    vText.addElement(texts[cnt].substring(lastDivide, lastBlank + 1).trim());
                    lastStop = lastDivide = lastBlank + 1;
                    this.bSize[cnt][0] = Math.max(this.bSize[cnt][0], Math.max(80, totalWidth + 20));
                    this.bSize[cnt][1] = ++rows * fonts.map[lastStop][3];
                    totalWidth = 0;
                }
                Object[] result = new String[vText.size()];
                vText.copyInto(result);
                this.dText[cnt] = result;
                vText.removeAllElements();
            }
            vText = null;
            fonts = null;
        }
    }

    public void setColor(int r, int g, int b) {
        this.cr = r;
        this.cg = g;
        this.cb = b;
    }

    public void restart() {
        this.slide = -1;
        this.lastShown = 0L;
    }

    public boolean isFinished() {
        return this.slide == this.dText.length;
    }

    public int getSlideNo() {
        return this.slide;
    }

    public void nextSlide(BBSGame game) {
        if (this.dText != null && this.slide < this.dText.length) {
            ++this.slide;
            this.lastShown = game.currentTimeMillis;
        }
    }

    public void draw(BBSGame game, Graphics g, int x, int y, boolean overlay) {
        if (this.dText != null) {
            if (this.slide < this.dText.length && game.currentTimeMillis > this.lastShown + (long)this.fDelay) {
                ++this.slide;
                this.lastShown = game.currentTimeMillis;
            }
            if (this.slide < this.dText.length && this.dText[this.slide].length > 0) {
                if (overlay) {
                    this.xCenter = Math.min(game.w - this.bSize[this.slide][0] / 2, Math.max(this.bSize[this.slide][0] / 2, x));
                    this.yTop = Math.max(0, y - this.bSize[this.slide][1] - 20);
                    this.x1 = this.xCenter - 30;
                    this.y1 = this.yTop + this.bSize[this.slide][1];
                    this.x2 = this.xCenter - 10;
                    this.y2 = this.yTop + this.bSize[this.slide][1];
                    this.x3 = Math.min(this.xCenter + 30, Math.max(this.xCenter - 50, x));
                    this.y3 = Math.min(game.h, Math.max(0, y));
                } else {
                    this.xCenter = Math.min(game.tileSet.fullW - this.bSize[this.slide][0] / 2, Math.max(this.bSize[this.slide][0] / 2, x)) - game.tileSet.x;
                    this.yTop = Math.min(game.tileSet.fullH - this.bSize[this.slide][1], Math.max(0, y - this.bSize[this.slide][1] - 20 - game.tileSet.y));
                    this.x1 = this.xCenter - 30;
                    this.y1 = this.yTop + this.bSize[this.slide][1];
                    this.x2 = this.xCenter - 10;
                    this.y2 = this.yTop + this.bSize[this.slide][1];
                    this.x3 = Math.min(this.xCenter + 30, Math.max(this.xCenter - 50, x - game.tileSet.x));
                    this.y3 = this.yTop + this.bSize[this.slide][1] + 20;
                }
                g.setColor(0, 0, 0);
                g.fillRoundRect(this.xCenter - this.bSize[this.slide][0] / 2, this.yTop, this.bSize[this.slide][0], this.bSize[this.slide][1], 20, 20);
                g.setColor(this.cr, this.cg, this.cb);
                if (this.y3 > this.y1) {
                    g.fillTriangle(this.x1, this.y1 - 1, this.x2, this.y2 - 1, this.x3, this.y3);
                }
                g.fillRoundRect(this.xCenter - this.bSize[this.slide][0] / 2 + 1, this.yTop + 1, this.bSize[this.slide][0] - 2, this.bSize[this.slide][1] - 2, 18, 18);
                if (this.y3 > this.y1) {
                    g.setColor(0, 0, 0);
                    g.drawLine(this.x1 - 1, this.y1 - 1, this.x3, this.y3);
                    g.drawLine(this.x2 + 1, this.y2 - 1, this.x3, this.y3);
                }
                for (int cnt = 0; cnt < this.dText[this.slide].length; ++cnt) {
                    game.drawText(g, this.xCenter, this.yTop + cnt * this.bSize[this.slide][1] / this.dText[this.slide].length + 2, this.dText[this.slide][cnt], null, this.bFont, 1);
                }
            }
        }
    }
}

