/*
 * Decompiled with CFR 0.152.
 */
package cg;

import cg.CL;
import cg.Cimpl;
import java.io.IOException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Cv
extends Canvas
implements Runnable {
    private int sw;
    private int sh;
    private Font font = Font.getFont((int)0, (int)0, (int)8);
    private int fontHeight = this.font.getHeight();
    private String[] debugMsg = null;
    private int debugIndex;
    private int key_ls = -6;
    private int key_rs = -7;
    private int key_fire = -5;
    private int dispState;
    private CL cl;
    private Cimpl imp;
    private Image img_loadstack;
    private Image img_bg;
    private Image img_loadchar;
    private Image img_zifeichar;
    private int fillLen;
    private int currentStepPercent = 1;
    private String result = "";
    private boolean about = false;

    public Cv(Cimpl imp, CL cl) {
        this.setFullScreenMode(true);
        this.cl = cl;
        this.imp = imp;
        this.sw = 240;
        this.sh = 320;
        this.sw = 240;
        this.sh = 320;
        this.init();
        System.out.println(this.sw);
        System.out.println(this.sh);
        new Thread(this).start();
    }

    public void init() {
        try {
            this.img_bg = Image.createImage((String)"/bgx.png");
            this.img_zifeichar = Image.createImage((String)"/zifeichar.png");
            this.img_loadchar = Image.createImage((String)"/loadchar.png");
            this.img_loadstack = Image.createImage((String)"/loadstack.png");
        }
        catch (IOException ex) {
            this.cl.onEx();
        }
        int debugMsgSize = this.sh / this.fontHeight;
        this.debugMsg = new String[debugMsgSize];
    }

    protected void paint(Graphics g2) {
        g2.setFont(this.font);
        g2.setColor(0);
        g2.fillRect(0, 0, this.sw, this.sh);
        int dbIndex = this.debugIndex;
        int sx = 5;
        int sy = 5;
        if (this.img_bg != null) {
            g2.drawImage(this.img_bg, 0, 0, 20);
        }
        if (this.dispState == 0) {
            this.drawEffectString(g2, "OK", 2, this.sh - this.fontHeight, 0xFFFFFF, 0);
            this.drawEffectString(g2, "Exit", this.sw - this.font.stringWidth("Exit") - 2, this.sh - this.fontHeight, 0xFFFFFF, 0);
            if (this.img_zifeichar != null) {
                g2.drawImage(this.img_zifeichar, (this.sw - this.img_zifeichar.getWidth()) / 2, this.sh - this.img_zifeichar.getHeight() - this.fontHeight, 20);
            }
        } else if (this.dispState == 1) {
            g2.setColor(0xFFFFFF);
            for (int i2 = 0; i2 < this.debugMsg.length; ++i2) {
                if (--dbIndex < 0) {
                    dbIndex = this.debugMsg.length - 1;
                }
                if (this.debugMsg[dbIndex] == null) continue;
                g2.drawString(this.debugMsg[dbIndex], sx, sy, 20);
                sy += this.fontHeight;
            }
            if (this.img_loadstack != null) {
                int gagueSy = this.sh - this.img_loadstack.getHeight() - this.fontHeight;
                int gagueSx = (this.sw - this.img_loadstack.getWidth()) / 2;
                g2.drawImage(this.img_loadstack, gagueSx, gagueSy, 20);
                int fillSx = gagueSx + 2;
                int fillSy = gagueSy + 2;
                int fillHeight = this.img_loadstack.getHeight() - 4;
                g2.setColor(0xFF0000);
                g2.fillRect(fillSx, fillSy, this.fillLen, fillHeight);
                if ((this.img_loadstack.getWidth() - 4) * this.currentStepPercent / 100 > this.fillLen) {
                    ++this.fillLen;
                }
                if (this.img_loadchar != null) {
                    int loadcharSy = gagueSy - this.img_loadchar.getHeight() - 5;
                    int loadcharSx = (this.sw - this.img_loadchar.getWidth()) / 2;
                    g2.drawImage(this.img_loadchar, loadcharSx, loadcharSy, 20);
                }
            }
        } else if (this.dispState == 2) {
            g2.setColor(0xFFFF00);
            String s = "Accounting failures";
            int ssy = (this.sh - this.fontHeight) / 2;
            this.drawEffectString(g2, s, (this.sw - this.font.stringWidth(s)) / 2, ssy, 0xFFFFFF, 0);
            ssy += this.fontHeight;
            int index = 0;
            while (index < this.result.length()) {
                int drawLen = Math.min(10, this.result.length() - index);
                String re = this.result.substring(index, index + drawLen);
                this.drawEffectString(g2, re, (this.sw - this.font.stringWidth(re)) / 2, ssy, 0xFFFFFF, 0);
                index += drawLen;
                ssy += this.fontHeight;
            }
            this.drawEffectString(g2, "Retry", 2, this.sh - this.fontHeight, 0xFFFFFF, 0);
            this.drawEffectString(g2, "Exit", this.sw - this.font.stringWidth("Exit") - 2, this.sh - this.fontHeight, 0xFFFFFF, 0);
        }
    }

    public void run() {
        while (!this.about) {
            this.repaint();
            this.serviceRepaints();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void setState(int state, String des) {
        this.dispState = state;
        if (state != 0) {
            this.img_zifeichar = null;
            System.gc();
        }
        if (des != null && state == 2) {
            this.img_bg = null;
            this.result = this.result + des;
        }
    }

    protected void keyPressed(int keyCode) {
        if (keyCode == this.key_ls || keyCode == this.key_fire || keyCode == 53) {
            if (this.dispState == 0) {
                this.setState(1, "");
                this.imp.start();
            } else if (this.dispState == 2) {
                this.result = "";
                this.imp.restart();
                this.setGauge(1);
            }
        } else if (keyCode == this.key_rs && this.dispState != 1) {
            this.imp.exitRequest();
            this.cl.onEx();
        }
    }

    public void setGauge(int nextPersent) {
        if (this.img_loadstack == null) {
            return;
        }
        int fillTotleLen = this.img_loadstack.getWidth() - 4;
        this.fillLen = fillTotleLen * this.currentStepPercent / 100;
        this.currentStepPercent = nextPersent;
    }

    private void drawEffectString(Graphics g2, String s, int sx, int sy, int insideColor, int outsideColor) {
        g2.setColor(outsideColor);
        g2.drawString(s, sx - 1, sy, 20);
        g2.drawString(s, sx + 1, sy, 20);
        g2.drawString(s, sx, sy + 1, 20);
        g2.drawString(s, sx, sy - 1, 20);
        g2.setColor(insideColor);
        g2.drawString(s, sx, sy, 20);
    }

    public void releaseSource() {
        this.img_loadstack = null;
        this.img_bg = null;
        this.img_loadchar = null;
        this.img_zifeichar = null;
        System.gc();
    }

    public void stopRepaint() {
        this.about = true;
    }
}

