/*
 * Decompiled with CFR 0.152.
 */
package com.wistrand.midlet.valentine;

import com.wistrand.midlet.fp.FP;
import com.wistrand.midlet.sprite.Sprite;
import com.wistrand.midlet.sprite.SpriteCanvas;
import com.wistrand.midlet.valentine.BalloonSprite;
import com.wistrand.midlet.valentine.Bouncer;
import com.wistrand.midlet.valentine.Main;
import com.wistrand.midlet.valentine.MultiStar;
import com.wistrand.midlet.valentine.Util;
import com.wistrand.midlet.valentine.Wobbler;
import javax.microedition.lcdui.Graphics;

public class HeartSprite
extends Sprite {
    SpriteCanvas canvas;
    int fw;
    int fh;
    int brightCol;
    int darkCol;
    int sizeD = 1;
    int minSize = 128;
    int maxSize = 512;
    Wobbler wobbler = new Wobbler(256, 240);
    Bouncer bouncer;
    int[] lines = new int[]{7, 13, 5, 15, 4, 17, 3, 18, 2, 19, 1, 20, 1, 21, 1, 22, 1, 23, 1, 24, 1, 24, 1, 25, 2, 26, 2, 26, 3, 27, 3, 27};

    public HeartSprite(SpriteCanvas spriteCanvas, int n, int n2) {
        this.canvas = spriteCanvas;
        this.setSpeed(FP.rnd(-768, 768), FP.rnd(-256, 256));
        this.moveTo(256 * n, 256 * n2);
        this.bouncer = new Bouncer(this.y, this.dy, 0, spriteCanvas.getHeight() << 256, 512);
        this.size = FP.rnd(this.minSize, this.maxSize);
        this.setColor(0xFF0000);
        this.fw = (spriteCanvas.getWidth() << 8) / 8;
        this.fh = (spriteCanvas.getHeight() << 8) / 8;
    }

    public void moveTo(int n, int n2) {
        super.moveTo(n, n2);
    }

    public void setColor(int n) {
        super.setColor(n);
        this.brightCol = Util.interpolateRGB(n, 0xFFFFFF, 128);
        this.darkCol = Util.interpolateRGB(0, n, 128);
    }

    public void update() {
        Sprite sprite;
        int n;
        int n2 = this.canvas.getWidth() << 8;
        int n3 = (this.canvas.getHeight() << 8) - this.fh * 2;
        this.wobbler.update();
        this.size += this.sizeD;
        if (this.size > this.maxSize) {
            this.sizeD = -this.sizeD;
            this.size = this.maxSize;
        }
        if (this.size < this.minSize) {
            this.sizeD = -this.sizeD;
            this.size = this.minSize;
        }
        super.update();
        this.bouncer.max = n3;
        this.y = this.bouncer.update();
        if (this.x < 0) {
            this.dx = -this.dx;
            this.x = 0;
        }
        if (this.x > n2) {
            this.dx = -this.dx;
            this.x = n2;
        }
        if ((n = this.bouncer.getBounce()) != 0) {
            this.wobbler.start(Math.max(-this.wobbler.max / 2, n / 16));
        }
        if (this.bouncer.meanY == n3) {
            this.setSpeed(FP.rnd(-512, 512), FP.rnd(-5120, 0));
            this.bouncer.delta = this.dy;
        }
        if ((FP.rnd.nextInt() & 0xFF) > 250) {
            sprite = new BalloonSprite(this.canvas, Util.makeText(), this.x, this.y);
            this.canvas.addAfter(sprite, this);
        }
        if ((FP.rnd.nextInt() & 0xFF) > 253) {
            sprite = new MultiStar(this.canvas.bgColor, this.canvas);
            sprite.setParent(this, 0, 0);
            this.canvas.addBefore(sprite, this);
        }
    }

    public void paintHeart(Graphics graphics, int n, int n2, int n3) {
        int n4 = this.fw >> 8;
        n4 *= this.size;
        n4 >>= 8;
        n3 *= this.size;
        n3 >>= 8;
        int n5 = 0;
        while (n5 < n4) {
            int n6 = this.lines.length / 2 * (n4 - n5 - 1) / n4;
            int n7 = n3 * this.lines[n6 * 2] / 32;
            int n8 = n3 * this.lines[n6 * 2 + 1] / 32;
            graphics.setColor(this.col);
            graphics.drawLine(n - n5, n2 + n7, n - n5, n2 + n8);
            graphics.drawLine(n + n5, n2 + n7, n + n5, n2 + n8);
            if (Main.theMain.detailLevel > 0) {
                if (n5 > n4 / 2) {
                    graphics.setColor(this.brightCol);
                    graphics.drawLine(n - n5, n2 + n7, n - n5, n2 + n7 + 1);
                } else {
                    graphics.setColor(this.brightCol);
                    graphics.drawLine(n + n5, n2 + n7, n + n5, n2 + n7 + 1);
                }
                graphics.setColor(this.darkCol);
                graphics.drawLine(n + n5, n2 + n8, n + n5, n2 + n8 - 1);
            }
            ++n5;
        }
    }

    public void paint(Graphics graphics) {
        int n = this.x >> 8;
        int n2 = this.y >> 8;
        int n3 = this.wobbler.getValue() * this.fh / 2 >> 8;
        int n4 = this.fw >> 8;
        int n5 = this.fh + n3 >> 8;
        graphics.setColor(0xFF0000);
        this.paintHeart(graphics, n, n2, n5 * 2);
    }
}

