/*
 * Decompiled with CFR 0.152.
 */
package component;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class CSpriteAnimation {
    private Image imgSprite;
    Sprite sprite;
    private int[] iArrSequence;
    private int iCurFrame;
    private int iTotalFrames;

    public CSpriteAnimation(String strSpritePath, int iFrames, int iAnimSpeed, boolean isFlipped, boolean isVerticalSprite) {
        try {
            this.imgSprite = Image.createImage((String)strSpritePath);
            this.iTotalFrames = iAnimSpeed * iFrames;
            if (isFlipped) {
                this.imgSprite = Image.createImage((Image)this.imgSprite, (int)0, (int)0, (int)this.imgSprite.getWidth(), (int)this.imgSprite.getHeight(), (int)2);
                this.iArrSequence = new int[this.iTotalFrames];
                for (int i2 = 0; i2 < this.iTotalFrames; ++i2) {
                    this.iArrSequence[i2] = iFrames - i2 / iAnimSpeed - 1;
                }
            } else {
                this.iArrSequence = new int[this.iTotalFrames];
                for (int i3 = 0; i3 < this.iTotalFrames; ++i3) {
                    this.iArrSequence[i3] = i3 / iAnimSpeed;
                }
            }
            this.sprite = isVerticalSprite ? new Sprite(this.imgSprite, this.imgSprite.getWidth(), this.imgSprite.getHeight() / iFrames) : new Sprite(this.imgSprite, this.imgSprite.getWidth() / iFrames, this.imgSprite.getHeight());
            this.sprite.setFrameSequence(this.iArrSequence);
        }
        catch (Exception ex) {
            System.out.println("Error on loading ...");
        }
        this.iCurFrame = 0;
        this.sprite.setVisible(true);
    }

    public CSpriteAnimation(Image img, int iFrames, int iAnimSpeed, boolean isFlipped, boolean isVerticalSprite) {
        try {
            this.imgSprite = img;
            this.iTotalFrames = iAnimSpeed * iFrames;
            if (isFlipped) {
                this.imgSprite = Image.createImage((Image)this.imgSprite, (int)0, (int)0, (int)this.imgSprite.getWidth(), (int)this.imgSprite.getHeight(), (int)2);
                this.iArrSequence = new int[this.iTotalFrames];
                for (int i2 = 0; i2 < this.iTotalFrames; ++i2) {
                    this.iArrSequence[i2] = iFrames - i2 / iAnimSpeed - 1;
                }
            } else {
                this.iArrSequence = new int[this.iTotalFrames];
                for (int i3 = 0; i3 < this.iTotalFrames; ++i3) {
                    this.iArrSequence[i3] = i3 / iAnimSpeed;
                }
            }
            this.sprite = isVerticalSprite ? new Sprite(this.imgSprite, this.imgSprite.getWidth(), this.imgSprite.getHeight() / iFrames) : new Sprite(this.imgSprite, this.imgSprite.getWidth() / iFrames, this.imgSprite.getHeight());
            this.sprite.setFrameSequence(this.iArrSequence);
        }
        catch (Exception ex) {
            System.out.println("Error on loading ...");
        }
        this.iCurFrame = 0;
        this.sprite.setVisible(true);
    }

    public CSpriteAnimation(String strSpritePath, int iFramesWidth, int iFrameHeight, int iAnimSpeed, boolean isFlipped) {
        try {
            this.imgSprite = Image.createImage((String)strSpritePath);
            if (isFlipped) {
                this.imgSprite = Image.createImage((Image)this.imgSprite, (int)0, (int)0, (int)this.imgSprite.getWidth(), (int)this.imgSprite.getHeight(), (int)2);
            }
            this.sprite = new Sprite(this.imgSprite, iFramesWidth, iFrameHeight);
            int iFrames = this.imgSprite.getWidth() / iFramesWidth * (this.imgSprite.getHeight() / iFrameHeight);
            this.iTotalFrames = iAnimSpeed * iFrames;
            this.iArrSequence = new int[iAnimSpeed * iFrames];
            for (int i2 = 0; i2 < this.iTotalFrames; ++i2) {
                this.iArrSequence[i2] = i2 / iAnimSpeed;
            }
            this.sprite.setFrameSequence(this.iArrSequence);
        }
        catch (Exception ex) {
            System.out.println("Error on loading ...");
        }
        this.iCurFrame = 0;
        this.sprite.setVisible(true);
    }

    public void update() {
        this.sprite.nextFrame();
        this.iCurFrame = 0;
    }

    public boolean updateOnce(boolean isReset) {
        if (this.iCurFrame != this.iTotalFrames - 1) {
            ++this.iCurFrame;
            this.sprite.nextFrame();
            return false;
        }
        if (isReset) {
            this.iCurFrame = 0;
            return true;
        }
        return true;
    }

    public void reset() {
        this.iCurFrame = 0;
        this.sprite.setFrame(0);
    }

    public void setFrame(int frame) {
        this.iCurFrame = frame;
        this.sprite.setFrame(frame);
    }

    public int getTotalFrame() {
        return this.iTotalFrames;
    }

    public void paint(Graphics g2, int x2, int y2, int anchor) {
        x2 = this.parseAnchorPosX(x2, anchor);
        y2 = this.parseAnchorPosY(y2, anchor);
        g2.translate(x2, y2);
        this.sprite.paint(g2);
        g2.translate(-x2, -y2);
    }

    public int getCurFrameWidth() {
        return this.sprite.getWidth();
    }

    public int getCurFrameHeight() {
        return this.sprite.getHeight();
    }

    private int parseAnchorPosX(int x2, int anchor) {
        int val = x2;
        if ((anchor & 8) == 8) {
            val -= this.sprite.getWidth();
        } else if ((anchor & 4) == 4) {
            val += 0;
        } else if ((anchor & 1) == 1) {
            val -= this.sprite.getWidth() >> 1;
        }
        return val;
    }

    private int parseAnchorPosY(int y2, int anchor) {
        int val = y2;
        if ((anchor & 0x20) == 32) {
            val -= this.sprite.getHeight();
        } else if ((anchor & 0x10) == 16) {
            val += 0;
        } else if ((anchor & 2) == 2) {
            val -= this.sprite.getHeight() >> 1;
        }
        return val;
    }
}

