/*
 * Decompiled with CFR 0.152.
 */
package game;

import component.CUtility;
import ingame.CIngameManager;
import javax.microedition.lcdui.Graphics;
import logosplash.CLogoManager;
import mainmenu.CMainMenuManager;

public class CMainGameManager {
    private static CMainGameManager instance = null;
    private int iCurrentSubManager;
    private CIngameManager objIngameManager;
    private CLogoManager objLogoManager;
    private CMainMenuManager objMainMenuManager;
    private boolean isSwitchingStates;

    public CMainGameManager() {
        CUtility.load();
        this.iCurrentSubManager = 0;
        this.isSwitchingStates = false;
        instance = this;
    }

    public void unload() {
        switch (this.iCurrentSubManager) {
            case 1: {
                if (this.objMainMenuManager != null) {
                    this.objMainMenuManager.unload();
                }
                this.objMainMenuManager = null;
                break;
            }
            case 2: {
                if (this.objIngameManager != null) {
                    this.objIngameManager.unload();
                }
                this.objIngameManager = null;
                break;
            }
            case 0: {
                if (this.objLogoManager != null) {
                    this.objLogoManager.UnLoadImages();
                }
                this.objLogoManager = null;
            }
        }
        CUtility.unload();
    }

    public void update() {
        if (this.isSwitchingStates) {
            return;
        }
        switch (this.iCurrentSubManager) {
            case 1: {
                if (this.objMainMenuManager != null) {
                    this.objMainMenuManager.update();
                    break;
                }
                this.objMainMenuManager = new CMainMenuManager();
                break;
            }
            case 2: {
                if (this.objIngameManager != null) {
                    this.objIngameManager.update();
                    break;
                }
                this.objIngameManager = new CIngameManager();
                System.out.println("constructing ingame again ...");
                break;
            }
            case 0: {
                if (this.objLogoManager != null) {
                    this.objLogoManager.update();
                    break;
                }
                this.objLogoManager = new CLogoManager();
            }
        }
    }

    public void paint(Graphics g2) {
        if (this.isSwitchingStates) {
            return;
        }
        switch (this.iCurrentSubManager) {
            case 1: {
                this.objMainMenuManager.paint(g2);
                break;
            }
            case 2: {
                this.objIngameManager.paint(g2);
                break;
            }
            case 0: {
                this.objLogoManager.paint(g2);
            }
        }
    }

    public void handleInput(int key, boolean isPressed) {
        if (this.isSwitchingStates) {
            return;
        }
        switch (this.iCurrentSubManager) {
            case 0: {
                if (this.objLogoManager == null) break;
                this.objLogoManager.handleInput(key, isPressed);
                break;
            }
            case 1: {
                if (this.objMainMenuManager == null) break;
                this.objMainMenuManager.handleInput(key, isPressed);
                break;
            }
            case 2: {
                if (this.objIngameManager == null) break;
                this.objIngameManager.handleInput(key, isPressed);
            }
        }
    }

    public void handleInput(String chKey, boolean isPressed) {
        if (this.isSwitchingStates) {
            return;
        }
        switch (this.iCurrentSubManager) {
            case 2: {
                if (this.objIngameManager == null) break;
                this.objIngameManager.handleInput(chKey, isPressed);
            }
        }
    }

    public void handleTouchInput(int pointerX, int pointerY, int iTouchState) {
        if (this.isSwitchingStates) {
            return;
        }
        switch (this.iCurrentSubManager) {
            case 0: {
                if (this.objLogoManager == null) break;
                this.objLogoManager.handleTouchInput(pointerX, pointerY, iTouchState);
                break;
            }
            case 1: {
                if (this.objMainMenuManager == null) break;
                this.objMainMenuManager.handleTouchInput(pointerX, pointerY, iTouchState);
                break;
            }
            case 2: {
                if (this.objIngameManager == null) break;
                this.objIngameManager.handleTouchInput(pointerX, pointerY, iTouchState);
            }
        }
    }

    public void switchToStates(int iNextState) {
        this.isSwitchingStates = true;
        switch (this.iCurrentSubManager) {
            case 0: {
                if (this.objLogoManager != null) {
                    // empty if block
                }
                this.objLogoManager.UnLoadImages();
                this.objLogoManager = null;
                break;
            }
            case 1: {
                if (this.objMainMenuManager == null) break;
                this.objMainMenuManager = null;
                break;
            }
            case 2: {
                if (this.objIngameManager == null) break;
                this.objIngameManager.unload();
                this.objIngameManager = null;
            }
        }
        switch (iNextState) {
            case 1: {
                this.objMainMenuManager = new CMainMenuManager();
                break;
            }
            case 2: {
                this.objIngameManager = new CIngameManager();
            }
        }
        this.iCurrentSubManager = iNextState;
        this.isSwitchingStates = false;
    }

    public void gameInterrupted(boolean state) {
        switch (this.iCurrentSubManager) {
            case 2: {
                if (this.objIngameManager == null) break;
                this.objIngameManager.gameInterrupted(state);
                break;
            }
            case 1: {
                if (this.objMainMenuManager == null) break;
                this.objMainMenuManager.gameInterrupted(state);
                break;
            }
            case 0: {
                if (this.objLogoManager == null) break;
                this.objLogoManager.gameInterrupted(state);
            }
        }
    }

    public static CMainGameManager getInstance() {
        return instance;
    }
}

