/*
 * Decompiled with CFR 0.152.
 */
package ingame;

import component.CUtility;
import constants.CGameTexts;
import game.CCanvas;
import ingame.CIngameManager;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CIngamePopup {
    private String strDialog;
    private String[] strSplitDialog;
    private int iDialodIndex;
    private int iStartY;
    private int iFontHeight;
    private int iX;
    private int iY;
    private int iW;
    private int iH;
    private int iSpeed;
    private int iTimer;
    private boolean isAppearing;
    private boolean isShowing;
    private Image[] imgArrFaces;
    private int iFaceIndex;
    private int iFaceW;
    private boolean isEnable;

    public CIngamePopup(Image imgAmir) {
        try {
            this.imgArrFaces = new Image[3];
            this.imgArrFaces[0] = Image.createImage((String)"/popup_abhishek.png");
            this.imgArrFaces[1] = Image.createImage((String)"/popup_uday.png");
            this.imgArrFaces[2] = imgAmir;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.iFaceIndex = 0;
        this.strDialog = "Testinggg ..";
        this.isAppearing = false;
        this.isShowing = false;
        this.isEnable = false;
        this.iW = CCanvas.iScreenW - (CCanvas.iScreenW >> 2);
        this.iH = 50;
        this.iSpeed = CCanvas.iScreenW >> 4;
        this.iTimer = CCanvas.FPS;
        this.iX = -this.iW;
        this.iY = CCanvas.iScreenH - this.iH;
    }

    public void update() {
        if (!this.isEnable) {
            return;
        }
        if (this.isAppearing) {
            this.iX += this.iSpeed;
            if (this.iX >= 0) {
                this.iX = 0;
                this.isAppearing = false;
                this.isShowing = true;
            }
        } else if (this.isShowing) {
            --this.iTimer;
            if (this.iTimer <= 0) {
                this.isShowing = false;
            }
        } else {
            this.iX -= this.iSpeed;
            if (this.iX <= -this.iW) {
                this.isEnable = false;
            }
        }
    }

    public void show(boolean isAmirDialogue) {
        if (this.isAppearing) {
            return;
        }
        this.iFaceIndex = isAmirDialogue ? 2 : CUtility.getRandomNumberInRange(0, 100) % 2;
        this.iFaceW = this.imgArrFaces[this.iFaceIndex].getWidth();
        if (this.iFaceIndex == 0) {
            this.iDialodIndex = CUtility.getRandomNumberInRange(0, 100) % CGameTexts.strArrJayDialig.length;
            this.strDialog = CGameTexts.strArrJayDialig[this.iDialodIndex];
        } else if (this.iFaceIndex == 1) {
            this.iDialodIndex = CUtility.getRandomNumberInRange(0, 100) % CGameTexts.strArrAliDialig.length;
            this.strDialog = CGameTexts.strArrAliDialig[this.iDialodIndex];
        } else {
            this.strDialog = "Tap on bike/press OK to fire.";
        }
        this.strSplitDialog = CUtility.getTextRows(this.strDialog, CIngameManager.getInstance().objSmallFont, this.iW - this.imgArrFaces[this.iFaceIndex].getWidth() - 5);
        this.iFontHeight = CIngameManager.getInstance().objSmallFont.getHeight();
        this.iStartY = this.iY + (this.iH - this.iFontHeight * this.strSplitDialog.length >> 1);
        this.isEnable = true;
        this.isAppearing = true;
        this.iX = -this.iW;
        this.iTimer = CCanvas.FPS;
    }

    public void hide() {
        this.isShowing = false;
    }

    public void paint(Graphics g2) {
        if (!this.isEnable) {
            return;
        }
        g2.setColor(0x2A2A2A);
        g2.fillRoundRect(this.iX, this.iY, this.iW, this.iH, 25, 25);
        g2.setColor(0xFFFFFF);
        g2.drawRoundRect(this.iX, this.iY, this.iW, this.iH, 25, 25);
        g2.drawImage(this.imgArrFaces[this.iFaceIndex], this.iX, this.iY + (this.iH >> 1), 6);
        for (int i2 = 0; i2 < this.strSplitDialog.length; ++i2) {
            CIngameManager.getInstance().objSmallFont.drawString(this.strSplitDialog[i2], this.iX + (this.iW - this.iFaceW >> 1) + this.iFaceW, this.iStartY + this.iFontHeight * i2, g2, 3);
        }
    }
}

