/*
 * Decompiled with CFR 0.152.
 */
package ingame;

import component.CSpriteAnimation;
import game.CCanvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CObstacle {
    public static final int TOTAL_OBSTACLES = 4;
    public static final int TYPE_CONE = 0;
    public static final int TYPE_MANHOLE = 1;
    public static final int TYPE_BARRICADE = 2;
    public static final int TYPE_BLOCK = 3;
    public int iPosX;
    public int iPosY;
    public int iWidth;
    public int iHeigth;
    private Image imgObstacle;
    private int iType;
    private boolean isTerminating;
    private int iHealth;
    private boolean isDestroyed;
    private boolean isDestroying;
    private CSpriteAnimation animBlast;

    public CObstacle(Image img, int type, int x2, int y2, CSpriteAnimation anim) {
        this.iType = type;
        this.imgObstacle = img;
        this.iWidth = this.imgObstacle.getWidth();
        switch (this.iType) {
            case 0: {
                this.isTerminating = false;
                this.iPosX = x2 - (this.iWidth >> 1);
                break;
            }
            case 2: {
                this.isTerminating = true;
                this.iPosX = x2 - this.iWidth;
                break;
            }
            case 3: {
                this.isTerminating = true;
                this.iPosX = x2 - this.iWidth;
                break;
            }
            case 1: {
                this.isTerminating = false;
                this.iPosX = x2 - (this.iWidth << 1);
            }
        }
        this.iHeigth = this.imgObstacle.getHeight();
        this.iPosY = y2;
        this.iHealth = 50;
        this.isDestroyed = false;
        this.isDestroying = false;
        this.animBlast = anim;
        this.animBlast.reset();
    }

    public boolean decreaseHealth(int amount) {
        this.iHealth -= amount;
        if (this.iHealth <= 0) {
            this.isDestroying = true;
            return false;
        }
        return true;
    }

    public void unload() {
        this.imgObstacle = null;
    }

    public boolean checkTerminatingObstacle() {
        return this.isTerminating;
    }

    public boolean update(int speed) {
        this.iPosY += speed;
        if (this.isDestroying) {
            this.isDestroyed = this.animBlast.updateOnce(true);
            if (this.isDestroyed) {
                this.isDestroying = false;
            }
        }
        return this.iPosY <= CCanvas.iScreenH;
    }

    public boolean checkDestroyed() {
        return this.isDestroyed;
    }

    public boolean checkDestroying() {
        return this.isDestroying;
    }

    public int getType() {
        return this.iType;
    }

    public void paint(Graphics g2) {
        if (!this.isDestroying && !this.isDestroyed) {
            g2.drawImage(this.imgObstacle, this.iPosX, this.iPosY, 20);
        } else {
            this.animBlast.paint(g2, this.iPosX + (this.iWidth >> 1), this.iPosY + (this.iHeigth >> 1), 3);
        }
    }
}

