/*
 * Decompiled with CFR 0.152.
 */
package ingame;

import component.CUtility;
import component.gameData;
import game.CCanvas;
import ingame.CIngameManager;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CStateBikeSelection {
    private Image[] imgArrBikeList;
    private int iSelIndex;
    private int iTotalHeight;
    private int iStartY;
    private int iTotalBikeOption = gameData.getData(5) + 1;
    private Image imgBtnNext;
    private int[][] iArrSelectionRegion;

    public CStateBikeSelection() {
        try {
            this.imgArrBikeList = new Image[this.iTotalBikeOption];
            this.imgArrBikeList[0] = Image.createImage((String)"/bike_normal.png");
            this.imgArrBikeList[1] = Image.createImage((String)"/bike_bullet.png");
            if (this.iTotalBikeOption > 2) {
                this.imgArrBikeList[2] = Image.createImage((String)"/bike_missile.png");
            }
            this.iArrSelectionRegion = new int[this.iTotalBikeOption][4];
            int w2 = 0;
            int h2 = 0;
            for (int i2 = 0; i2 < this.iTotalBikeOption; ++i2) {
                if (w2 < this.imgArrBikeList[i2].getWidth()) {
                    w2 = this.imgArrBikeList[i2].getWidth();
                }
                if (h2 >= this.imgArrBikeList[i2].getHeight()) continue;
                h2 = this.imgArrBikeList[i2].getHeight();
            }
            w2 += w2 >> 1;
            h2 += h2 >> 3;
            this.iTotalHeight = h2 * this.iTotalBikeOption + (h2 >> 1) * (this.iTotalBikeOption - 1);
            int iTmpY = this.iStartY = (CCanvas.iScreenH >> 1) - (this.iTotalHeight >> 1);
            for (int i3 = 0; i3 < this.iTotalBikeOption; ++i3) {
                this.iArrSelectionRegion[i3][0] = (CCanvas.iScreenW >> 1) - (w2 >> 1);
                this.iArrSelectionRegion[i3][1] = iTmpY;
                this.iArrSelectionRegion[i3][2] = w2;
                this.iArrSelectionRegion[i3][3] = h2;
                iTmpY += h2 + (h2 >> 1);
            }
            this.imgBtnNext = Image.createImage((String)"/next.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.iSelIndex = this.iTotalBikeOption - 1;
    }

    public void update() {
    }

    public void unload() {
        for (int i2 = 0; i2 < this.iTotalBikeOption; ++i2) {
            this.imgArrBikeList[i2] = null;
        }
        this.imgArrBikeList = null;
        this.iArrSelectionRegion = null;
        this.imgBtnNext = null;
    }

    public void paint(Graphics g2) {
        CUtility.drawBorder(g2, 5, this.iStartY - (this.iTotalHeight >> 3) - 4, CCanvas.iScreenW - 10, this.iTotalHeight + (this.iTotalHeight >> 2));
        for (int i2 = 0; i2 < this.iTotalBikeOption; ++i2) {
            if (i2 == this.iSelIndex) {
                g2.setColor(0xFFFFFF);
                g2.fillRoundRect(this.iArrSelectionRegion[i2][0] - 4, this.iArrSelectionRegion[i2][1] - 4, this.iArrSelectionRegion[i2][2] + 8, this.iArrSelectionRegion[i2][3] + 8, 8, 8);
                g2.setColor(0x555555);
                g2.fillRoundRect(this.iArrSelectionRegion[i2][0] - 2, this.iArrSelectionRegion[i2][1] - 2, this.iArrSelectionRegion[i2][2] + 4, this.iArrSelectionRegion[i2][3] + 4, 8, 8);
            } else {
                g2.setColor(0x333333);
                g2.fillRoundRect(this.iArrSelectionRegion[i2][0] - 2, this.iArrSelectionRegion[i2][1] - 2, this.iArrSelectionRegion[i2][2] + 4, this.iArrSelectionRegion[i2][3] + 4, 6, 6);
                g2.setColor(0x999999);
                g2.drawRoundRect(this.iArrSelectionRegion[i2][0] - 2, this.iArrSelectionRegion[i2][1] - 2, this.iArrSelectionRegion[i2][2] + 4, this.iArrSelectionRegion[i2][3] + 4, 6, 6);
            }
            g2.drawImage(this.imgArrBikeList[i2], CCanvas.iScreenW >> 1, this.iArrSelectionRegion[i2][1] + (this.iArrSelectionRegion[i2][3] >> 1), 3);
        }
        CUtility.paintSoftKeys(g2, this.imgBtnNext, null);
    }

    public void handleInput(int key, boolean isPressed) {
        if (!isPressed) {
            if (key == 202) {
                this.iSelIndex = (this.iSelIndex + (this.iTotalBikeOption - 1)) % this.iTotalBikeOption;
            } else if (key == 208) {
                ++this.iSelIndex;
                this.iSelIndex %= this.iTotalBikeOption;
            } else if (key == 205 || key == 211) {
                CIngameManager.getInstance().setCurrentBike(this.iSelIndex);
                CIngameManager.getInstance().switchToStates(0);
            }
        }
    }

    public void handleTouchInput(int pointerX, int pointerY, int iTouchState) {
        block5: {
            block4: {
                if (iTouchState != 2) break block4;
                if (CUtility.isLSKPressed(pointerX, pointerY)) {
                    CIngameManager.getInstance().setCurrentBike(this.iSelIndex);
                    CIngameManager.getInstance().switchToStates(0);
                } else {
                    for (int i2 = 0; i2 < this.iTotalBikeOption; ++i2) {
                        if (!CUtility.isPointInRect(pointerX, pointerY, this.iArrSelectionRegion[i2][0], this.iArrSelectionRegion[i2][1], this.iArrSelectionRegion[i2][2], this.iArrSelectionRegion[i2][3])) continue;
                        CIngameManager.getInstance().setCurrentBike(this.iSelIndex);
                        CIngameManager.getInstance().switchToStates(0);
                        return;
                    }
                }
                break block5;
            }
            if (iTouchState != 0) break block5;
            for (int i3 = 0; i3 < this.iTotalBikeOption; ++i3) {
                if (!CUtility.isPointInRect(pointerX, pointerY, this.iArrSelectionRegion[i3][0], this.iArrSelectionRegion[i3][1], this.iArrSelectionRegion[i3][2], this.iArrSelectionRegion[i3][3])) continue;
                this.iSelIndex = i3;
                return;
            }
        }
    }
}

