/*
 * Decompiled with CFR 0.152.
 */
package ingame;

import component.CSpriteAnimation;
import component.CUtility;
import component.customFont;
import component.gameData;
import constants.CGameTexts;
import game.CCanvas;
import ingame.CCutScene;
import ingame.CGameOverScreen;
import ingame.CIngameStatePlay;
import ingame.CNameInsert;
import ingame.CStateBikeSelection;
import javax.microedition.lcdui.Graphics;

public class CIngameManager {
    private static CIngameManager instance = null;
    private int iCurrentState = 4;
    private boolean isStateSwitching = true;
    private CIngameStatePlay objIngameStatePlay;
    private CGameOverScreen objGameOverScreen;
    private CStateBikeSelection objBikeSelection;
    private CNameInsert objNameIncert;
    private CCutScene objCutScene;
    private boolean isStateLoaded = false;
    private int iLoadingCounter = 0;
    private CSpriteAnimation animShield;
    private CSpriteAnimation animMagnet;
    private int iInfoStartY;
    private int iFontHeight;
    private int iTotalHeight;
    private String[] strArrMagnetInfo;
    private String[] strArrShieldInfo;
    private boolean isNextOnLoading = false;
    private customFont objTapFont;
    private int iBlinkCounter;
    private int iMaxScore;
    private int iLastScore;
    private int iTotalCoinCollected;
    private int iMostCoinCollected;
    private int iLastCoinCollected;
    private int iLifeTimeCoinCollected;
    private int iMaxDistance;
    private int iLatestDistance;
    private int iTotalDist;
    private int iGames;
    private int iCurrentBike;
    public customFont objSmallFont = new customFont(0);
    public customFont objBigFont = new customFont(1);
    private int iTmpIndex = CUtility.getRandomNumberInRange(0, 100) % CGameTexts.strArrTip.length;
    private boolean isOnce = false;

    public CIngameManager() {
        instance = this;
        this.iCurrentBike = 0;
        this.objCutScene = new CCutScene();
        this.isStateLoaded = true;
        this.isStateSwitching = false;
        System.out.println("In ingame manager...");
    }

    public void update() {
        switch (this.iCurrentState) {
            case 0: {
                if (!this.isStateLoaded) {
                    this.objIngameStatePlay.load(this.iLoadingCounter);
                    ++this.iLoadingCounter;
                    this.animMagnet.update();
                    this.animShield.update();
                    if (this.iLoadingCounter == 19) {
                        this.iMaxScore = gameData.getData(12);
                        this.iTotalCoinCollected = gameData.getData(1);
                        this.iMaxDistance = gameData.getData(13);
                        this.iMostCoinCollected = gameData.getData(14);
                        this.iTotalDist = gameData.getData(3);
                        this.iGames = gameData.getData(2);
                        this.iLifeTimeCoinCollected = gameData.getData(15);
                        this.iLastCoinCollected = 0;
                        this.iLatestDistance = 0;
                        this.iLastScore = 0;
                        CCanvas.isShowAdd = true;
                        this.isOnce = true;
                        break;
                    }
                    if (this.iLoadingCounter < 21) break;
                    this.isStateLoaded = true;
                    break;
                }
                if (this.isNextOnLoading) {
                    this.objIngameStatePlay.update();
                    break;
                }
                if (this.animMagnet == null || this.animShield == null) break;
                this.animMagnet.update();
                this.animShield.update();
                ++this.iBlinkCounter;
                this.iBlinkCounter %= 150;
                break;
            }
            case 1: {
                if (this.objGameOverScreen == null) break;
                if (CCanvas.isShowAdd) {
                    if (!this.isOnce) break;
                    this.isOnce = false;
                    CCanvas.isCallShowAdd = true;
                    break;
                }
                this.objGameOverScreen.update();
                break;
            }
            case 3: {
                if (this.objNameIncert == null) break;
                this.objNameIncert.update();
                break;
            }
            case 4: {
                if (this.objCutScene == null) break;
                this.objCutScene.update();
            }
        }
    }

    public void unload() {
        if (this.objGameOverScreen != null) {
            this.objGameOverScreen.unload();
        }
        if (this.objIngameStatePlay != null) {
            this.objIngameStatePlay.unload();
        }
        if (this.objBikeSelection != null) {
            this.objBikeSelection.unload();
        }
        if (this.objNameIncert != null) {
            this.objNameIncert.unloadImages();
        }
        if (this.objCutScene != null) {
            this.objCutScene.unload();
        }
        this.objGameOverScreen = null;
        this.objIngameStatePlay = null;
        this.objBikeSelection = null;
        this.objNameIncert = null;
        this.objCutScene = null;
        this.objSmallFont = null;
        this.objBigFont = null;
    }

    public void paint(Graphics g2) {
        switch (this.iCurrentState) {
            case 0: {
                if (!this.isStateLoaded || !this.isNextOnLoading) {
                    int i2;
                    if (!this.isStateLoaded) {
                        CUtility.paintLoadingBar(g2, this.iLoadingCounter);
                    } else if (this.iBlinkCounter % 4 != 0) {
                        String[] strSplitNext = CUtility.getTextRows("Press OK/Tap to continue ...", this.objTapFont, CCanvas.iScreenW - (CCanvas.iScreenW >> 3));
                        for (int i3 = 0; i3 < strSplitNext.length; ++i3) {
                            this.objTapFont.drawString(strSplitNext[i3], CCanvas.iScreenW >> 1, CCanvas.iScreenH - (CCanvas.iScreenH >> 3) + this.objSmallFont.getHeight() * i3, g2, 17);
                        }
                    }
                    String strTip = CGameTexts.strArrTip[this.iTmpIndex];
                    String[] strSplitArr = CUtility.getTextRows(strTip, this.objSmallFont, CCanvas.iScreenW - (CCanvas.iScreenW >> 2));
                    for (i2 = 0; i2 < strSplitArr.length; ++i2) {
                        this.objSmallFont.drawString(strSplitArr[i2], CCanvas.iScreenW >> 1, CCanvas.iScreenH - (CCanvas.iScreenH >> 2) + this.objSmallFont.getHeight() * i2, g2, 33);
                    }
                    CUtility.drawBorder(g2, CCanvas.iScreenW >> 3, CCanvas.iScreenH >> 2, CCanvas.iScreenW - (CCanvas.iScreenW >> 2), CCanvas.iScreenH >> 2);
                    this.animMagnet.paint(g2, (CCanvas.iScreenW >> 3) + (this.animMagnet.getCurFrameWidth() >> 1), this.iInfoStartY + this.iFontHeight, 20);
                    for (i2 = 0; i2 < this.strArrMagnetInfo.length; ++i2) {
                        CIngameManager.getInstance().objSmallFont.drawString(this.strArrMagnetInfo[i2], (CCanvas.iScreenW >> 2) + (CCanvas.iScreenW >> 4), this.iInfoStartY + this.iFontHeight * i2, g2, 20);
                    }
                    this.animShield.paint(g2, (CCanvas.iScreenW >> 3) + (this.animMagnet.getCurFrameWidth() >> 1), this.iInfoStartY + this.iFontHeight * (this.strArrMagnetInfo.length + 1) + this.iFontHeight, 20);
                    for (i2 = 0; i2 < this.strArrShieldInfo.length; ++i2) {
                        CIngameManager.getInstance().objSmallFont.drawString(this.strArrShieldInfo[i2], (CCanvas.iScreenW >> 2) + (CCanvas.iScreenW >> 4), this.iInfoStartY + this.iFontHeight * (i2 + this.strArrMagnetInfo.length + 1), g2, 20);
                    }
                    break;
                }
                if (!this.isNextOnLoading) break;
                this.objIngameStatePlay.paint(g2);
                break;
            }
            case 1: {
                if (CCanvas.isShowAdd) break;
                this.objGameOverScreen.paint(g2);
                break;
            }
            case 2: {
                this.objBikeSelection.paint(g2);
                break;
            }
            case 3: {
                this.objNameIncert.paint(g2);
                break;
            }
            case 4: {
                this.objCutScene.paint(g2);
            }
        }
    }

    public void handleInput(int key, boolean isPressed) {
        if (!this.isStateLoaded || this.isStateSwitching) {
            return;
        }
        if (this.objIngameStatePlay != null && !this.isNextOnLoading) {
            if (key == 205) {
                this.animShield = null;
                this.animMagnet = null;
                this.objTapFont = null;
                this.strArrMagnetInfo = null;
                this.strArrShieldInfo = null;
                this.isNextOnLoading = true;
                this.objIngameStatePlay.playStartSound();
                this.iBlinkCounter = 0;
            }
            return;
        }
        switch (this.iCurrentState) {
            case 0: {
                if (this.objIngameStatePlay == null) break;
                this.objIngameStatePlay.handleInput(key, isPressed);
                break;
            }
            case 1: {
                if (this.objGameOverScreen == null) break;
                this.objGameOverScreen.handleInput(key, isPressed);
                break;
            }
            case 2: {
                if (this.objBikeSelection == null) break;
                this.objBikeSelection.handleInput(key, isPressed);
                break;
            }
            case 3: {
                if (this.objNameIncert == null) break;
                this.objNameIncert.handleInput(key, isPressed);
                break;
            }
            case 4: {
                if (this.objCutScene == null) break;
                this.objCutScene.handleInput(key, isPressed);
            }
        }
    }

    public void handleInput(String chKey, boolean isPressed) {
        if (!this.isStateLoaded || this.isStateSwitching) {
            return;
        }
        switch (this.iCurrentState) {
            case 3: {
                if (this.objNameIncert == null) break;
                this.objNameIncert.handleInput(chKey, isPressed);
            }
        }
    }

    public void handleTouchInput(int pointerX, int pointerY, int iTouchState) {
        if (!this.isStateLoaded || this.isStateSwitching) {
            return;
        }
        if (this.objIngameStatePlay != null && !this.isNextOnLoading) {
            if (CUtility.isPointInRect(pointerX, pointerY, 0, 0, CCanvas.iScreenW, CCanvas.iScreenH)) {
                this.animShield = null;
                this.animMagnet = null;
                this.objTapFont = null;
                this.strArrMagnetInfo = null;
                this.strArrShieldInfo = null;
                this.isNextOnLoading = true;
                this.objIngameStatePlay.playStartSound();
                this.iBlinkCounter = 0;
            }
            return;
        }
        switch (this.iCurrentState) {
            case 0: {
                if (this.objIngameStatePlay == null) break;
                this.objIngameStatePlay.handleTouchInput(pointerX, pointerY, iTouchState);
                break;
            }
            case 1: {
                if (this.objGameOverScreen == null) break;
                this.objGameOverScreen.handleTouchInput(pointerX, pointerY, iTouchState);
                break;
            }
            case 2: {
                if (this.objBikeSelection == null) break;
                this.objBikeSelection.handleTouchInput(pointerX, pointerY, iTouchState);
                break;
            }
            case 3: {
                if (this.objNameIncert == null) break;
                this.objNameIncert.handleTouchInput(pointerX, pointerY, iTouchState);
                break;
            }
            case 4: {
                if (this.objCutScene == null) break;
                this.objCutScene.handleTouchInput(pointerX, pointerY, iTouchState);
            }
        }
    }

    public void switchToStates(int iNextState) {
        this.isStateSwitching = true;
        switch (this.iCurrentState) {
            case 0: {
                if (this.objIngameStatePlay == null) break;
                this.objIngameStatePlay.unload();
                this.objIngameStatePlay = null;
                break;
            }
            case 1: {
                if (this.objGameOverScreen == null) break;
                this.objGameOverScreen.unload();
                this.objGameOverScreen = null;
                break;
            }
            case 2: {
                if (this.objBikeSelection == null) break;
                this.objBikeSelection.unload();
                this.objBikeSelection = null;
                break;
            }
            case 3: {
                if (this.objNameIncert == null) break;
                this.objNameIncert.unloadImages();
                this.objNameIncert = null;
                break;
            }
            case 4: {
                if (this.objCutScene == null) break;
                this.objCutScene.unload();
                this.objCutScene = null;
            }
        }
        switch (iNextState) {
            case 0: {
                try {
                    this.animShield = new CSpriteAnimation("/shield_strip.png", 4, 2, false, false);
                    this.animMagnet = new CSpriteAnimation("/magnet_strip.png", 4, 2, false, false);
                    this.objTapFont = new customFont(4);
                    this.iFontHeight = CIngameManager.getInstance().objSmallFont.getHeight();
                    this.strArrMagnetInfo = CUtility.getTextRows("The Magnet automatically attracts all nearby coins.", CIngameManager.getInstance().objSmallFont, CCanvas.iScreenW >> 1);
                    this.strArrShieldInfo = CUtility.getTextRows("The Shield makes you invincible to obstacles and traffic.", CIngameManager.getInstance().objSmallFont, CCanvas.iScreenW >> 1);
                    this.iTotalHeight = this.iFontHeight * (this.strArrMagnetInfo.length + this.strArrShieldInfo.length);
                    this.iInfoStartY = (CCanvas.iScreenH >> 2) + ((CCanvas.iScreenH >> 2) - this.iTotalHeight >> 1) - (this.iFontHeight >> 1);
                    this.iBlinkCounter = 0;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.objIngameStatePlay = new CIngameStatePlay();
                this.iLoadingCounter = 0;
                this.isStateLoaded = false;
                this.isNextOnLoading = false;
                this.iTmpIndex = CUtility.getRandomNumberInRange(0, 100) % CGameTexts.strArrTip.length;
                break;
            }
            case 1: {
                this.objGameOverScreen = new CGameOverScreen(this.iLastScore, this.iLastCoinCollected, this.iLatestDistance);
                break;
            }
            case 2: {
                this.objBikeSelection = new CStateBikeSelection();
                break;
            }
            case 3: {
                this.objNameIncert = new CNameInsert(this.objBigFont);
                break;
            }
            case 4: {
                this.objCutScene = new CCutScene();
                System.out.println("Creating cut scene ...");
            }
        }
        this.iCurrentState = iNextState;
        this.isStateSwitching = false;
    }

    public void setRidingData(int score, int coins, int dist, int ammo) {
        if (this.iMaxDistance < dist) {
            this.iMaxDistance = dist;
            gameData.saveData(13, dist);
        }
        if (this.iMaxScore < score) {
            this.iMaxScore = score;
            gameData.saveData(12, score);
            CGameOverScreen.isNewHighScore = true;
        } else {
            CGameOverScreen.isNewHighScore = false;
        }
        if (this.iMostCoinCollected < coins) {
            this.iMostCoinCollected = coins;
            gameData.saveData(14, coins);
        }
        gameData.saveData(2, this.iGames + 1);
        gameData.saveData(3, this.iTotalDist + dist);
        gameData.saveData(1, this.iTotalCoinCollected + coins);
        gameData.saveData(15, this.iLifeTimeCoinCollected + coins);
        if (this.getCurrentBike() == 1) {
            gameData.saveData(8, ammo);
        } else if (this.getCurrentBike() == 2) {
            gameData.saveData(9, ammo);
        }
        this.iTotalDist += dist;
        this.iTotalCoinCollected += coins;
        this.iLifeTimeCoinCollected += coins;
        this.iLastCoinCollected = coins;
        this.iLatestDistance = dist;
        this.iLastScore = score;
        ++this.iGames;
    }

    public void setCurrentBike(int bike) {
        this.iCurrentBike = bike;
    }

    public int getCurrentBike() {
        return this.iCurrentBike;
    }

    public void gameInterrupted(boolean state) {
        switch (this.iCurrentState) {
            case 0: {
                this.objIngameStatePlay.gameInterrupted(state);
            }
        }
    }

    public static CIngameManager getInstance() {
        return instance;
    }
}

