/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.jme.signature;

import com.shephertz.app42.paas.sdk.jme.App42Log;
import java.io.UnsupportedEncodingException;
import net.oauth.jme.Util;
import net.oauth.jme.signature.OAuthSignature;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;

public class HMACSHA1Signature
implements OAuthSignature {
    private String a = "HMAC-SHA1";
    private String b = "";
    private String c;
    private String d = "";

    public String getMethod() {
        return this.a;
    }

    public String getMessage() {
        return this.b;
    }

    public void setMessage(String string) {
        this.b = string;
    }

    public String getKey() {
        return this.c;
    }

    public void setKey(String string) {
        this.c = string;
    }

    public String getSignature() {
        try {
            HMac hMac = new HMac(new SHA1Digest());
            hMac.init(new KeyParameter(this.c.getBytes("UTF-8")));
            byte[] byArray = this.b.getBytes("UTF-8");
            hMac.update(byArray, 0, byArray.length);
            byArray = new byte[hMac.getMacSize()];
            hMac.doFinal(byArray, 0);
            this.d = new String(Util.base64Encode(byArray));
            App42Log.debug("mac alg: " + hMac.getAlgorithmName());
            App42Log.debug("dig alg: " + hMac.getUnderlyingDigest().getAlgorithmName());
            App42Log.debug("key: " + this.c);
            App42Log.debug("message: " + this.b);
            App42Log.debug("unencoded: " + new String(byArray));
            App42Log.debug("sig: " + this.d);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            UnsupportedEncodingException unsupportedEncodingException2 = unsupportedEncodingException;
            unsupportedEncodingException.printStackTrace();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return this.d;
    }
}

