/*
 * Decompiled with CFR 0.152.
 */
package com.shephertz.app42.paas.sdk.jme.achievement;

import com.shephertz.app42.paas.sdk.jme.App42Log;
import com.shephertz.app42.paas.sdk.jme.App42ResponseBuilder;
import com.shephertz.app42.paas.sdk.jme.achievement.Achievement;
import com.shephertz.app42.paas.sdk.jme.util.Util;
import java.util.Vector;
import org.json.jme.JSONArray;
import org.json.jme.JSONObject;

public class AchievementResponseBuilder
extends App42ResponseBuilder {
    public Achievement buildResponse(String json) throws Exception {
        JSONObject achievementsJSONObj = this.getServiceJSONObject("achievements", json);
        JSONObject achievementJSOnObj = achievementsJSONObj.getJSONObject("achievement");
        Achievement achievement = this.buildAchievementObject(achievementJSOnObj);
        achievement.setStrResponse(json);
        achievement.setResponseSuccess(this.isResponseSuccess(json));
        return achievement;
    }

    private Achievement buildAchievementObject(JSONObject achievementJSONObj) throws Exception {
        Achievement achievement = new Achievement();
        this.buildObjectFromJSONTree(achievement, achievementJSONObj);
        return achievement;
    }

    public Vector buildArrayResponse(String json) throws Exception {
        JSONObject achievementsJSONObj = this.getServiceJSONObject("achievements", json);
        Vector<Achievement> achievementList = new Vector<Achievement>();
        if (achievementsJSONObj.get("achievement") instanceof JSONArray) {
            JSONArray achievementJSONArray = achievementsJSONObj.getJSONArray("achievement");
            for (int i = 0; i < achievementJSONArray.length(); ++i) {
                JSONObject achievementJSONObject = achievementJSONArray.getJSONObject(i);
                Achievement achievement = this.buildAchievementObject(achievementJSONObject);
                achievement.setStrResponse(json);
                achievement.setResponseSuccess(this.isResponseSuccess(json));
                achievementList.addElement(achievement);
            }
        } else {
            JSONObject achievementJSONObject = achievementsJSONObj.getJSONObject("achievement");
            Achievement achievement = this.buildAchievementObject(achievementJSONObject);
            achievement.setStrResponse(json);
            achievement.setResponseSuccess(this.isResponseSuccess(json));
            achievementList.addElement(achievement);
        }
        return achievementList;
    }

    public void buildObjectFromJSONTree(Object obj, JSONObject jsonObj) throws Exception {
        if (obj instanceof Achievement) {
            Achievement achievement = (Achievement)obj;
            String[] names = this.getNames(jsonObj);
            if (names != null) {
                for (int i = 0; i < names.length; ++i) {
                    String sendedOn;
                    String name = names[i];
                    if (name.equals("userName")) {
                        achievement.setUserName("" + jsonObj.get(name));
                    }
                    if (name.equals("name")) {
                        achievement.setName("" + jsonObj.get(name));
                    }
                    if (name.equals("description")) {
                        achievement.setDescription("" + jsonObj.get(name));
                    }
                    if (name.equals("gameName")) {
                        achievement.setGameName("" + jsonObj.get(name));
                    }
                    if (!name.equals("achievedOn") || jsonObj.get(name) == null || (sendedOn = "" + jsonObj.get(name)).equals("null")) continue;
                    App42Log.debug("achievedOn Not Null " + jsonObj.get(name));
                    achievement.setAchievedOn(Util.getDateFromUTCTimeStamp("" + jsonObj.get(name)));
                }
            }
        }
    }
}

