/*
 * Decompiled with CFR 0.152.
 */
package com.shephertz.app42.paas.sdk.jme.connection;

import com.shephertz.app42.paas.sdk.jme.App42BadParameterException;
import com.shephertz.app42.paas.sdk.jme.App42Exception;
import com.shephertz.app42.paas.sdk.jme.App42LimitException;
import com.shephertz.app42.paas.sdk.jme.App42Log;
import com.shephertz.app42.paas.sdk.jme.App42NotFoundException;
import com.shephertz.app42.paas.sdk.jme.App42SecurityException;
import com.shephertz.app42.paas.sdk.jme.Config;
import com.shephertz.app42.paas.sdk.jme.ConfigurationException;
import com.shephertz.app42.paas.sdk.jme.util.URLEncoder;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.io.HttpsConnection;
import net.oauth.jme.Util;
import org.json.jme.JSONObject;

public class RESTConnectorAsync {
    private String baseURL = Config.getInstance().getBaseURL();
    private String customCodeURL = Config.getInstance().getCustomCodeURL();
    private static final RESTConnectorAsync restCon = null;
    int TIMEOUT_MILLISEC = 60000;

    private RESTConnectorAsync() throws ConfigurationException {
    }

    public static RESTConnectorAsync getInstance() throws ConfigurationException {
        if (restCon == null) {
            return new RESTConnectorAsync();
        }
        return restCon;
    }

    public String executeGet(String url, Hashtable params, Hashtable headerParams) throws Exception {
        String result = null;
        result = url.startsWith("https") ? this.executeGetHttps(url, params, headerParams) : this.executeGetHttp(url, params, headerParams);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executeGetHttp(String url, Hashtable params, Hashtable headerParams) throws Exception {
        Hashtable queryParams = new Hashtable();
        String apiKey = (String)params.remove("apiKey");
        String timeStamp = (String)params.remove("timeStamp");
        String sessionId = (String)params.remove("sessionId");
        String adminKey = (String)params.remove("adminKey");
        queryParams = Util.hashtableMerge(queryParams, params);
        StringBuffer queryString = new StringBuffer("?");
        Enumeration enumKeys = queryParams.keys();
        while (enumKeys.hasMoreElements()) {
            String key = (String)enumKeys.nextElement();
            String value = (String)queryParams.get(key);
            queryString.append(URLEncoder.encode(key) + "=" + URLEncoder.encode(value) + "&");
            App42Log.debug(" Setting value :" + key + " : " + value);
        }
        App42Log.debug(" QueryString is " + queryString);
        App42Log.debug(" URL is " + url);
        String encodedUrl = URLEncoder.encode(url);
        String replaceUrl = Util.replace(encodedUrl, "+", "%20");
        App42Log.debug(" QueryString is " + queryString);
        String uri = this.baseURL + Util.replace(replaceUrl, "%2f", "/") + queryString;
        App42Log.debug(" Requested URL is " + uri);
        HttpConnection httpConn = null;
        StringBuffer responseStr = new StringBuffer();
        InputStream is = null;
        OutputStream os = null;
        try {
            httpConn = (HttpConnection)Connector.open((String)uri);
            httpConn.setRequestMethod("GET");
            httpConn.setRequestProperty("User-Agent", "Profile/MIDP-1.0 Confirguration/CLDC-1.0");
            httpConn.setRequestProperty("Content-Type", Config.getInstance().getContentType());
            httpConn.setRequestProperty("Accept", Config.getInstance().getAccept());
            httpConn.setRequestProperty("timeStamp", timeStamp);
            Enumeration enumKeysHeader = headerParams.keys();
            while (enumKeysHeader.hasMoreElements()) {
                String key = (String)enumKeysHeader.nextElement();
                String value = (String)headerParams.get(key);
                httpConn.setRequestProperty(key, value);
            }
            int respCode = httpConn.getResponseCode();
            if (respCode == 200) {
                int chr;
                is = httpConn.openDataInputStream();
                while ((chr = is.read()) != -1) {
                    responseStr.append((char)chr);
                }
                App42Log.debug("Response #" + responseStr);
            } else {
                int chr;
                App42Log.debug("Error in opening HTTP Connection. Error#" + respCode);
                is = httpConn.openDataInputStream();
                while ((chr = is.read()) != -1) {
                    responseStr.append((char)chr);
                }
                App42Log.debug(" Exception Message is : " + responseStr);
                this.throwSpecializedException(responseStr.toString());
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
            if (httpConn != null) {
                httpConn.close();
            }
        }
        return responseStr.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executeGetHttps(String url, Hashtable params, Hashtable headserParams) throws Exception {
        Hashtable queryParams = new Hashtable();
        String apiKey = (String)params.remove("apiKey");
        String timeStamp = (String)params.remove("timeStamp");
        String sessionId = (String)params.remove("sessionId");
        String adminKey = (String)params.remove("adminKey");
        queryParams = Util.hashtableMerge(queryParams, params);
        StringBuffer queryString = new StringBuffer("?");
        Enumeration enumKeys = queryParams.keys();
        while (enumKeys.hasMoreElements()) {
            String key = (String)enumKeys.nextElement();
            String value = (String)queryParams.get(key);
            queryString.append(URLEncoder.encode(key) + "=" + URLEncoder.encode(value) + "&");
            App42Log.debug(" Setting value :" + key + " : " + value);
        }
        App42Log.debug(" QueryString is " + queryString);
        App42Log.debug(" URL is " + url);
        String encodedUrl = URLEncoder.encode(url);
        String replaceUrl = Util.replace(encodedUrl, "+", "%20");
        App42Log.debug(" QueryString is " + queryString);
        String uri = this.baseURL + Util.replace(replaceUrl, "%2f", "/") + queryString;
        App42Log.debug(" Requested URL is " + uri);
        HttpsConnection httpsConn = null;
        StringBuffer responseStr = new StringBuffer();
        InputStream is = null;
        OutputStream os = null;
        try {
            httpsConn = (HttpsConnection)Connector.open((String)uri);
            httpsConn.setRequestMethod("GET");
            httpsConn.setRequestProperty("User-Agent", "Profile/MIDP-1.0 Confirguration/CLDC-1.0");
            httpsConn.setRequestProperty("Content-Type", Config.getInstance().getContentType());
            httpsConn.setRequestProperty("Accept", Config.getInstance().getAccept());
            httpsConn.setRequestProperty("timeStamp", timeStamp);
            Enumeration enumKeysHeader = headserParams.keys();
            while (enumKeysHeader.hasMoreElements()) {
                String key = (String)enumKeysHeader.nextElement();
                String value = (String)headserParams.get(key);
                httpsConn.setRequestProperty(key, value);
            }
            int respCode = httpsConn.getResponseCode();
            if (respCode == 200) {
                int chr;
                is = httpsConn.openDataInputStream();
                while ((chr = is.read()) != -1) {
                    responseStr.append((char)chr);
                }
                App42Log.debug("Response #" + responseStr);
            } else {
                int chr;
                App42Log.debug("Error in opening HTTP Connection. Error#" + respCode);
                is = httpsConn.openDataInputStream();
                while ((chr = is.read()) != -1) {
                    responseStr.append((char)chr);
                }
                App42Log.debug(" Exception Message is : " + responseStr);
                this.throwSpecializedException(responseStr.toString());
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
            if (httpsConn != null) {
                httpsConn.close();
            }
        }
        return responseStr.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executePost(String url, Hashtable params, String bodyPayload, Hashtable headerParams) throws Exception {
        Hashtable queryParams = new Hashtable();
        String apiKey = (String)params.remove("apiKey");
        String timeStamp = (String)params.remove("timeStamp");
        String sessionId = (String)params.remove("sessionId");
        String adminKey = (String)params.remove("adminKey");
        queryParams = Util.hashtableMerge(queryParams, params);
        StringBuffer queryString = new StringBuffer("?");
        Enumeration enumKeys = queryParams.keys();
        while (enumKeys.hasMoreElements()) {
            String key = (String)enumKeys.nextElement();
            String value = (String)queryParams.get(key);
            queryString.append(URLEncoder.encode(key) + "=" + URLEncoder.encode(value) + "&");
            App42Log.debug(" Setting value :" + key + " : " + value);
        }
        String encodedUrl = URLEncoder.encode(url);
        String replaceUrl = Util.replace(encodedUrl, "+", "%20");
        App42Log.debug(" QueryString is " + queryString);
        String uri = this.baseURL + Util.replace(replaceUrl, "%2f", "/") + queryString;
        App42Log.debug(" Requested URL is " + uri);
        App42Log.debug(" QueryString is " + queryString);
        App42Log.debug(" Requested URL is " + uri);
        HttpConnection httpConn = null;
        StringBuffer responseStr = new StringBuffer();
        InputStream is = null;
        FilterOutputStream os = null;
        try {
            httpConn = (HttpConnection)Connector.open((String)uri, (int)3, (boolean)true);
            httpConn.setRequestMethod("POST");
            httpConn.setRequestProperty("User-Agent", "Profile/MIDP-1.0 Confirguration/CLDC-1.0");
            httpConn.setRequestProperty("Content-Type", Config.getInstance().getContentType());
            httpConn.setRequestProperty("Accept", Config.getInstance().getAccept());
            httpConn.setRequestProperty("timeStamp", timeStamp);
            Enumeration enumKeysHeader = headerParams.keys();
            while (enumKeysHeader.hasMoreElements()) {
                String key = (String)enumKeysHeader.nextElement();
                String value = (String)headerParams.get(key);
                httpConn.setRequestProperty(key, value);
            }
            os = httpConn.openDataOutputStream();
            byte[] request_body = bodyPayload.getBytes();
            for (int i = 0; i < request_body.length; ++i) {
                ((DataOutputStream)os).writeByte(request_body[i]);
            }
            ((DataOutputStream)os).flush();
            int respCode = httpConn.getResponseCode();
            if (respCode == 200) {
                int chr;
                is = httpConn.openDataInputStream();
                while ((chr = is.read()) != -1) {
                    responseStr.append((char)chr);
                }
            } else {
                int chr;
                App42Log.debug("Error in opening HTTP Connection. Error#" + respCode);
                is = httpConn.openDataInputStream();
                while ((chr = is.read()) != -1) {
                    responseStr.append((char)chr);
                }
                App42Log.debug(" Exception Message is : " + responseStr);
                this.throwSpecializedException(responseStr.toString());
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
            if (httpConn != null) {
                httpConn.close();
            }
        }
        return responseStr.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executePut(String url, Hashtable params, String bodyPayload, Hashtable headerParams) throws Exception {
        Hashtable queryParams = new Hashtable();
        String apiKey = (String)params.remove("apiKey");
        String timeStamp = (String)params.remove("timeStamp");
        String sessionId = (String)params.remove("sessionId");
        String adminKey = (String)params.remove("adminKey");
        queryParams = Util.hashtableMerge(queryParams, params);
        StringBuffer queryString = new StringBuffer("?");
        Enumeration enumKeys = queryParams.keys();
        while (enumKeys.hasMoreElements()) {
            String key = (String)enumKeys.nextElement();
            String value = (String)queryParams.get(key);
            queryString.append(URLEncoder.encode(key) + "=" + URLEncoder.encode(value) + "&");
            App42Log.debug(" Setting value :" + key + " : " + value);
        }
        queryString.append("_method=PUT");
        App42Log.debug(" QueryString is " + queryString);
        App42Log.debug(" URL is " + url);
        String encodedUrl = URLEncoder.encode(url);
        String replaceUrl = Util.replace(encodedUrl, "+", "%20");
        App42Log.debug("Encoded  URL is " + url);
        String uri = this.baseURL + Util.replace(replaceUrl, "%2f", "/") + queryString;
        App42Log.debug(" Requested URL is " + uri);
        App42Log.debug(" Body : " + bodyPayload);
        App42Log.debug(" QueryString is " + queryString);
        App42Log.debug(" Requested URL is " + uri);
        HttpConnection httpConn = null;
        StringBuffer responseStr = new StringBuffer();
        InputStream is = null;
        FilterOutputStream dos = null;
        try {
            httpConn = (HttpConnection)Connector.open((String)uri);
            httpConn = (HttpConnection)Connector.open((String)uri, (int)3);
            httpConn.setRequestMethod("POST");
            httpConn.setRequestProperty("User-Agent", "Profile/MIDP-1.0 Confirguration/CLDC-1.0");
            httpConn.setRequestProperty("Content-Type", Config.getInstance().getContentType());
            httpConn.setRequestProperty("Accept", Config.getInstance().getAccept());
            httpConn.setRequestProperty("timeStamp", timeStamp);
            Enumeration enumKeysHeader = headerParams.keys();
            while (enumKeysHeader.hasMoreElements()) {
                String key = (String)enumKeysHeader.nextElement();
                String value = (String)headerParams.get(key);
                httpConn.setRequestProperty(key, value);
            }
            dos = httpConn.openDataOutputStream();
            byte[] request_body = bodyPayload.getBytes();
            for (int i = 0; i < request_body.length; ++i) {
                ((DataOutputStream)dos).writeByte(request_body[i]);
            }
            ((DataOutputStream)dos).flush();
            int respCode = httpConn.getResponseCode();
            if (respCode == 200) {
                int chr;
                is = httpConn.openDataInputStream();
                while ((chr = is.read()) != -1) {
                    responseStr.append((char)chr);
                }
            } else {
                int chr;
                App42Log.debug("Error in opening HTTP Connection. Error#" + respCode);
                is = httpConn.openDataInputStream();
                while ((chr = is.read()) != -1) {
                    responseStr.append((char)chr);
                }
                App42Log.debug(" Exception Message is : " + responseStr);
                this.throwSpecializedException(responseStr.toString());
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (dos != null) {
                dos.close();
            }
            if (httpConn != null) {
                httpConn.close();
            }
        }
        return responseStr.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeDelete(String url, Hashtable params, Hashtable headerParams) throws Exception {
        Hashtable queryParams = new Hashtable();
        String apiKey = (String)params.remove("apiKey");
        String timeStamp = (String)params.remove("timeStamp");
        String sessionId = (String)params.remove("sessionId");
        String adminKey = (String)params.remove("adminKey");
        queryParams = Util.hashtableMerge(queryParams, params);
        StringBuffer queryString = new StringBuffer("?");
        Enumeration enumKeys = queryParams.keys();
        while (enumKeys.hasMoreElements()) {
            String key = (String)enumKeys.nextElement();
            String value = (String)queryParams.get(key);
            queryString.append(URLEncoder.encode(key) + "=" + URLEncoder.encode(value) + "&");
            App42Log.debug(" Setting value :" + key + " : " + value);
        }
        queryString.append("_method=DELETE");
        String encodedUrl = URLEncoder.encode(url);
        String replaceUrl = Util.replace(encodedUrl, "+", "%20");
        App42Log.debug("Encoded  URL is " + url);
        String uri = this.baseURL + Util.replace(replaceUrl, "%2f", "/") + queryString;
        App42Log.debug(" Requested URL is " + uri);
        App42Log.debug(" QueryString is " + queryString);
        App42Log.debug("Encoded  URL is " + url);
        HttpConnection httpConn = null;
        StringBuffer responseStr = new StringBuffer();
        InputStream is = null;
        OutputStream os = null;
        try {
            httpConn = (HttpConnection)Connector.open((String)uri, (int)3);
            httpConn.setRequestMethod("POST");
            httpConn.setRequestProperty("User-Agent", "Profile/MIDP-1.0 Confirguration/CLDC-1.0");
            httpConn.setRequestProperty("Content-Type", Config.getInstance().getContentType());
            httpConn.setRequestProperty("Accept", Config.getInstance().getAccept());
            httpConn.setRequestProperty("timeStamp", timeStamp);
            Enumeration enumKeysHeader = headerParams.keys();
            while (enumKeysHeader.hasMoreElements()) {
                String key = (String)enumKeysHeader.nextElement();
                String value = (String)headerParams.get(key);
                httpConn.setRequestProperty(key, value);
            }
            int respCode = httpConn.getResponseCode();
            if (respCode == 200) {
                int chr;
                os = httpConn.openOutputStream();
                is = httpConn.openDataInputStream();
                while ((chr = is.read()) != -1) {
                    responseStr.append((char)chr);
                }
            } else {
                int chr;
                App42Log.debug("Error in opening HTTP Connection. Error#" + respCode);
                is = httpConn.openDataInputStream();
                while ((chr = is.read()) != -1) {
                    responseStr.append((char)chr);
                }
                App42Log.debug(" Exception Message is : " + responseStr);
                this.throwSpecializedException(responseStr.toString());
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
            if (httpConn != null) {
                httpConn.close();
            }
        }
        return responseStr.toString();
    }

    private void throwSpecializedException(String exceptionMessage) throws Exception {
        String str = exceptionMessage;
        JSONObject jsonObj = new JSONObject(str);
        int httpErrorCode = Integer.valueOf(jsonObj.getJSONObject("app42Fault").getString("httpErrorCode"));
        int appErrorCode = Integer.valueOf(jsonObj.getJSONObject("app42Fault").getString("appErrorCode"));
        if (httpErrorCode == 404) {
            throw new App42NotFoundException(str, httpErrorCode, appErrorCode);
        }
        if (httpErrorCode == 400) {
            throw new App42BadParameterException(str, httpErrorCode, appErrorCode);
        }
        if (httpErrorCode == 401) {
            throw new App42SecurityException(str, httpErrorCode, appErrorCode);
        }
        if (httpErrorCode == 413) {
            throw new App42LimitException(str, httpErrorCode, 1413);
        }
        if (httpErrorCode == 500) {
            throw new App42Exception(str, httpErrorCode, appErrorCode);
        }
        throw new App42Exception("We are sorry something has gone wrong on our side", 500, 1500);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCustomCode(String url, Hashtable params, String bodyPayload, Hashtable headerParams) throws Exception {
        Hashtable queryParams = new Hashtable();
        String apiKey = (String)params.remove("apiKey");
        String timeStamp = (String)params.remove("timeStamp");
        queryParams = Util.hashtableMerge(queryParams, params);
        StringBuffer queryString = new StringBuffer("?");
        Enumeration enumKeys = queryParams.keys();
        while (enumKeys.hasMoreElements()) {
            String key = (String)enumKeys.nextElement();
            String value = (String)queryParams.get(key);
            queryString.append(URLEncoder.encode(key) + "=" + URLEncoder.encode(value) + "&");
            App42Log.debug(" Setting value :" + key + " : " + value);
        }
        App42Log.debug(" QueryString is " + queryString);
        url = Util.replace(url, " ", "%20");
        App42Log.debug(" URL is " + url);
        String encodedUrl = URLEncoder.encode(url);
        String replaceUrl = Util.replace(encodedUrl, "+", "%20");
        String uri = this.customCodeURL + Util.replace(replaceUrl, "%2f", "/") + queryString;
        App42Log.debug(" Requested URL is " + uri);
        App42Log.debug(" QueryString is " + queryString);
        App42Log.debug("Encoded  URL is " + url);
        HttpConnection httpConn = null;
        StringBuffer responseStr = new StringBuffer();
        InputStream is = null;
        FilterOutputStream os = null;
        try {
            httpConn = (HttpConnection)Connector.open((String)uri, (int)3, (boolean)true);
            httpConn.setRequestMethod("POST");
            httpConn.setRequestProperty("User-Agent", "Profile/MIDP-1.0 Confirguration/CLDC-1.0");
            httpConn.setRequestProperty("Content-Type", Config.getInstance().getContentType());
            httpConn.setRequestProperty("Accept", Config.getInstance().getAccept());
            httpConn.setRequestProperty("timeStamp", timeStamp);
            Enumeration enumKeysHeader = headerParams.keys();
            while (enumKeysHeader.hasMoreElements()) {
                String key = (String)enumKeysHeader.nextElement();
                String value = (String)headerParams.get(key);
                httpConn.setRequestProperty(key, value);
            }
            os = httpConn.openDataOutputStream();
            byte[] request_body = bodyPayload.getBytes();
            for (int i = 0; i < request_body.length; ++i) {
                ((DataOutputStream)os).writeByte(request_body[i]);
            }
            ((DataOutputStream)os).flush();
            int respCode = httpConn.getResponseCode();
            if (respCode == 200) {
                int chr;
                is = httpConn.openDataInputStream();
                while ((chr = is.read()) != -1) {
                    responseStr.append((char)chr);
                }
            } else {
                int chr;
                App42Log.debug("Error in opening HTTP Connection. Error#" + respCode);
                is = httpConn.openDataInputStream();
                while ((chr = is.read()) != -1) {
                    responseStr.append((char)chr);
                }
                App42Log.debug(" Exception Message is : " + responseStr);
                this.throwSpecializedException(responseStr.toString());
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
            if (httpConn != null) {
                httpConn.close();
            }
        }
        return responseStr.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeGet(String url) throws Exception {
        StringBuffer responseStr;
        block9: {
            HttpConnection httpConn = null;
            responseStr = new StringBuffer();
            InputStream is = null;
            OutputStream os = null;
            try {
                int chr;
                httpConn = (HttpConnection)Connector.open((String)url);
                httpConn.setRequestMethod("GET");
                httpConn.setRequestProperty("User-Agent", "Profile/MIDP-1.0 Confirguration/CLDC-1.0");
                httpConn.setRequestProperty("Content-Type", Config.getInstance().getContentType());
                httpConn.setRequestProperty("Accept", Config.getInstance().getAccept());
                int respCode = httpConn.getResponseCode();
                if (respCode == 200) {
                    int chr2;
                    is = httpConn.openDataInputStream();
                    while ((chr2 = is.read()) != -1) {
                        responseStr.append((char)chr2);
                    }
                    App42Log.debug("Response #" + responseStr);
                    break block9;
                }
                App42Log.debug("Error in opening HTTP Connection. Error#" + respCode);
                is = httpConn.openDataInputStream();
                while ((chr = is.read()) != -1) {
                    responseStr.append((char)chr);
                }
                App42Log.debug(" Exception Message is : " + responseStr);
                throw new App42Exception(responseStr.toString());
            }
            finally {
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
                if (httpConn != null) {
                    httpConn.close();
                }
            }
        }
        return responseStr.toString();
    }
}

