/*
 * Decompiled with CFR 0.152.
 */
package com.shephertz.app42.paas.sdk.jme.customcode;

import com.shephertz.app42.paas.sdk.jme.App42CallBack;
import com.shephertz.app42.paas.sdk.jme.App42Exception;
import com.shephertz.app42.paas.sdk.jme.App42Log;
import com.shephertz.app42.paas.sdk.jme.App42Service;
import com.shephertz.app42.paas.sdk.jme.connection.RESTConnectorAsync;
import com.shephertz.app42.paas.sdk.jme.util.Util;
import java.util.Hashtable;
import org.json.jme.JSONObject;

public class CustomCodeService
extends App42Service {
    private String resource = "customCode";

    public CustomCodeService(String apiKey, String secretKey) {
        this.apiKey = apiKey;
        this.secretKey = secretKey;
        this.version = "1.0";
    }

    public JSONObject runJavaCode(String name, JSONObject jsonBody) {
        String response = null;
        Util.throwExceptionIfNullOrBlank(name, "File Name");
        JSONObject jsonResponse = null;
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            if (jsonBody == null) {
                jsonBody = new JSONObject();
            }
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/run/java/" + name;
            response = RESTConnectorAsync.getInstance().executeCustomCode(resourceURL, queryParams, jsonBody.toString(), headerParams);
            jsonResponse = new JSONObject(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return jsonResponse;
    }

    public void runJavaCode(final String name, final JSONObject jsonBody, final App42CallBack callBack) {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    JSONObject customCode = CustomCodeService.this.runJavaCode(name, jsonBody);
                    callBack.onSuccess(customCode);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }
}

