/*
 * Decompiled with CFR 0.152.
 */
package com.shephertz.app42.paas.sdk.jme.gallery;

import com.shephertz.app42.paas.sdk.jme.App42CallBack;
import com.shephertz.app42.paas.sdk.jme.App42Exception;
import com.shephertz.app42.paas.sdk.jme.App42Log;
import com.shephertz.app42.paas.sdk.jme.App42Response;
import com.shephertz.app42.paas.sdk.jme.App42Service;
import com.shephertz.app42.paas.sdk.jme.Config;
import com.shephertz.app42.paas.sdk.jme.connection.RESTConnectorAsync;
import com.shephertz.app42.paas.sdk.jme.gallery.Album;
import com.shephertz.app42.paas.sdk.jme.gallery.AlbumResponseBuilder;
import com.shephertz.app42.paas.sdk.jme.util.Util;
import java.util.Hashtable;
import java.util.Vector;
import org.json.jme.JSONObject;

public class AlbumService
extends App42Service {
    private Config config = Config.getInstance();
    private String resource = "gallery";
    private String baseURL;

    public AlbumService(String apiKey, String secretKey, String baseURL) {
        this.apiKey = apiKey;
        this.secretKey = secretKey;
        this.baseURL = baseURL;
        this.version = "1.0";
    }

    public Album createAlbum(String userName, String albumName, String albumDescription) throws App42Exception {
        String response = null;
        Album album = null;
        Util.throwExceptionIfNullOrBlank(userName, "User Name");
        Util.throwExceptionIfNullOrBlank(albumName, "Album Name");
        Util.throwExceptionIfNullOrBlank(albumDescription, "Description");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            JSONObject obj = new JSONObject();
            obj.put("name", albumName);
            obj.put("description", albumDescription);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"album\":").append(obj.toString()).append("}}");
            App42Log.debug(" Json String : " + sb.toString());
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/album" + "/" + userName;
            response = RESTConnectorAsync.getInstance().executePost(resourceURL, queryParams, sb.toString(), headerParams);
            album = new AlbumResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return album;
    }

    public void createAlbum(final String userName, final String albumName, final String albumDescription, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Album album = AlbumService.this.createAlbum(userName, albumName, albumDescription);
                    callBack.onSuccess(album);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Vector getAlbums(String userName) throws App42Exception {
        String response = null;
        Util.throwExceptionIfNullOrBlank(userName, "User Name");
        Vector albumList = null;
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("userName", userName);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/album" + "/" + userName;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            albumList = new AlbumResponseBuilder().buildArrayResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return albumList;
    }

    public void getAlbums(final String userName, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Vector album = AlbumService.this.getAlbums(userName);
                    callBack.onSuccess(album);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public App42Response getAlbumsCount(String userName) throws App42Exception {
        String response = null;
        Util.throwExceptionIfNullOrBlank(userName, "User Name");
        App42Response responseObj = new App42Response();
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("userName", userName);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/album" + "/" + userName + "/" + "count";
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            responseObj.setStrResponse(response);
            responseObj.setResponseSuccess(true);
            responseObj.setTotalRecords(new AlbumResponseBuilder().getTotalRecords(response));
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return responseObj;
    }

    public void getAlbumsCount(final String userName, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    App42Response album = AlbumService.this.getAlbumsCount(userName);
                    callBack.onSuccess(album);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Vector getAlbums(String userName, Integer max, Integer offset) throws App42Exception {
        String response = null;
        Util.validateMax(max);
        Util.throwExceptionIfNullOrBlank(userName, "User Name");
        Util.throwExceptionIfNullOrBlank(max, "Max");
        Util.throwExceptionIfNullOrBlank(offset, "Offset");
        Vector albumList = null;
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("userName", userName);
            signParams.put("max", "" + max);
            signParams.put("offset", "" + offset);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/album" + "/" + userName + "/" + max + "/" + offset;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            albumList = new AlbumResponseBuilder().buildArrayResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return albumList;
    }

    public void getAlbums(final String userName, final Integer max, final Integer offset, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Vector album = AlbumService.this.getAlbums(userName, max, offset);
                    callBack.onSuccess(album);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Album getAlbumByName(String userName, String albumName) throws App42Exception {
        String response = null;
        Album album = null;
        Util.throwExceptionIfNullOrBlank(userName, "User Name");
        Util.throwExceptionIfNullOrBlank(albumName, "Album Name");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("albumName", albumName);
            signParams.put("userName", userName);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/album" + "/" + userName + "/" + albumName;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            album = new AlbumResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return album;
    }

    public void getAlbumByName(final String userName, final String albumName, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Album album = AlbumService.this.getAlbumByName(userName, albumName);
                    callBack.onSuccess(album);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public App42Response removeAlbum(String userName, String albumName) throws App42Exception {
        String response = null;
        App42Response responseObj = new App42Response();
        Util.throwExceptionIfNullOrBlank(userName, "User Name");
        Util.throwExceptionIfNullOrBlank(albumName, "Album Name");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("userName", userName);
            signParams.put("albumName", albumName);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + userName + "/" + albumName;
            response = RESTConnectorAsync.getInstance().executeDelete(resourceURL, queryParams, headerParams);
            responseObj.setStrResponse(response);
            responseObj.setResponseSuccess(true);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return responseObj;
    }

    public void removeAlbum(final String userName, final String albumName, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    App42Response album = AlbumService.this.removeAlbum(userName, albumName);
                    callBack.onSuccess(album);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public void setAdminKey(String adminKey) {
        this.adminKey = adminKey;
    }
}

