/*
 * Decompiled with CFR 0.152.
 */
package com.shephertz.app42.paas.sdk.jme.gallery;

import com.shephertz.app42.paas.sdk.jme.ACL;
import com.shephertz.app42.paas.sdk.jme.App42CallBack;
import com.shephertz.app42.paas.sdk.jme.App42Exception;
import com.shephertz.app42.paas.sdk.jme.App42Log;
import com.shephertz.app42.paas.sdk.jme.App42Response;
import com.shephertz.app42.paas.sdk.jme.App42Service;
import com.shephertz.app42.paas.sdk.jme.Config;
import com.shephertz.app42.paas.sdk.jme.connection.RESTConnectorAsync;
import com.shephertz.app42.paas.sdk.jme.gallery.Album;
import com.shephertz.app42.paas.sdk.jme.gallery.AlbumResponseBuilder;
import com.shephertz.app42.paas.sdk.jme.util.Util;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.json.jme.JSONArray;
import org.json.jme.JSONObject;

public class PhotoService
extends App42Service {
    private String resource = "gallery";

    public PhotoService(String apiKey, String secretKey, String baseURL) {
        this.apiKey = apiKey;
        this.secretKey = secretKey;
        this.version = "1.0";
    }

    public String testUpload(String path) throws Exception {
        return null;
    }

    public Album addPhoto(String userName, String albumName, String photoName, String photoDescription, InputStream imageIS) throws App42Exception {
        String response = null;
        Album album = null;
        Util.throwExceptionIfNullOrBlank(userName, "User Name");
        Util.throwExceptionIfNullOrBlank(albumName, "Album Name");
        Util.throwExceptionIfNullOrBlank(photoName, "Photo Name");
        Util.throwExceptionIfNotValidExtension(photoName);
        Util.throwExceptionIfNullOrBlank(photoDescription, "Description");
        Util.throwExceptionIfNullOrBlank(imageIS, "Image Input Stream");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            Hashtable<String, String> postParams = new Hashtable<String, String>();
            postParams.put("userName", userName);
            postParams.put("albumName", albumName);
            postParams.put("name", photoName);
            postParams.put("description", photoDescription);
            signParams = net.oauth.jme.Util.hashtableMerge(signParams, postParams);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceUrl = Config.getInstance().getBaseURL() + this.version + "/" + this.resource + "/" + userName;
            response = Util.multiPartRequest("imageFile", imageIS, photoName, queryParams, postParams, headerParams, resourceUrl, Config.getInstance().getAccept());
            album = new AlbumResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return album;
    }

    public void addPhoto(final String userName, final String albumName, final String photoName, final String photoDescription, final InputStream imageIS, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Album album = PhotoService.this.addPhoto(userName, albumName, photoName, photoDescription, imageIS);
                    callBack.onSuccess(album);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Album addTagToPhoto(String userName, String albumName, String photoName, Vector tagList) throws App42Exception {
        String response = null;
        Album album = null;
        Util.throwExceptionIfNullOrBlank(userName, "User Name");
        Util.throwExceptionIfNullOrBlank(albumName, "Album Name");
        Util.throwExceptionIfNullOrBlank(photoName, "Photo Name");
        Util.throwExceptionIfNullOrBlank(tagList, "TagList");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            JSONArray tagArray = new JSONArray();
            JSONObject obj = new JSONObject();
            obj.put("userName", userName);
            obj.put("albumName", albumName);
            obj.put("photoName", photoName);
            for (int i = 0; i < tagList.size(); ++i) {
                String tag = (String)tagList.elementAt(i);
                tagArray.put(tag);
            }
            obj.put("tags", "{\"tag\":" + tagArray + "}");
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"photo\":").append(obj.toString()).append("}}");
            App42Log.debug(" Json String : " + sb.toString());
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/tag";
            response = RESTConnectorAsync.getInstance().executePost(resourceURL, queryParams, sb.toString(), headerParams);
            album = new AlbumResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return album;
    }

    public void addTagToPhoto(final String userName, final String albumName, final String photoName, final Vector tagList, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Album album = PhotoService.this.addTagToPhoto(userName, albumName, photoName, tagList);
                    callBack.onSuccess(album);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Vector getPhotos(String userName) throws App42Exception {
        String response = null;
        Util.throwExceptionIfNullOrBlank(userName, "User Name");
        Vector albumList = null;
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("userName", userName);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + userName;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            albumList = new AlbumResponseBuilder().buildArrayResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return albumList;
    }

    public void getPhotos(final String userName, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Vector album = PhotoService.this.getPhotos(userName);
                    callBack.onSuccess(album);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Vector getTaggedPhotos(String userName, String tag) throws App42Exception {
        String response = null;
        Util.throwExceptionIfNullOrBlank(userName, "User Name");
        Util.throwExceptionIfNullOrBlank(tag, "Tag");
        Vector albumList = null;
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("userName", userName);
            signParams.put("tag", tag);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + "tag" + "/" + tag + "/userName/" + userName;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            albumList = new AlbumResponseBuilder().buildArrayResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return albumList;
    }

    public void getTaggedPhotos(final String userName, final String tag, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Vector album = PhotoService.this.getTaggedPhotos(userName, tag);
                    callBack.onSuccess(album);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Album getPhotosByAlbumName(String userName, String albumName) throws App42Exception {
        String response = null;
        Album album = null;
        Util.throwExceptionIfNullOrBlank(userName, "User Name");
        Util.throwExceptionIfNullOrBlank(albumName, "Album Name");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("userName", userName);
            signParams.put("albumName", albumName);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + userName + "/" + albumName;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            album = new AlbumResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return album;
    }

    public void getPhotosByAlbumName(final String userName, final String albumName, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Album album = PhotoService.this.getPhotosByAlbumName(userName, albumName);
                    callBack.onSuccess(album);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public App42Response getPhotosCountByAlbumName(String userName, String albumName) throws App42Exception {
        String response = null;
        Util.throwExceptionIfNullOrBlank(userName, "User Name");
        Util.throwExceptionIfNullOrBlank(albumName, "Album Name");
        App42Response responseObj = new App42Response();
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("userName", userName);
            signParams.put("albumName", albumName);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + userName + "/" + albumName + "/count";
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            responseObj.setStrResponse(response);
            responseObj.setResponseSuccess(true);
            responseObj.setTotalRecords(new AlbumResponseBuilder().getTotalRecords(response));
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return responseObj;
    }

    public void getPhotosCountByAlbumName(final String userName, final String albumName, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    App42Response album = PhotoService.this.getPhotosCountByAlbumName(userName, albumName);
                    callBack.onSuccess(album);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Album getPhotosByAlbumName(String userName, String albumName, Integer max, Integer offset) throws App42Exception {
        String response = null;
        Album album = null;
        Util.validateMax(max);
        Util.throwExceptionIfNullOrBlank(userName, "User Name");
        Util.throwExceptionIfNullOrBlank(albumName, "Album Name");
        Util.throwExceptionIfNullOrBlank(max, "Max");
        Util.throwExceptionIfNullOrBlank(offset, "Offset");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("userName", userName);
            signParams.put("albumName", albumName);
            signParams.put("max", "" + max);
            signParams.put("offset", "" + offset);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + "album" + "/" + userName + "/" + albumName + "/paging" + "/" + max + "/" + offset;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            album = new AlbumResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return album;
    }

    public void getPhotosByAlbumName(final String userName, final String albumName, final Integer max, final Integer offset, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Album album = PhotoService.this.getPhotosByAlbumName(userName, albumName, max, offset);
                    callBack.onSuccess(album);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Album getPhotosByAlbumAndPhotoName(String userName, String albumName, String photoName) throws App42Exception {
        String response = null;
        Album album = null;
        Util.throwExceptionIfNullOrBlank(userName, "User Name");
        Util.throwExceptionIfNullOrBlank(albumName, "Album Name");
        Util.throwExceptionIfNullOrBlank(photoName, "Photo Name");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("userName", userName);
            signParams.put("albumName", albumName);
            signParams.put("name", photoName);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + userName + "/" + albumName + "/" + photoName;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            album = new AlbumResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return album;
    }

    public void getPhotosByAlbumAndPhotoName(final String userName, final String albumName, final String photoName, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Album album = PhotoService.this.getPhotosByAlbumAndPhotoName(userName, albumName, photoName);
                    callBack.onSuccess(album);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public App42Response removePhoto(String userName, String albumName, String photoName) throws App42Exception {
        String response = null;
        App42Response responseObj = new App42Response();
        Util.throwExceptionIfNullOrBlank(userName, "User Name");
        Util.throwExceptionIfNullOrBlank(albumName, "Album Name");
        Util.throwExceptionIfNullOrBlank(photoName, "Photo Name");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("userName", userName);
            signParams.put("albumName", albumName);
            signParams.put("name", photoName);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + userName + "/" + albumName + "/" + photoName;
            response = RESTConnectorAsync.getInstance().executeDelete(resourceURL, queryParams, headerParams);
            responseObj.setStrResponse(response);
            responseObj.setResponseSuccess(true);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return responseObj;
    }

    public void removePhoto(final String userName, final String albumName, final String photoName, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    App42Response album = PhotoService.this.removePhoto(userName, albumName, photoName);
                    callBack.onSuccess(album);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Album grantAccess(String albumName, String photoName, String userName, Hashtable aclList) throws App42Exception {
        String response = null;
        Album album = null;
        Util.throwExceptionIfNullOrBlank(albumName, "albumName");
        Util.throwExceptionIfNullOrBlank(photoName, "photoName");
        Util.throwExceptionIfNullOrBlank(userName, "userName");
        Util.throwExceptionIfNullOrBlank(aclList, "aclList");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            Enumeration enum_keys = signParams.keys();
            while (enum_keys.hasMoreElements()) {
                String key = (String)enum_keys.nextElement();
                queryParams.put(key, signParams.get(key));
            }
            signParams.put("albumName", albumName);
            signParams.put("photoName", photoName);
            signParams.put("userName", userName);
            JSONArray aclArray = new JSONArray();
            Enumeration aclListEnum = aclList.keys();
            while (aclListEnum.hasMoreElements()) {
                String key = aclListEnum.nextElement().toString();
                ACL acl = new ACL(key, aclList.get(key).toString());
                aclArray.put(acl.getJSONObject());
            }
            JSONObject obj = new JSONObject();
            obj.put("acls", "{\"acl\":" + aclArray + "}");
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"photo\":").append(obj.toString()).append("}}");
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + "grantAccess" + "/" + userName + "/" + albumName + "/" + photoName;
            response = RESTConnectorAsync.getInstance().executePut(resourceURL, queryParams, sb.toString(), headerParams);
            album = new AlbumResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return album;
    }

    public void grantAccess(final String albumName, final String photoName, final String userName, final Hashtable aclList, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Album album = PhotoService.this.grantAccess(albumName, photoName, userName, aclList);
                    callBack.onSuccess(album);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Album revokeAccess(String albumName, String photoName, String userName, Hashtable aclList) throws App42Exception {
        String response = null;
        Album album = null;
        Util.throwExceptionIfNullOrBlank(albumName, "albumName");
        Util.throwExceptionIfNullOrBlank(photoName, "photoName");
        Util.throwExceptionIfNullOrBlank(userName, "userName");
        Util.throwExceptionIfNullOrBlank(aclList, "aclList");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            Enumeration enum_keys = signParams.keys();
            while (enum_keys.hasMoreElements()) {
                String key = (String)enum_keys.nextElement();
                queryParams.put(key, signParams.get(key));
            }
            signParams.put("albumName", albumName);
            signParams.put("photoName", photoName);
            signParams.put("userName", userName);
            JSONArray aclArray = new JSONArray();
            Enumeration aclListEnum = aclList.keys();
            while (aclListEnum.hasMoreElements()) {
                String key = aclListEnum.nextElement().toString();
                ACL acl = new ACL(key, aclList.get(key).toString());
                aclArray.put(acl.getJSONObject());
            }
            JSONObject obj = new JSONObject();
            obj.put("acls", "{\"acl\":" + aclArray + "}");
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"photo\":").append(obj.toString()).append("}}");
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + "revokeAccess" + "/" + userName + "/" + albumName + "/" + photoName;
            response = RESTConnectorAsync.getInstance().executePut(resourceURL, queryParams, sb.toString(), headerParams);
            album = new AlbumResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return album;
    }

    public void revokeAccess(final String albumName, final String photoName, final String userName, final Hashtable aclList, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Album album = PhotoService.this.revokeAccess(albumName, photoName, userName, aclList);
                    callBack.onSuccess(album);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getAdminKey() {
        return this.adminKey;
    }

    public void setAdminKey(String adminKey) {
        this.adminKey = adminKey;
    }
}

