/*
 * Decompiled with CFR 0.152.
 */
package com.shephertz.app42.paas.sdk.jme.game;

import com.shephertz.app42.paas.sdk.jme.App42ResponseBuilder;
import com.shephertz.app42.paas.sdk.jme.game.Game;
import com.shephertz.app42.paas.sdk.jme.util.Util;
import java.util.Vector;
import org.json.jme.JSONArray;
import org.json.jme.JSONObject;

public class GameResponseBuilder
extends App42ResponseBuilder {
    public Game buildResponse(String json) throws Exception {
        JSONObject gamesJSONObj = this.getServiceJSONObject("games", json);
        JSONObject gameJSONObj = gamesJSONObj.getJSONObject("game");
        Game game = this.buildGameObject(gameJSONObj);
        game.setResponseSuccess(this.isResponseSuccess(json));
        game.setStrResponse(json);
        return game;
    }

    public Vector buildArrayResponse(String json) throws Exception {
        JSONObject gamesJSONObj = this.getServiceJSONObject("games", json);
        Vector<Game> gameList = new Vector<Game>();
        if (gamesJSONObj.get("game") instanceof JSONArray) {
            JSONArray gameJSONArray = gamesJSONObj.getJSONArray("game");
            for (int i = 0; i < gameJSONArray.length(); ++i) {
                JSONObject gameJSONObj = gameJSONArray.getJSONObject(i);
                Game game = this.buildGameObject(gameJSONObj);
                game.setStrResponse(json);
                game.setResponseSuccess(this.isResponseSuccess(json));
                gameList.addElement(game);
            }
        } else {
            JSONObject gameJSONObj = gamesJSONObj.getJSONObject("game");
            Game game = this.buildGameObject(gameJSONObj);
            game.setStrResponse(json);
            game.setResponseSuccess(this.isResponseSuccess(json));
            gameList.addElement(game);
        }
        return gameList;
    }

    private Game buildGameObject(JSONObject gameJSONObject) throws Exception {
        Game game = new Game();
        this.buildObjectFromJSONTree(game, gameJSONObject);
        if (gameJSONObject.has("scores") && gameJSONObject.getJSONObject("scores").has("score")) {
            if (gameJSONObject.getJSONObject("scores").get("score") instanceof JSONObject) {
                JSONObject scoreJSONObj = gameJSONObject.getJSONObject("scores").getJSONObject("score");
                Game.Score score = game.new Game.Score();
                this.buildObjectFromJSONTree(score, scoreJSONObj);
            } else {
                JSONArray scoreJSONArray = gameJSONObject.getJSONObject("scores").getJSONArray("score");
                for (int i = 0; i < scoreJSONArray.length(); ++i) {
                    JSONObject scoreJSONObj = scoreJSONArray.getJSONObject(i);
                    Game.Score score = game.new Game.Score();
                    this.buildObjectFromJSONTree(score, scoreJSONObj);
                }
            }
        }
        return game;
    }

    public void buildObjectFromJSONTree(Object obj, JSONObject jsonObj) throws Exception {
        String name;
        int i;
        String[] names;
        if (obj instanceof Game) {
            Game game = (Game)obj;
            names = this.getNames(jsonObj);
            if (names != null) {
                for (i = 0; i < names.length; ++i) {
                    name = names[i];
                    if (!name.equals("name")) continue;
                    game.setName("" + jsonObj.get(name));
                }
            }
        }
        if (obj instanceof Game.Score) {
            Game.Score score = (Game.Score)obj;
            names = this.getNames(jsonObj);
            if (names != null) {
                for (i = 0; i < names.length; ++i) {
                    String createdOn;
                    name = names[i];
                    if (name.equals("userName")) {
                        score.setUserName("" + jsonObj.get(name));
                    }
                    if (name.equals("rank")) {
                        score.setRank("" + jsonObj.get(name));
                    }
                    if (name.equals("value")) {
                        score.setValue(Double.valueOf("" + jsonObj.get(name)));
                    }
                    if (!name.equals("createdOn") || jsonObj.get(name) == null || (createdOn = "" + jsonObj.get(name)).equals("null")) continue;
                    score.setCreatedOn(Util.getDateFromUTCTimeStamp("" + jsonObj.get(name)));
                }
            }
        }
    }
}

