/*
 * Decompiled with CFR 0.152.
 */
package com.shephertz.app42.paas.sdk.jme.geo;

import com.shephertz.app42.paas.sdk.jme.App42ResponseBuilder;
import com.shephertz.app42.paas.sdk.jme.geo.Geo;
import com.shephertz.app42.paas.sdk.jme.util.Util;
import java.util.Vector;
import org.json.jme.JSONArray;
import org.json.jme.JSONObject;

public class GeoResponseBuilder
extends App42ResponseBuilder {
    public Geo buildResponse(String json) throws Exception {
        Geo geoObj = new Geo();
        Vector pointList = new Vector();
        geoObj.setPointList(pointList);
        geoObj.setStrResponse(json);
        JSONObject jsonObj = new JSONObject(json);
        JSONObject jsonObjApp42 = jsonObj.getJSONObject("app42");
        JSONObject jsonObjResponse = jsonObjApp42.getJSONObject("response");
        geoObj.setResponseSuccess(jsonObjResponse.getBoolean("success"));
        JSONObject jsonObjGeoStorage = jsonObjResponse.getJSONObject("geo").getJSONObject("storage");
        this.buildObjectFromJSONTree(geoObj, jsonObjGeoStorage);
        if (!jsonObjGeoStorage.has("points")) {
            return geoObj;
        }
        this.buildInternalObj(geoObj, jsonObjGeoStorage);
        return geoObj;
    }

    public Vector buildArrayResponse(String json) throws Exception {
        Vector<Geo> geoObjList = new Vector<Geo>();
        JSONObject jsonObj = new JSONObject(json);
        JSONObject jsonObjApp42 = jsonObj.getJSONObject("app42");
        JSONObject jsonObjResponse = jsonObjApp42.getJSONObject("response");
        JSONObject jsonObjGeoStorage = jsonObjResponse.getJSONObject("geo");
        if (jsonObjGeoStorage.get("storage") instanceof JSONObject) {
            jsonObjGeoStorage = jsonObjGeoStorage.getJSONObject("storage");
            Geo geoObj = new Geo();
            Vector pointList = new Vector();
            geoObj.setPointList(pointList);
            geoObj.setStrResponse(json);
            geoObj.setResponseSuccess(jsonObjResponse.getBoolean("success"));
            this.buildObjectFromJSONTree(geoObj, jsonObjGeoStorage);
            geoObjList.addElement(geoObj);
            if (jsonObjGeoStorage.has("points")) {
                this.buildInternalObj(geoObj, jsonObjGeoStorage);
            }
        } else {
            JSONArray jsonStorageArray = jsonObjGeoStorage.getJSONArray("storage");
            for (int i = 0; i < jsonStorageArray.length(); ++i) {
                JSONObject jsonObjStorage = jsonStorageArray.getJSONObject(i);
                Geo geoObj = new Geo();
                Vector pointList = new Vector();
                geoObj.setPointList(pointList);
                geoObj.setStrResponse(json);
                geoObj.setResponseSuccess(jsonObjResponse.getBoolean("success"));
                this.buildObjectFromJSONTree(geoObj, jsonObjStorage);
                geoObjList.addElement(geoObj);
                if (!jsonObjStorage.has("points")) continue;
                this.buildInternalObj(geoObj, jsonObjStorage);
            }
        }
        return geoObjList;
    }

    private Geo buildInternalObj(Geo geoObj, JSONObject jsonObjGeoStorage) throws Exception {
        JSONObject jsonGeoPoints = jsonObjGeoStorage.getJSONObject("points");
        if (!jsonGeoPoints.has("point")) {
            return geoObj;
        }
        if (jsonGeoPoints.get("point") instanceof JSONObject) {
            JSONObject jsonObjPoint = jsonGeoPoints.getJSONObject("point");
            Geo.Point pointsItem = geoObj.new Geo.Point();
            this.buildObjectFromJSONTree(pointsItem, jsonObjPoint);
        } else {
            JSONArray jsonObjPointsArray = jsonGeoPoints.getJSONArray("point");
            for (int i = 0; i < jsonObjPointsArray.length(); ++i) {
                JSONObject jsonObjPoint = jsonObjPointsArray.getJSONObject(i);
                Geo.Point pointsItem = geoObj.new Geo.Point();
                this.buildObjectFromJSONTree(pointsItem, jsonObjPoint);
            }
        }
        return geoObj;
    }

    public static void main(String[] args) throws Exception {
    }

    public void buildObjectFromJSONTree(Object obj, JSONObject jsonObj) throws Exception {
        String value;
        String name;
        int i;
        String[] names;
        if (obj instanceof Geo) {
            Geo geo = (Geo)obj;
            names = this.getNames(jsonObj);
            if (names != null) {
                for (i = 0; i < names.length; ++i) {
                    String createdOn;
                    name = names[i];
                    if (name.equals("storageName")) {
                        geo.setStorageName("" + jsonObj.get(name));
                    }
                    if (name.equals("sourceLat") && !(value = "" + jsonObj.get(name)).equals("null") && !value.equals("")) {
                        geo.setSourceLat(Double.valueOf(value));
                    }
                    if (name.equals("sourceLng") && !(value = "" + jsonObj.get(name)).equals("null") && !value.equals("")) {
                        geo.setSourceLng(Double.valueOf(value));
                    }
                    if (name.equals("distanceInKM") && !(value = "" + jsonObj.get(name)).equals("null") && !value.equals("")) {
                        geo.setDistanceInKM(Double.valueOf(value));
                    }
                    if (!name.equals("createdOn") || jsonObj.get(name) == null || (createdOn = "" + jsonObj.get(name)).equals("null")) continue;
                    geo.setCreatedOn(Util.getDateFromUTCTimeStamp("" + jsonObj.get(name)));
                }
            }
        }
        if (obj instanceof Geo.Point) {
            Geo.Point point = (Geo.Point)obj;
            names = this.getNames(jsonObj);
            if (names != null) {
                for (i = 0; i < names.length; ++i) {
                    name = names[i];
                    if (name.equals("lat") && !(value = "" + jsonObj.get(name)).equals("null") && !value.equals("")) {
                        point.setLat(Double.valueOf(value));
                    }
                    if (name.equals("lng") && !(value = "" + jsonObj.get(name)).equals("null") && !value.equals("")) {
                        point.setLng(Double.valueOf(value));
                    }
                    if (!name.equals("marker")) continue;
                    point.setMarker("" + jsonObj.get(name));
                }
            }
        }
    }
}

