/*
 * Decompiled with CFR 0.152.
 */
package com.shephertz.app42.paas.sdk.jme.storage;

import com.shephertz.app42.paas.sdk.jme.App42Exception;
import com.shephertz.app42.paas.sdk.jme.App42Log;
import com.shephertz.app42.paas.sdk.jme.storage.GeoQuery;
import com.shephertz.app42.paas.sdk.jme.storage.GeoTag;
import com.shephertz.app42.paas.sdk.jme.storage.Query;
import com.shephertz.app42.paas.sdk.jme.util.Util;
import java.util.Vector;
import org.json.jme.JSONArray;
import org.json.jme.JSONException;
import org.json.jme.JSONObject;

public class QueryBuilder {
    public static Query build(String key, Object value, String op) {
        Query query = null;
        Operator.throwExceptionIfNotValid(op);
        Util.throwExceptionIfNullOrBlank(key, "key");
        Util.throwExceptionIfNullOrBlank(value, "value");
        try {
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("key", key);
            jsonObj.put("value", value);
            jsonObj.put("operator", "" + op);
            query = new Query(jsonObj);
        }
        catch (Exception ex) {
            new App42Exception(ex);
        }
        return query;
    }

    public static GeoQuery buildGeoQuery(GeoTag geoTag, String geoOp, Double maxDistance) {
        GeoQuery query = null;
        try {
            JSONObject location = geoTag.getJSONObject();
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("lat", location.get("lat"));
            jsonObj.put("lng", location.get("lng"));
            jsonObj.put("operator", geoOp);
            jsonObj.put("maxDistance", maxDistance);
            query = new GeoQuery(jsonObj);
        }
        catch (Exception ex) {
            new App42Exception(ex);
        }
        return query;
    }

    public static Query compoundOperator(Query q1, String op, Query q2) {
        Operator.throwExceptionIfNotValid(op);
        Util.throwExceptionIfNullOrBlank(q1, "q1");
        Util.throwExceptionIfNullOrBlank(q2, "q2");
        JSONArray jsonArray = new JSONArray();
        Query query = new Query(jsonArray);
        try {
            if (q1.getType() instanceof JSONObject) {
                jsonArray.put((JSONObject)q1.getType());
            } else {
                jsonArray.put((JSONArray)q1.getType());
            }
            jsonArray.put(new JSONObject("{'compoundOpt':'" + op + "'}"));
            if (q2.getType() instanceof JSONObject) {
                jsonArray.put((JSONObject)q2.getType());
            } else {
                jsonArray.put((JSONArray)q2.getType());
            }
        }
        catch (JSONException ex) {
            throw new App42Exception(ex);
        }
        return query;
    }

    public static void main(String[] args) {
        Query q1 = QueryBuilder.build("x", new Integer(3), Operator.EQUALS);
        Query q2 = QueryBuilder.build("y", new Integer(3), Operator.EQUALS);
        Query q3 = QueryBuilder.compoundOperator(q1, Operator.AND, q2);
        Query q4 = QueryBuilder.build("z", new Integer(4), Operator.EQUALS);
        Query q5 = QueryBuilder.compoundOperator(q3, Operator.OR, q4);
        App42Log.debug(q5.getStr());
    }

    public static class GeoOperator {
        public static String NEAR = "$near";
        public static String WITHIN = "$within";
        private static Vector vallist = new Vector();

        public static void throwExceptionIfNotValid(String val) {
            if (!vallist.contains(val)) {
                throw new App42Exception("Operator " + val + " is not valid operator");
            }
        }

        static {
            vallist.addElement(NEAR);
            vallist.addElement(WITHIN);
        }
    }

    public static class Operator {
        public static String EQUALS = "$eq";
        public static String NOT_EQUALS = "$ne";
        public static String GREATER_THAN = "$gt";
        public static String LESS_THAN = "$lt";
        public static String GREATER_THAN_EQUALTO = "$gte";
        public static String LESS_THAN_EQUALTO = "$lte";
        public static String LIKE = "$lk";
        public static String AND = "$and";
        public static String OR = "$or";
        private static Vector vallist = new Vector();

        public static void throwExceptionIfNotValid(String val) {
            if (!vallist.contains(val)) {
                throw new App42Exception("Operator " + val + " is not valid operator");
            }
        }

        static {
            vallist.addElement(EQUALS);
            vallist.addElement(NOT_EQUALS);
            vallist.addElement(GREATER_THAN);
            vallist.addElement(LESS_THAN);
            vallist.addElement(GREATER_THAN_EQUALTO);
            vallist.addElement(LESS_THAN_EQUALTO);
            vallist.addElement(LIKE);
            vallist.addElement(AND);
            vallist.addElement(OR);
        }
    }
}

