/*
 * Decompiled with CFR 0.152.
 */
package component;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class customFont {
    private Image image;
    private Image newImage;
    private int[] widthMap;
    private int[] positionMap;
    private String characterMap;
    public int height;
    private int length;

    public customFont(int iFontSize) {
        if (this.initialize(iFontSize)) {
            this.height = this.image.getHeight() - 4;
            this.length = this.characterMap.length();
            System.out.println("length :- " + this.length);
            this.positionMap = new int[this.length];
            int xPos = 0;
            int width = 0;
            for (int i = 0; i < this.length; ++i) {
                width = this.widthMap[i];
                this.positionMap[i] = xPos;
                xPos = (short)(xPos + width);
            }
        } else {
            System.out.println("Could not initialize Custom Font");
        }
    }

    private boolean initialize(int iSize) {
        try {
            this.characterMap = "@\u00a9\u00ae?$&_+-'\"(),./\\:;!<>0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz%*|[]= ";
            switch (iSize) {
                case 0: {
                    this.image = Image.createImage((String)("/custom_font_" + iSize + ".png"));
                    this.widthMap = new int[]{11, 9, 9, 7, 8, 9, 7, 8, 3, 3, 10, 3, 3, 3, 3, 4, 8, 3, 3, 3, 7, 7, 8, 3, 7, 7, 8, 7, 8, 8, 8, 8, 8, 7, 8, 8, 7, 7, 8, 8, 2, 6, 7, 6, 8, 7, 9, 7, 9, 7, 7, 8, 8, 8, 10, 7, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 2, 6, 6, 6, 8, 6, 7, 7, 8, 7, 7, 8, 7, 7, 8, 6, 6, 6, 9, 4, 2, 4, 4, 9, 3};
                    break;
                }
                case 4: {
                    this.image = Image.createImage((String)"/custom_font_0.png");
                    this.image = customFont.changeColor(this.image, 0xFFFFFF, 16427776);
                    this.widthMap = new int[]{11, 9, 9, 7, 8, 9, 7, 8, 3, 3, 10, 3, 3, 3, 3, 4, 8, 3, 3, 3, 7, 7, 8, 3, 7, 7, 8, 7, 8, 8, 8, 8, 8, 7, 8, 8, 7, 7, 8, 8, 2, 6, 7, 6, 8, 7, 9, 7, 9, 7, 7, 8, 8, 8, 10, 7, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 2, 6, 6, 6, 8, 6, 7, 7, 8, 7, 7, 8, 7, 7, 8, 6, 6, 6, 9, 4, 2, 4, 4, 9, 3};
                    break;
                }
                case 1: {
                    this.image = Image.createImage((String)("/custom_font_" + iSize + ".png"));
                    this.widthMap = new int[]{16, 13, 13, 8, 10, 12, 10, 11, 5, 4, 15, 5, 5, 4, 4, 7, 12, 4, 4, 4, 10, 10, 11, 5, 10, 10, 11, 11, 10, 11, 10, 10, 11, 11, 11, 12, 10, 10, 11, 11, 3, 9, 9, 10, 13, 12, 12, 11, 12, 11, 11, 11, 11, 11, 15, 12, 11, 9, 10, 9, 8, 10, 7, 8, 10, 10, 3, 8, 8, 8, 10, 9, 11, 9, 11, 9, 9, 9, 9, 10, 12, 9, 9, 8, 13, 6, 3, 5, 5, 11, 3};
                    break;
                }
                case 5: {
                    this.image = Image.createImage((String)"/custom_font_1.png");
                    this.image = customFont.changeColor(this.image, 0xFFFFFF, 16427776);
                    this.widthMap = new int[]{16, 13, 13, 8, 10, 12, 10, 11, 5, 4, 15, 5, 5, 4, 4, 7, 12, 4, 4, 4, 10, 10, 11, 5, 10, 10, 11, 11, 10, 11, 10, 10, 11, 11, 11, 12, 10, 10, 11, 11, 3, 9, 9, 10, 13, 12, 12, 11, 12, 11, 11, 11, 11, 11, 15, 12, 11, 9, 10, 9, 8, 10, 7, 8, 10, 10, 3, 8, 8, 8, 10, 9, 11, 9, 11, 9, 9, 9, 9, 10, 12, 9, 9, 8, 13, 6, 3, 5, 5, 11, 3};
                    break;
                }
                case 2: {
                    this.image = Image.createImage((String)("/custom_font_" + iSize + ".png"));
                    this.widthMap = new int[]{17, 14, 14, 9, 11, 13, 11, 12, 6, 5, 17, 6, 6, 5, 5, 8, 14, 5, 5, 5, 11, 11, 12, 6, 11, 11, 12, 12, 11, 12, 11, 11, 12, 12, 12, 13, 11, 11, 12, 12, 4, 10, 10, 11, 14, 13, 14, 12, 13, 12, 12, 12, 12, 12, 16, 13, 12, 10, 11, 10, 9, 11, 8, 9, 11, 11, 4, 9, 9, 9, 11, 10, 12, 10, 12, 10, 10, 10, 10, 11, 13, 10, 10, 9, 14, 7, 4, 6, 6, 12, 4};
                    break;
                }
                case 3: {
                    this.image = Image.createImage((String)"/custom_font_2.png");
                    this.image = customFont.changeColor(this.image, 0xFFFFFF, 16427776);
                    this.widthMap = new int[]{17, 14, 14, 9, 11, 13, 11, 12, 6, 5, 17, 6, 6, 5, 5, 8, 14, 5, 5, 5, 11, 11, 12, 6, 11, 11, 12, 12, 11, 12, 11, 11, 12, 12, 12, 13, 11, 11, 12, 12, 4, 10, 10, 11, 14, 13, 14, 12, 13, 12, 12, 12, 12, 12, 16, 13, 12, 10, 11, 10, 9, 11, 8, 9, 11, 11, 4, 9, 9, 9, 11, 10, 12, 10, 12, 10, 10, 10, 10, 11, 13, 10, 10, 9, 14, 7, 4, 6, 6, 12, 4};
                }
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void drawString(String str, int x, int y, Graphics graphics, int iAnchor) {
        int i;
        x = this.parseAnchorPosX(x, str, iAnchor);
        y = this.parseAnchorPosY(y, iAnchor);
        int[] indeces = null;
        this.length = str.length();
        indeces = new int[this.length];
        for (i = this.length - 1; i >= 0; --i) {
            char inputCharacter = str.charAt(i);
            indeces[i] = this.indexOf(inputCharacter);
        }
        int[] previousPositionsMap = new int[indeces.length];
        int[] previousWidthMap = new int[indeces.length];
        for (i = 0; i < indeces.length; ++i) {
            int index = indeces[i];
            if (index == -1) continue;
            previousPositionsMap[i] = this.positionMap[index];
            previousWidthMap[i] = this.widthMap[index];
        }
        int clipX = graphics.getClipX();
        int clipY = graphics.getClipY();
        int clipWidth = graphics.getClipWidth();
        int clipHeight = graphics.getClipHeight();
        for (int i2 = 0; i2 < previousWidthMap.length; ++i2) {
            int characterWidth = previousWidthMap[i2];
            graphics.clipRect(x, y, characterWidth, this.height);
            int imageX = x - previousPositionsMap[i2];
            int imageY = y;
            graphics.drawImage(this.image, imageX, imageY, 20);
            x += characterWidth;
            graphics.setClip(clipX, clipY, clipWidth, clipHeight);
        }
    }

    public int stringWidth(String str) {
        this.length = str.length();
        int width = 0;
        for (int i = this.length - 1; i >= 0; --i) {
            char inputCharacter = str.charAt(i);
            int charactorMapIndex = this.characterMap.indexOf(inputCharacter);
            if (charactorMapIndex == -1) {
                charactorMapIndex = this.characterMap.indexOf("?");
            }
            width += this.widthMap[charactorMapIndex];
        }
        return width;
    }

    public int getHeight() {
        return this.height;
    }

    private int indexOf(char inputCharacter) {
        return this.characterMap.indexOf(inputCharacter);
    }

    private int parseAnchorPosX(int x, String strText, int anchor) {
        int val = x;
        if ((anchor & 8) == 8) {
            val -= this.stringWidth(strText);
        } else if ((anchor & 4) == 4) {
            val += 0;
        } else if ((anchor & 1) == 1) {
            val -= this.stringWidth(strText) >> 1;
        }
        return val;
    }

    private int parseAnchorPosY(int y, int anchor) {
        int val = y;
        if ((anchor & 0x20) == 32) {
            val -= this.getHeight();
        } else if ((anchor & 0x10) == 16) {
            val += 0;
        } else if ((anchor & 2) == 2) {
            val -= this.getHeight() >> 1;
        }
        return val;
    }

    public static Image changeColor(Image source, int fromColor, int toColor) {
        int imageWidth = source.getWidth();
        int imageHeight = source.getHeight();
        int[] rgb = new int[imageWidth * imageHeight];
        int deviceColor = customFont.getDeviceColor(fromColor);
        source.getRGB(rgb, 0, imageWidth, 0, 0, imageWidth, imageHeight);
        for (int i = 0; i < rgb.length; ++i) {
            if (rgb[i] != deviceColor) continue;
            rgb[i] = toColor | 0xFF000000;
        }
        return Image.createRGBImage((int[])rgb, (int)imageWidth, (int)imageHeight, (boolean)true);
    }

    static int getDeviceColor(int color) {
        Image fake = Image.createRGBImage((int[])new int[]{color}, (int)1, (int)1, (boolean)false);
        int[] rgb = new int[1];
        fake.getRGB(rgb, 0, 1, 0, 0, 1, 1);
        return rgb[0];
    }
}

