/*
 * Decompiled with CFR 0.152.
 */
package ingame;

import component.CUtility;
import component.customFont;
import component.gameData;
import game.CCanvas;
import game.CMainGameManager;
import ingame.CIngameManager;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CPauseMenu {
    private String[] strPauseMenu = new String[3];
    private int iSelIndex;
    private boolean isAlertMsgActive;
    private int[][] iArrMenuRegion;
    private boolean isRegionSet;
    private customFont objNormalFont;
    private customFont objSelectFont;
    private Image imgBtnBack;
    private Image imgBtnYes;
    private Image imgBtnNo;

    public CPauseMenu() {
        this.strPauseMenu[0] = "RESUME";
        this.strPauseMenu[2] = "MAIN MENU";
        this.strPauseMenu[1] = gameData.getData(4) == 1 ? "SOUND OFF" : "SOUND ON";
        this.iSelIndex = 0;
        this.isAlertMsgActive = false;
        this.iArrMenuRegion = new int[3][4];
        this.isRegionSet = false;
        this.objNormalFont = new customFont(2);
        this.objSelectFont = new customFont(3);
        try {
            this.imgBtnBack = Image.createImage((String)"/next.png");
            this.imgBtnBack = Image.createImage((Image)this.imgBtnBack, (int)0, (int)0, (int)this.imgBtnBack.getWidth(), (int)this.imgBtnBack.getHeight(), (int)2);
            this.imgBtnYes = Image.createImage((String)"/yes.png");
            this.imgBtnNo = Image.createImage((String)"/no.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void unload() {
        this.strPauseMenu = null;
        this.isRegionSet = false;
        this.objNormalFont = null;
        this.objSelectFont = null;
        this.imgBtnBack = null;
        this.imgBtnNo = null;
        this.imgBtnYes = null;
    }

    public void paint(Graphics g) {
        int i;
        CUtility.drawBorder(g, CCanvas.iScreenW >> 5, CCanvas.iScreenH >> 3, CCanvas.iScreenW - (CCanvas.iScreenW >> 4), CCanvas.iScreenH - (CCanvas.iScreenH >> 2));
        int iTextHeight = CIngameManager.getInstance().objBigFont.getHeight();
        int iTotalHeight = iTextHeight * 6;
        int iStartY = (CCanvas.iScreenH >> 1) - (iTotalHeight >> 1);
        if (!this.isRegionSet) {
            for (i = 0; i < 3; ++i) {
                int w = CIngameManager.getInstance().objBigFont.stringWidth(this.strPauseMenu[i]);
                this.iArrMenuRegion[i][0] = (CCanvas.iScreenW >> 1) - (w >> 1) - 6;
                this.iArrMenuRegion[i][1] = iStartY + (iTextHeight << 1) * i - 3;
                this.iArrMenuRegion[i][2] = w + 12;
                this.iArrMenuRegion[i][3] = iTextHeight + 6;
            }
            this.isRegionSet = true;
        }
        for (i = 0; i < 3; ++i) {
            if (i == this.iSelIndex) {
                this.objSelectFont.drawString(this.strPauseMenu[i], CCanvas.iScreenW >> 1, iStartY + (iTextHeight << 1) * i, g, 17);
                continue;
            }
            this.objNormalFont.drawString(this.strPauseMenu[i], CCanvas.iScreenW >> 1, iStartY + (iTextHeight << 1) * i, g, 17);
        }
        if (this.isAlertMsgActive) {
            g.setColor(0x2A2A2A);
            g.fillRoundRect(CCanvas.iScreenW >> 5, CCanvas.iScreenH - CCanvas.iScreenH / 3, CCanvas.iScreenW - (CCanvas.iScreenW >> 4), CCanvas.iScreenH >> 2, 25, 25);
            g.setColor(0xFFFFFF);
            g.drawRoundRect(CCanvas.iScreenW >> 5, CCanvas.iScreenH - CCanvas.iScreenH / 3, CCanvas.iScreenW - (CCanvas.iScreenW >> 4), CCanvas.iScreenH >> 2, 25, 25);
            CIngameManager.getInstance().objBigFont.drawString("Exit Game?", CCanvas.iScreenW >> 1, CCanvas.iScreenH - CCanvas.iScreenH / 3 + (CCanvas.iScreenH >> 3) - iTextHeight, g, 3);
            CIngameManager.getInstance().objSmallFont.drawString("Your progress will be lost!", CCanvas.iScreenW >> 1, CCanvas.iScreenH - CCanvas.iScreenH / 3 + (CCanvas.iScreenH >> 3), g, 3);
            CUtility.paintSoftKeys(g, this.imgBtnYes, this.imgBtnNo);
        } else {
            CUtility.paintSoftKeys(g, null, this.imgBtnBack);
        }
    }

    public boolean handleInput(int key, boolean isPressed) {
        if (!isPressed) {
            if (!this.isAlertMsgActive) {
                if (key == 212) {
                    return false;
                }
                if (key == 202) {
                    this.iSelIndex = (this.iSelIndex + 2) % 3;
                } else if (key == 208) {
                    ++this.iSelIndex;
                    this.iSelIndex %= 3;
                } else if (key == 205) {
                    if (this.iSelIndex == 0) {
                        return false;
                    }
                    if (this.iSelIndex == 1) {
                        this.toggleSound();
                    } else if (this.iSelIndex == 2) {
                        this.isAlertMsgActive = true;
                    }
                }
            } else if (key == 211) {
                CMainGameManager.getInstance().switchToStates(1);
            } else if (key == 212) {
                this.isAlertMsgActive = false;
            }
        }
        return true;
    }

    public boolean handleTouchInput(int pointerX, int pointerY, int iTouchState) {
        if (iTouchState == 2) {
            if (!this.isAlertMsgActive) {
                if (CUtility.isRSKPressed(pointerX, pointerY)) {
                    return false;
                }
                if (this.iSelIndex == 0 && CUtility.isPointInRect(pointerX, pointerY, this.iArrMenuRegion[0][0], this.iArrMenuRegion[0][1], this.iArrMenuRegion[0][2], this.iArrMenuRegion[0][3])) {
                    return false;
                }
                if (this.iSelIndex == 1 && CUtility.isPointInRect(pointerX, pointerY, this.iArrMenuRegion[1][0], this.iArrMenuRegion[1][1], this.iArrMenuRegion[1][2], this.iArrMenuRegion[1][3])) {
                    this.toggleSound();
                } else if (this.iSelIndex == 2 && CUtility.isPointInRect(pointerX, pointerY, this.iArrMenuRegion[2][0], this.iArrMenuRegion[2][1], this.iArrMenuRegion[2][2], this.iArrMenuRegion[2][3])) {
                    this.isAlertMsgActive = true;
                }
            } else if (CUtility.isLSKPressed(pointerX, pointerY)) {
                CMainGameManager.getInstance().switchToStates(1);
            } else if (CUtility.isRSKPressed(pointerX, pointerY)) {
                this.isAlertMsgActive = false;
            }
        } else if (iTouchState == 0 && !this.isAlertMsgActive) {
            if (CUtility.isPointInRect(pointerX, pointerY, this.iArrMenuRegion[0][0], this.iArrMenuRegion[0][1], this.iArrMenuRegion[0][2], this.iArrMenuRegion[0][3])) {
                this.iSelIndex = 0;
            } else if (CUtility.isPointInRect(pointerX, pointerY, this.iArrMenuRegion[1][0], this.iArrMenuRegion[1][1], this.iArrMenuRegion[1][2], this.iArrMenuRegion[1][3])) {
                this.iSelIndex = 1;
            } else if (CUtility.isPointInRect(pointerX, pointerY, this.iArrMenuRegion[2][0], this.iArrMenuRegion[2][1], this.iArrMenuRegion[2][2], this.iArrMenuRegion[2][3])) {
                this.iSelIndex = 2;
            }
        }
        return true;
    }

    private void toggleSound() {
        int state = gameData.getData(4);
        state = 1 - state;
        gameData.saveData(4, state);
        this.strPauseMenu[1] = state == 1 ? "SOUND OFF" : "SOUND ON";
    }
}

