/*
 * Decompiled with CFR 0.152.
 */
package mainmenu;

import com.shephertz.app42.paas.sdk.jme.ServiceAPI;
import com.shephertz.app42.paas.sdk.jme.game.Game;
import com.shephertz.app42.paas.sdk.jme.game.ScoreBoardService;
import component.CUtility;
import component.customFont;
import game.CCanvas;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import mainmenu.COptionManager;

public class CLeaderboard {
    private Image imageD3Header;
    private Image imageOptionMenuHeaderBar;
    private Image imageOptionMenuHeader;
    private Image imageUPArrow;
    private Image imageDownArrow;
    private Image imageBack;
    private int iHeaderD3X;
    private int iHeaderD3Y;
    private int iOptionMenuHeaderX;
    private int iOptionMenuHeaderY;
    private int iUpArrowX;
    private int iUpArrowY;
    private int iDownArrowX;
    private int iDownArrowY;
    private int iArrowMoveFacUp;
    private int iArrowMoveFacDown;
    private int iOutSideBorderX;
    private int iOutSideBorderY;
    private int iOutSideBorderWidth;
    private int iOutSideBorderHeight;
    private int iInSideBorderX;
    private int iInSideBorderY;
    private int iInSideBorderWidth;
    private int iInSideBorderHeight;
    private int iMoveSpeed;
    private int iMoveFactor;
    private int iAdjustFactor;
    private int iLeaderboardX;
    private int iLargeFontHeight;
    private int iSmallFontHeight;
    private boolean isUpPressed = false;
    private boolean isDownPressed = false;
    private customFont objSmallFont;
    private customFont objLargeFont;
    private int iTotalTopScores = 10;
    private String[] strArrTopName = new String[this.iTotalTopScores];
    private String[] iArrTopScore = new String[this.iTotalTopScores];
    private boolean isScoreLoaded;
    private boolean isOnce = true;
    private String strStatus = "connecting";
    private String[] strDots = new String[]{" ", " .", " ..", " ...", " ...."};
    private int iDotIndex = 0;
    private ScoreBoardService scoreBoardService = null;

    public CLeaderboard() {
        this.objSmallFont = new customFont(0);
        this.objLargeFont = new customFont(1);
        this.loadImages();
        this.initialize();
    }

    private void loadImages() {
        try {
            this.imageD3Header = Image.createImage((String)"/header_3.png");
            this.imageOptionMenuHeaderBar = Image.createImage((String)"/header_bar.png");
            this.imageOptionMenuHeader = Image.createImage((String)"/header_highscores.png");
            this.imageUPArrow = Image.createImage((String)"/arrow.png");
            this.imageBack = Image.createImage((String)"/next.png");
            this.imageBack = Image.createImage((Image)this.imageBack, (int)0, (int)0, (int)this.imageBack.getWidth(), (int)this.imageBack.getHeight(), (int)2);
            this.imageDownArrow = Image.createImage((Image)this.imageUPArrow, (int)0, (int)0, (int)this.imageUPArrow.getWidth(), (int)this.imageUPArrow.getHeight(), (int)3);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void initialize() {
        this.iLargeFontHeight = this.objLargeFont.getHeight();
        this.iSmallFontHeight = this.objSmallFont.getHeight();
        this.iAdjustFactor = this.imageOptionMenuHeaderBar.getWidth() * 6 / 100;
        int iTotalHeaderWidth = this.imageD3Header.getWidth() + this.imageOptionMenuHeaderBar.getWidth();
        this.iHeaderD3X = (CCanvas.iScreenW >> 1) - (iTotalHeaderWidth >> 1);
        this.iHeaderD3Y = this.iAdjustFactor >> 1;
        this.iOptionMenuHeaderX = this.iHeaderD3X + this.imageD3Header.getWidth();
        this.iOptionMenuHeaderY = this.iHeaderD3Y + (this.imageD3Header.getHeight() >> 1) - 3;
        this.iOutSideBorderX = CCanvas.iScreenW * 4 / 100;
        this.iOutSideBorderY = this.iOptionMenuHeaderY;
        this.iOutSideBorderWidth = CCanvas.iScreenW - 2 * this.iOutSideBorderX;
        this.iOutSideBorderHeight = CCanvas.iScreenH - (this.iOutSideBorderY + 37);
        this.iUpArrowX = CCanvas.iScreenW >> 1;
        this.iUpArrowY = this.iHeaderD3Y + this.imageD3Header.getHeight();
        this.iDownArrowX = this.iUpArrowX;
        this.iDownArrowY = this.iOutSideBorderY + this.iOutSideBorderHeight - 2 * this.imageDownArrow.getHeight();
        this.iArrowMoveFacUp = 0;
        this.iArrowMoveFacDown = 0;
        this.iInSideBorderX = CCanvas.iScreenW * 12 / 100;
        this.iInSideBorderY = this.iUpArrowY + (3 * this.imageUPArrow.getHeight() >> 1);
        this.iInSideBorderWidth = CCanvas.iScreenW - 2 * this.iInSideBorderX;
        this.iInSideBorderHeight = this.iDownArrowY - ((this.imageDownArrow.getHeight() >> 1) + this.iInSideBorderY);
        this.iMoveSpeed = 10;
        this.iMoveFactor = 0;
        this.iLeaderboardX = CCanvas.iScreenW >> 1;
        this.isScoreLoaded = false;
    }

    public void paint(Graphics g) {
        CUtility.drawBorder(g, this.iOutSideBorderX, this.iOutSideBorderY, this.iOutSideBorderWidth, this.iOutSideBorderHeight);
        CUtility.paintSoftKeys(g, null, this.imageBack);
        g.drawImage(this.imageOptionMenuHeaderBar, this.iOptionMenuHeaderX, this.iOptionMenuHeaderY, 6);
        g.drawImage(this.imageOptionMenuHeader, this.iOptionMenuHeaderX + (this.imageOptionMenuHeaderBar.getWidth() >> 1) - this.iAdjustFactor, this.iOptionMenuHeaderY, 3);
        g.drawImage(this.imageD3Header, this.iHeaderD3X, this.iHeaderD3Y, 0);
        if (this.isScoreLoaded) {
            if (this.iMoveFactor + this.iInSideBorderY < this.iInSideBorderY) {
                g.drawImage(this.imageUPArrow, this.iUpArrowX, this.iUpArrowY + this.iArrowMoveFacUp - this.iSmallFontHeight, 17);
            }
            if (this.iMoveFactor + (this.iInSideBorderY + this.iSmallFontHeight * (this.iTotalTopScores * 2)) > this.iInSideBorderY + this.iInSideBorderHeight) {
                g.drawImage(this.imageDownArrow, this.iDownArrowX, this.iDownArrowY + this.iArrowMoveFacDown, 17);
            }
        }
        this.objSmallFont.drawString("RANK", this.iOutSideBorderX + this.iLargeFontHeight, this.iInSideBorderY, g, 6);
        this.objSmallFont.drawString("NAME", (CCanvas.iScreenW >> 1) - this.objSmallFont.stringWidth("NAME"), this.iInSideBorderY, g, 6);
        this.objSmallFont.drawString("SCORE", this.iOutSideBorderX + this.iOutSideBorderWidth - 2 * this.iLargeFontHeight, this.iInSideBorderY, g, 10);
        g.setClip(this.iOutSideBorderX, this.iInSideBorderY + this.iLargeFontHeight, this.iOutSideBorderWidth, this.iInSideBorderHeight - this.iLargeFontHeight);
        if (this.isScoreLoaded) {
            for (int i = 0; i < this.iTotalTopScores; ++i) {
                this.objSmallFont.drawString("" + (i + 1), this.iOutSideBorderX + this.iSmallFontHeight * 2, this.iMoveFactor + (this.iInSideBorderY + 2 * this.iSmallFontHeight * (i + 1)), g, 6);
                this.objSmallFont.drawString(this.strArrTopName[i], (CCanvas.iScreenW >> 1) - this.objSmallFont.stringWidth("NAME") * 2, this.iMoveFactor + (this.iInSideBorderY + 2 * this.iSmallFontHeight * (i + 1)), g, 6);
                this.objSmallFont.drawString(this.iArrTopScore[i], this.iOutSideBorderX + this.iOutSideBorderWidth - (this.iLargeFontHeight + this.objSmallFont.stringWidth("999999")), this.iMoveFactor + (this.iInSideBorderY + 2 * this.iSmallFontHeight * (i + 1)), g, 6);
            }
        } else if (this.strStatus.equalsIgnoreCase("Connection Error")) {
            this.objSmallFont.drawString(this.strStatus, CCanvas.iScreenW >> 1, CCanvas.iScreenH >> 1, g, 3);
        } else {
            this.iDotIndex = this.iDotIndex == this.strDots.length - 1 ? 0 : ++this.iDotIndex;
            this.objSmallFont.drawString(this.strStatus + this.strDots[this.iDotIndex], (CCanvas.iScreenW >> 1) - (this.objSmallFont.stringWidth(this.strStatus) >> 1), CCanvas.iScreenH >> 1, g, 6);
        }
        g.setClip(0, 0, CCanvas.iScreenW, CCanvas.iScreenH);
    }

    private void leaderBoardConnect() {
        ServiceAPI sp = new ServiceAPI("5c644cc503e672487d17480cc119ec70538e805e7ad3677f8db0fd11063511ca", "a092f4bcb960437f8dfa9cf412108ab32512c7a68b6bc8367a059a101ed890ec");
        this.scoreBoardService = sp.buildScoreBoardService();
        Game gameScore = this.scoreBoardService.getTopNRankers("Dhoom:3 The Game", new Integer(this.iTotalTopScores));
        Vector leaderboardlist = gameScore.getScoreList();
        for (int i = 0; i < this.iTotalTopScores; ++i) {
            System.out.println("leaderboard :- " + leaderboardlist);
            Game.Score score = (Game.Score)leaderboardlist.elementAt(i);
            this.strArrTopName[i] = score.getUserName();
            this.iArrTopScore[i] = score.getValue().toString();
            int iIndexDot = this.iArrTopScore[i].indexOf(46);
            if (iIndexDot == -1) continue;
            this.iArrTopScore[i] = this.iArrTopScore[i].substring(0, iIndexDot);
        }
        this.isScoreLoaded = true;
    }

    public void update() {
        if (this.isOnce) {
            this.isOnce = false;
            try {
                this.leaderBoardConnect();
            }
            catch (Exception e) {
                this.isScoreLoaded = false;
                System.out.println("error is " + e);
                this.strStatus = "Connection Error";
            }
        }
    }

    public void handleInput(int key, boolean isPressed) {
        if (isPressed) {
            switch (key) {
                case 202: {
                    if (this.iMoveFactor + this.iInSideBorderY >= this.iInSideBorderY) break;
                    this.iArrowMoveFacUp -= 5;
                    this.isUpPressed = true;
                    this.iMoveFactor += this.iMoveSpeed;
                    break;
                }
                case 208: {
                    if (this.iMoveFactor + (this.iInSideBorderY + this.iSmallFontHeight * (this.iTotalTopScores * 2)) <= this.iInSideBorderY + this.iInSideBorderHeight) break;
                    this.iArrowMoveFacDown += 5;
                    this.isDownPressed = true;
                    this.iMoveFactor -= this.iMoveSpeed;
                    break;
                }
                case 212: {
                    COptionManager.getInstance().switchToStates(15);
                }
            }
        } else {
            if (this.isUpPressed) {
                this.iArrowMoveFacUp += 5;
                this.isUpPressed = false;
            }
            if (this.isDownPressed) {
                this.iArrowMoveFacDown -= 5;
                this.isDownPressed = false;
            }
        }
    }

    public void handleTouchInput(int pointerX, int pointerY, int iTouchState) {
        if (iTouchState == 0 && !CUtility.isRSKPressed(pointerX, pointerY)) {
            if (CUtility.isPointInRect(pointerX, pointerY, this.iInSideBorderX, 0, this.iInSideBorderWidth, this.iUpArrowY + this.imageUPArrow.getHeight())) {
                if (this.iMoveFactor + this.iInSideBorderY < this.iInSideBorderY) {
                    this.iArrowMoveFacUp -= 5;
                    this.isUpPressed = true;
                }
            } else if (CUtility.isPointInRect(pointerX, pointerY, this.iInSideBorderX, this.iDownArrowY, this.iInSideBorderWidth, CCanvas.iScreenH - (this.iDownArrowY + this.imageDownArrow.getHeight())) && this.iMoveFactor + (this.iInSideBorderY + this.iSmallFontHeight * (this.iTotalTopScores * 2)) > this.iInSideBorderY + this.iInSideBorderHeight) {
                this.iArrowMoveFacDown += 5;
                this.isDownPressed = true;
            }
        }
        if (iTouchState == 2) {
            if (CUtility.isRSKPressed(pointerX, pointerY)) {
                COptionManager.getInstance().switchToStates(15);
            } else if (CUtility.isPointInRect(pointerX, pointerY, this.iInSideBorderX, 0, this.iInSideBorderWidth, this.iUpArrowY + this.imageUPArrow.getHeight())) {
                if (this.isUpPressed) {
                    this.iMoveFactor += this.iMoveSpeed;
                    this.iArrowMoveFacUp += 5;
                    this.isUpPressed = false;
                }
            } else if (CUtility.isPointInRect(pointerX, pointerY, this.iInSideBorderX, this.iDownArrowY, this.iInSideBorderWidth, CCanvas.iScreenH - (this.iDownArrowY + this.imageDownArrow.getHeight())) && this.isDownPressed) {
                this.iMoveFactor -= this.iMoveSpeed;
                this.iArrowMoveFacDown -= 5;
                this.isDownPressed = false;
            }
        }
    }

    public void unLoadImages() {
        this.imageD3Header = null;
        this.imageOptionMenuHeaderBar = null;
        this.imageOptionMenuHeader = null;
        this.imageUPArrow = null;
        this.imageDownArrow = null;
        this.objSmallFont = null;
        this.objLargeFont = null;
        this.imageBack = null;
    }
}

