/*
 * Decompiled with CFR 0.152.
 */
package mainmenu;

import component.CSoundPlayer;
import component.CUtility;
import component.customFont;
import component.gameData;
import constants.CPortingValues;
import game.CCanvas;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import mainmenu.COptionManager;

public class COptionMenu {
    private int iSoundState;
    static int iOptionMenuIdx;
    private Image imageOptionMenuBG;
    private Image imageOptionMenuLogo;
    private Image imageOptionMenuButton;
    private Image imageBack;
    static final String[] strOptionMenu;
    static final String[] strSound;
    private int iOptionMenuLogoX;
    private int iOptionMenuLogoY;
    private int iOptionMenuBGX;
    private int iOptionMenuBGY;
    private int iOptionMenuButtonStartX;
    private int iOptionMenuButtonStartY;
    private int iOptionMenuButtonGap;
    private int[] iOptionMenuButtonY;
    private customFont objMenuFont;
    private customFont objMenuRollFont;
    private CSoundPlayer objMenuSound;

    public COptionMenu() {
        iOptionMenuIdx = 0;
        this.objMenuFont = new customFont(2);
        this.objMenuRollFont = new customFont(3);
        this.iSoundState = gameData.getData(4);
        this.objMenuSound = new CSoundPlayer();
        this.loadImages();
        this.prepareOptionMenuAnimation();
        if (this.iSoundState == 0) {
            this.objMenuSound.playSound(0, true);
        }
    }

    private void prepareOptionMenuAnimation() {
        this.iOptionMenuLogoX = (CCanvas.iScreenW - this.imageOptionMenuLogo.getWidth()) / 2;
        this.iOptionMenuLogoY = 0;
        this.iOptionMenuBGX = (CCanvas.iScreenW - this.imageOptionMenuBG.getWidth()) / 2;
        this.iOptionMenuBGY = CCanvas.iScreenH;
        this.iOptionMenuButtonStartX = CCanvas.iScreenW >> 1;
        this.iOptionMenuButtonStartY = this.imageOptionMenuLogo.getHeight() + this.imageOptionMenuButton.getHeight();
        this.iOptionMenuButtonGap = Math.abs(CCanvas.iScreenH - this.imageOptionMenuLogo.getHeight() - this.imageOptionMenuButton.getHeight() * CPortingValues.iMaxLabelsOnMenu) >> 3;
        this.iOptionMenuButtonStartY = this.imageOptionMenuLogo.getHeight() + this.iOptionMenuButtonGap;
        if (this.iOptionMenuButtonGap > this.imageOptionMenuButton.getHeight()) {
            this.iOptionMenuButtonGap = this.imageOptionMenuButton.getHeight() / 2;
            this.iOptionMenuButtonStartY = this.imageOptionMenuLogo.getHeight() + this.imageOptionMenuButton.getHeight() + this.iOptionMenuButtonGap + 5;
        }
        this.iOptionMenuButtonY = new int[CPortingValues.iMaxLabelsOnMenu];
        for (int i = 0; i < CPortingValues.iMaxLabelsOnMenu; ++i) {
            this.iOptionMenuButtonY[i] = this.iOptionMenuButtonStartY + (this.imageOptionMenuButton.getHeight() + this.iOptionMenuButtonGap) * i;
        }
    }

    private void loadImages() {
        try {
            this.imageOptionMenuBG = Image.createImage((String)"/menu_bg.png");
            this.imageOptionMenuLogo = Image.createImage((String)"/game_logo.png");
            this.imageOptionMenuButton = Image.createImage((String)"/menu_button.png");
            this.imageBack = Image.createImage((String)"/next.png");
            this.imageBack = Image.createImage((Image)this.imageBack, (int)0, (int)0, (int)this.imageBack.getWidth(), (int)this.imageBack.getHeight(), (int)2);
            this.objMenuSound.loadSound(strSound);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void paint(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, CCanvas.iScreenW, CCanvas.iScreenH);
        g.drawImage(this.imageOptionMenuBG, this.iOptionMenuBGX, this.iOptionMenuBGY, 36);
        g.drawImage(this.imageOptionMenuLogo, this.iOptionMenuLogoX, this.iOptionMenuLogoY, 20);
        COptionMenu.strOptionMenu[0] = this.iSoundState == 0 ? "SOUND ON" : "SOUND OFF";
        for (int i = 0; i < CPortingValues.iMaxLabelsOnMenu; ++i) {
            if (i == iOptionMenuIdx) {
                g.drawImage(this.imageOptionMenuButton, this.iOptionMenuButtonStartX, this.iOptionMenuButtonY[i], 17);
                this.objMenuRollFont.drawString(strOptionMenu[i], (this.iOptionMenuButtonStartX >> 1) + (this.imageOptionMenuButton.getWidth() >> 3), this.iOptionMenuButtonY[i] + (this.imageOptionMenuButton.getHeight() >> 1) - 3, g, 6);
                continue;
            }
            g.drawImage(this.imageOptionMenuButton, this.iOptionMenuButtonStartX, this.iOptionMenuButtonY[i], 17);
            this.objMenuFont.drawString(strOptionMenu[i], (this.iOptionMenuButtonStartX >> 1) + (this.imageOptionMenuButton.getWidth() >> 3), this.iOptionMenuButtonY[i] + (this.imageOptionMenuButton.getHeight() >> 1) - 3, g, 6);
        }
        CUtility.paintSoftKeys(g, null, this.imageBack);
    }

    public void update() {
    }

    public void handleInput(int key, boolean isPressed) {
        if (isPressed) {
            switch (key) {
                case 202: {
                    iOptionMenuIdx = (iOptionMenuIdx + (strOptionMenu.length - 1)) % strOptionMenu.length;
                    break;
                }
                case 208: {
                    ++iOptionMenuIdx;
                    iOptionMenuIdx %= strOptionMenu.length;
                    break;
                }
                case 205: {
                    if (iOptionMenuIdx + 11 == 11) {
                        if (this.iSoundState == 0) {
                            this.iSoundState = 1;
                            this.objMenuSound.stopSound(0);
                            gameData.saveData(4, this.iSoundState);
                            break;
                        }
                        this.iSoundState = 0;
                        this.objMenuSound.playSound(0, true);
                        gameData.saveData(4, this.iSoundState);
                        break;
                    }
                    gameData.saveData(4, this.iSoundState);
                    if (this.iSoundState == 0) {
                        this.objMenuSound.stopSound(0);
                    }
                    COptionManager.getInstance().switchToStates(iOptionMenuIdx + 11);
                    break;
                }
                case 212: {
                    if (this.iSoundState == 0) {
                        this.objMenuSound.stopSound(0);
                    }
                    COptionManager.getInstance().switchToStates(1);
                }
            }
        }
    }

    public void handleTouchInput(int pointerX, int pointerY, int iTouchState) {
        int i;
        if (iTouchState == 0) {
            for (i = 0; i < CPortingValues.iMaxLabelsOnMenu; ++i) {
                if (!CUtility.isPointInRect(pointerX, pointerY, this.iOptionMenuButtonStartX - (this.imageOptionMenuButton.getWidth() >> 1), this.iOptionMenuButtonY[i], this.imageOptionMenuButton.getWidth(), this.imageOptionMenuButton.getHeight())) continue;
                iOptionMenuIdx = i;
            }
        }
        if (iTouchState == 2) {
            if (CUtility.isRSKPressed(pointerX, pointerY)) {
                if (this.iSoundState == 0) {
                    this.objMenuSound.stopSound(0);
                }
                gameData.saveData(4, this.iSoundState);
                COptionManager.getInstance().switchToStates(1);
            } else {
                for (i = 0; i < CPortingValues.iMaxLabelsOnMenu; ++i) {
                    if (!CUtility.isPointInRect(pointerX, pointerY, this.iOptionMenuButtonStartX - (this.imageOptionMenuButton.getWidth() >> 1), this.iOptionMenuButtonY[i], this.imageOptionMenuButton.getWidth(), this.imageOptionMenuButton.getHeight())) continue;
                    if (i == 0) {
                        if (this.iSoundState == 0) {
                            this.iSoundState = 1;
                            this.objMenuSound.stopSound(0);
                            gameData.saveData(4, this.iSoundState);
                            break;
                        }
                        this.iSoundState = 0;
                        this.objMenuSound.playSound(0, true);
                        gameData.saveData(4, this.iSoundState);
                        break;
                    }
                    if (this.iSoundState == 0) {
                        this.objMenuSound.stopSound(0);
                    }
                    gameData.saveData(4, this.iSoundState);
                    COptionManager.getInstance().switchToStates(iOptionMenuIdx + 11);
                    break;
                }
            }
        }
    }

    public void gameInterrupted(boolean state) {
        if (state) {
            if (this.iSoundState == 0) {
                this.objMenuSound.stopSound(0);
            }
        } else if (this.iSoundState == 0) {
            this.objMenuSound.playSound(0, true);
        }
    }

    public void unLoadImages() {
        this.imageOptionMenuBG = null;
        this.imageOptionMenuLogo = null;
        this.imageOptionMenuButton = null;
        this.objMenuFont = null;
        this.objMenuRollFont = null;
        this.objMenuSound.stopSound(0);
        this.objMenuSound.unloadSound();
        this.objMenuSound = null;
        this.imageBack = null;
    }

    static {
        strOptionMenu = new String[]{"SOUND ON", "HELP", "ABOUT", "HIGHSCORES"};
        strSound = new String[]{"/sound/menu.mid"};
    }
}

