/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.jme.signature;

import com.shephertz.app42.paas.sdk.jme.App42Log;
import java.io.UnsupportedEncodingException;
import net.oauth.jme.Util;
import net.oauth.jme.signature.OAuthSignature;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;

public class HMACSHA1Signature
implements OAuthSignature {
    private String method = "HMAC-SHA1";
    private String message = "";
    private String key;
    private String signature = "";

    public String getMethod() {
        return this.method;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getSignature() {
        try {
            HMac m = new HMac(new SHA1Digest());
            m.init(new KeyParameter(this.key.getBytes("UTF-8")));
            byte[] bytes = this.message.getBytes("UTF-8");
            m.update(bytes, 0, bytes.length);
            byte[] mac = new byte[m.getMacSize()];
            m.doFinal(mac, 0);
            this.signature = new String(Util.base64Encode(mac));
            App42Log.debug("mac alg: " + m.getAlgorithmName());
            App42Log.debug("dig alg: " + m.getUnderlyingDigest().getAlgorithmName());
            App42Log.debug("key: " + this.key);
            App42Log.debug("message: " + this.message);
            App42Log.debug("unencoded: " + new String(mac));
            App42Log.debug("sig: " + this.signature);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.signature;
    }
}

