/*
 * Decompiled with CFR 0.152.
 */
package com.shephertz.app42.paas.sdk.jme;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.rms.RecordStore;

public class Installation {
    private static String installId = null;
    private static final String INSTALLATION_DB = "INSTALLATION_App42";
    private static final String SESSION_DB = "SESSION_App42";
    private static final String USER_DB = "USER_App42";

    public static synchronized String getId() {
        if (installId == null) {
            try {
                if (Installation.isInstallationDBAvailable()) {
                    Installation.readInstallationData();
                } else {
                    Installation.writeInInstallationDB(System.currentTimeMillis() + "");
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        return installId;
    }

    private static boolean isInstallationDBAvailable() {
        boolean status = false;
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)INSTALLATION_DB, (boolean)true);
            status = recordStore.getNumRecords() > 0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return status;
    }

    private static void readInstallationData() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)INSTALLATION_DB, (boolean)true);
            if (recordStore.getNumRecords() > 0) {
                byte[] data = recordStore.getRecord(1);
                ByteArrayInputStream bin = new ByteArrayInputStream(data);
                DataInputStream din = new DataInputStream(bin);
                installId = din.readUTF();
                din.close();
                bin.close();
                din = null;
                Object var3_4 = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String readSessionData() {
        String sessionData = "";
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)SESSION_DB, (boolean)true);
            if (recordStore.getNumRecords() > 0) {
                byte[] data = recordStore.getRecord(1);
                ByteArrayInputStream bin = new ByteArrayInputStream(data);
                DataInputStream din = new DataInputStream(bin);
                sessionData = din.readUTF();
                din.close();
                bin.close();
                din = null;
                din = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sessionData;
    }

    private static String readUserData() {
        String userData = "";
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)USER_DB, (boolean)true);
            if (recordStore.getNumRecords() > 0) {
                byte[] data = recordStore.getRecord(1);
                ByteArrayInputStream bin = new ByteArrayInputStream(data);
                DataInputStream din = new DataInputStream(bin);
                userData = din.readUTF();
                din.close();
                bin.close();
                din = null;
                din = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return userData;
    }

    private static void writeInInstallationDB(String sid) {
        installId = sid;
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)INSTALLATION_DB, (boolean)true);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            dos.writeUTF(sid);
            bos.flush();
            if (recordStore.getNumRecords() > 0) {
                recordStore.setRecord(1, bos.toByteArray(), 0, bos.toByteArray().length);
            } else {
                recordStore.addRecord(bos.toByteArray(), 0, bos.toByteArray().length);
            }
            bos.close();
            dos.close();
            bos = null;
            Object var3_4 = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void writeInSessionDB(String sessionData) {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)SESSION_DB, (boolean)true);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            dos.writeUTF(sessionData);
            bos.flush();
            if (recordStore.getNumRecords() > 0) {
                recordStore.setRecord(1, bos.toByteArray(), 0, bos.toByteArray().length);
            } else {
                recordStore.addRecord(bos.toByteArray(), 0, bos.toByteArray().length);
            }
            bos.close();
            dos.close();
            bos = null;
            Object var3_4 = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void writeInUserDB(String userData) {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)USER_DB, (boolean)true);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            dos.writeUTF(userData);
            bos.flush();
            if (recordStore.getNumRecords() > 0) {
                recordStore.setRecord(1, bos.toByteArray(), 0, bos.toByteArray().length);
            } else {
                recordStore.addRecord(bos.toByteArray(), 0, bos.toByteArray().length);
            }
            bos.close();
            dos.close();
            bos = null;
            Object var3_4 = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getUser() {
        return Installation.readUserData();
    }

    public static synchronized void setUser(String userName) {
        Installation.writeInUserDB(userName);
    }

    public static synchronized void removeUser() {
        Installation.writeInUserDB("");
    }

    public static String getSession() {
        return Installation.readSessionData();
    }

    public static synchronized void setSessionId(String sessionData) {
        Installation.writeInSessionDB(sessionData);
    }

    public static synchronized void removeSession() {
        Installation.writeInSessionDB("");
    }
}

