/*
 * Decompiled with CFR 0.152.
 */
package com.shephertz.app42.paas.sdk.jme.appTab;

import com.shephertz.app42.paas.sdk.jme.App42Exception;
import com.shephertz.app42.paas.sdk.jme.appTab.BandwidthUnit;
import com.shephertz.app42.paas.sdk.jme.appTab.Charge;
import com.shephertz.app42.paas.sdk.jme.appTab.ChargeResponseBuilder;
import com.shephertz.app42.paas.sdk.jme.appTab.ChargeType;
import com.shephertz.app42.paas.sdk.jme.appTab.Currency;
import com.shephertz.app42.paas.sdk.jme.appTab.StorageUnit;
import com.shephertz.app42.paas.sdk.jme.connection.RESTConnector;
import com.shephertz.app42.paas.sdk.jme.util.Util;
import java.util.Hashtable;
import org.json.jme.JSONObject;

public class ChargeService {
    private String version = "1.0";
    private String resource = "usage";
    private String apiKey;
    private String secretKey;
    String baseURL;

    public ChargeService(String apiKey, String secretKey, String baseURL) {
        this.apiKey = apiKey;
        this.secretKey = secretKey;
        this.baseURL = baseURL;
    }

    public Charge createStorageCharge(String storageName, Double storageSpace, String usageStorage, Double storagePrice, String storageCurrency, String storageDescription) throws App42Exception {
        String response = null;
        Charge usage = null;
        Util.throwExceptionIfNullOrBlank(storageName, "Name");
        Util.throwExceptionIfNullOrBlank(storageSpace, "Space");
        Util.throwExceptionIfNullOrBlank(usageStorage, "usageStorage");
        Util.throwExceptionIfNullOrBlank(storagePrice, "Price");
        Util.throwExceptionIfNullOrBlank(storageCurrency, "Currency");
        Util.throwExceptionIfNullOrBlank(storageDescription, "Description");
        StorageUnit.throwExceptionIfNotValid(usageStorage);
        Currency.throwExceptionIfNotValid(storageCurrency);
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            Hashtable queryParams = new Hashtable();
            params.put("apiKey", this.apiKey);
            params.put("version", this.version);
            params.put("timeStamp", Util.getUTCFormattedTimestamp());
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, params);
            JSONObject obj = new JSONObject();
            obj.put("name", storageName);
            obj.put("price", storagePrice);
            obj.put("space", storageSpace);
            obj.put("unit", usageStorage);
            obj.put("currency", storageCurrency);
            obj.put("description", storageDescription);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"appTab\":{\"usage\":{\"storage\":").append(obj.toString()).append("}}}}");
            params.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, params);
            String resourceURL = this.version + "/" + this.resource + "/storage";
            response = RESTConnector.getInstance().executePost(signature, resourceURL, queryParams, sb.toString());
            usage = new ChargeResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return usage;
    }

    public Charge createBandwidthCharge(String bandwidthName, Double bandwidthUsage, String usageBandWidth, Double bandwidthPrice, String bandwidthCurrency, String bandwidthDescription) throws App42Exception {
        String response = null;
        Charge usage = null;
        Util.throwExceptionIfNullOrBlank(bandwidthName, "Name");
        Util.throwExceptionIfNullOrBlank(bandwidthUsage, "BandWidth");
        Util.throwExceptionIfNullOrBlank(usageBandWidth, "usageBandWidth");
        Util.throwExceptionIfNullOrBlank(bandwidthPrice, "Price");
        Util.throwExceptionIfNullOrBlank(bandwidthCurrency, "Currency");
        Util.throwExceptionIfNullOrBlank(bandwidthDescription, "Description");
        BandwidthUnit.throwExceptionIfNotValid(usageBandWidth);
        Currency.throwExceptionIfNotValid(bandwidthCurrency);
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            Hashtable queryParams = new Hashtable();
            params.put("apiKey", this.apiKey);
            params.put("version", this.version);
            params.put("timeStamp", Util.getUTCFormattedTimestamp());
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, params);
            JSONObject obj = new JSONObject();
            obj.put("name", bandwidthName);
            obj.put("price", bandwidthPrice);
            obj.put("bandwidth", bandwidthUsage);
            obj.put("unit", usageBandWidth);
            obj.put("currency", bandwidthCurrency);
            obj.put("description", bandwidthDescription);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"appTab\":{\"usage\":{\"bandwidth\":").append(obj.toString()).append("}}}}");
            params.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, params);
            String resourceURL = this.version + "/" + this.resource + "/bandwidth";
            response = RESTConnector.getInstance().executePost(signature, resourceURL, queryParams, sb.toString());
            usage = new ChargeResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return usage;
    }

    public Charge createFeatureCharge(String featureName, Double featurePrice, String featureCurrency, String featureDescription) throws App42Exception {
        String response = null;
        Charge usage = null;
        Util.throwExceptionIfNullOrBlank(featureName, "Name");
        Util.throwExceptionIfNullOrBlank(featurePrice, "Price");
        Util.throwExceptionIfNullOrBlank(featureCurrency, "Currency");
        Util.throwExceptionIfNullOrBlank(featureDescription, "Description");
        Currency.throwExceptionIfNotValid(featureCurrency);
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            Hashtable queryParams = new Hashtable();
            params.put("apiKey", this.apiKey);
            params.put("version", this.version);
            params.put("timeStamp", Util.getUTCFormattedTimestamp());
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, params);
            JSONObject obj = new JSONObject();
            obj.put("name", featureName);
            obj.put("price", featurePrice);
            obj.put("currency", featureCurrency);
            obj.put("description", featureDescription);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"appTab\":{\"usage\":{\"feature\":").append(obj.toString()).append("}}}}");
            params.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, params);
            String resourceURL = this.version + "/" + this.resource + "/feature";
            response = RESTConnector.getInstance().executePost(signature, resourceURL, queryParams, sb.toString());
            usage = new ChargeResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return usage;
    }

    public Charge validatePackageUsage(String schemeName, String packageName, String featureName, String userName, Double storageSpace, String usageStorage) throws App42Exception {
        String response = null;
        Charge usage = null;
        Util.throwExceptionIfNullOrBlank(schemeName, "Scheme");
        Util.throwExceptionIfNullOrBlank(packageName, "Package");
        Util.throwExceptionIfNullOrBlank(userName, "UserName");
        Util.throwExceptionIfNullOrBlank(storageSpace, "Space");
        Util.throwExceptionIfNullOrBlank(usageStorage, "Storage");
        StorageUnit.throwExceptionIfNotValid(usageStorage);
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            Hashtable queryParams = new Hashtable();
            params.put("apiKey", this.apiKey);
            params.put("version", this.version);
            params.put("timeStamp", Util.getUTCFormattedTimestamp());
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, params);
            JSONObject obj = new JSONObject();
            obj.put("schemeName", schemeName);
            obj.put("packageName", packageName);
            obj.put("userName", userName);
            obj.put("feature", featureName);
            obj.put("space", storageSpace);
            obj.put("unit", usageStorage);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"appTab\":{\"usage\":{\"charge\":{\"packages\":").append(obj.toString()).append("}}}}}");
            params.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, params);
            String resourceURL = this.version + "/" + this.resource + "/validate" + "/package";
            response = RESTConnector.getInstance().executePost(signature, resourceURL, queryParams, sb.toString());
            usage = new ChargeResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return usage;
    }

    public Charge chargePackage(String schemeName, String packageName, String chargeUser, Double storageSpace, String usageStorage, String type) throws App42Exception {
        String response = null;
        Charge usage = null;
        Util.throwExceptionIfNullOrBlank(schemeName, "Scheme");
        Util.throwExceptionIfNullOrBlank(packageName, "Package");
        Util.throwExceptionIfNullOrBlank(chargeUser, "UserName");
        Util.throwExceptionIfNullOrBlank(storageSpace, "Space");
        Util.throwExceptionIfNullOrBlank(usageStorage, "Storage");
        ChargeType.throwExceptionIfNotValid(type);
        StorageUnit.throwExceptionIfNotValid(usageStorage);
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            Hashtable queryParams = new Hashtable();
            params.put("apiKey", this.apiKey);
            params.put("version", this.version);
            params.put("timeStamp", Util.getUTCFormattedTimestamp());
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, params);
            JSONObject obj = new JSONObject();
            obj.put("schemeName", schemeName);
            obj.put("packageName", packageName);
            obj.put("userName", chargeUser);
            obj.put("space", storageSpace);
            obj.put("unit", usageStorage);
            obj.put("type", type);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"appTab\":{\"usage\":{\"charge\":{\"packages\":").append(obj.toString()).append("}}}}}");
            params.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, params);
            String resourceURL = this.version + "/" + this.resource + "/charge" + "/package";
            response = RESTConnector.getInstance().executePost(signature, resourceURL, queryParams, sb.toString());
            usage = new ChargeResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return usage;
    }
}

