/*
 * Decompiled with CFR 0.152.
 */
package com.shephertz.app42.paas.sdk.jme.appTab;

import com.shephertz.app42.paas.sdk.jme.App42Exception;
import com.shephertz.app42.paas.sdk.jme.App42Response;
import com.shephertz.app42.paas.sdk.jme.appTab.DiscountData;
import com.shephertz.app42.paas.sdk.jme.appTab.DiscountResponseBuilder;
import com.shephertz.app42.paas.sdk.jme.appTab.DiscountType;
import com.shephertz.app42.paas.sdk.jme.connection.RESTConnector;
import com.shephertz.app42.paas.sdk.jme.util.Util;
import java.util.Hashtable;
import java.util.Vector;
import org.json.jme.JSONObject;

public class DiscountService {
    private String version = "1.0";
    private String resource = "discount";
    private String apiKey;
    private String secretKey;

    public DiscountService(String apiKey, String secretKey, String baseURL) {
        this.apiKey = apiKey;
        this.secretKey = secretKey;
    }

    public DiscountData createDiscount(String discountName, String discountType, DiscountData.Discount discount, String description) throws App42Exception {
        String response = null;
        DiscountData discountDataObj = null;
        Util.throwExceptionIfNullOrBlank(discountName, "discountName");
        Util.throwExceptionIfNullOrBlank(discountType, "DiscountType");
        Util.throwExceptionIfNullOrBlank(discount, "discount");
        Util.throwExceptionIfNullOrBlank(description, "description");
        DiscountType.throwExceptionIfNotValid(discountType);
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            Hashtable queryParams = new Hashtable();
            params.put("apiKey", this.apiKey);
            params.put("version", this.version);
            params.put("timeStamp", Util.getUTCFormattedTimestamp());
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, params);
            String strStartDate = Util.getUTCFormattedTimestamp(discount.getStartDate());
            String strEndDate = Util.getUTCFormattedTimestamp(discount.getEndDate());
            JSONObject obj = new JSONObject();
            JSONObject discountObj = new JSONObject();
            discountObj.put("percentage", discount.getPercentage());
            discountObj.put("usage", discount.getUsage());
            discountObj.put("startDate", strStartDate);
            discountObj.put("endDate", strEndDate);
            obj.put("discountName", discountName);
            obj.put("description", description);
            obj.put("type", discountType);
            obj.put("discountDetails", discountObj);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"app\":{\"discount\":").append(obj.toString()).append("}}}");
            params.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, params);
            String resourceURL = this.version + "/" + this.resource;
            response = RESTConnector.getInstance().executePost(signature, resourceURL, queryParams, sb.toString());
            discountDataObj = new DiscountResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return discountDataObj;
    }

    public Vector getAllDiscount() throws App42Exception {
        String response = null;
        Vector discountList = null;
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            Hashtable queryParams = new Hashtable();
            params.put("apiKey", this.apiKey);
            params.put("version", this.version);
            params.put("timeStamp", Util.getUTCFormattedTimestamp());
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, params);
            String signature = Util.sign(this.secretKey, params);
            String resourceURL = this.version + "/" + this.resource;
            response = RESTConnector.getInstance().executeGet(signature, resourceURL, queryParams);
            discountList = new DiscountResponseBuilder().buildArrayObject(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return discountList;
    }

    public DiscountData getDiscountByName(String discountName) throws App42Exception {
        String response = null;
        DiscountData discountDataObj = null;
        Util.throwExceptionIfNullOrBlank(discountName, "discountName");
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            Hashtable queryParams = new Hashtable();
            params.put("apiKey", this.apiKey);
            params.put("version", this.version);
            params.put("timeStamp", Util.getUTCFormattedTimestamp());
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, params);
            params.put("discountName", discountName);
            String signature = Util.sign(this.secretKey, params);
            String resourceURL = this.version + "/" + this.resource + "/" + discountName;
            response = RESTConnector.getInstance().executeGet(signature, resourceURL, queryParams);
            discountDataObj = new DiscountResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return discountDataObj;
    }

    public App42Response deleteDiscountByName(String discountName) throws App42Exception {
        String response = null;
        DiscountData discountDataObj = null;
        Util.throwExceptionIfNullOrBlank(discountName, "discountName");
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            Hashtable queryParams = new Hashtable();
            params.put("apiKey", this.apiKey);
            params.put("version", this.version);
            params.put("timeStamp", Util.getUTCFormattedTimestamp());
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, params);
            params.put("discountName", discountName);
            String signature = Util.sign(this.secretKey, params);
            String resourceURL = this.version + "/" + this.resource + "/" + discountName;
            response = RESTConnector.getInstance().executeDelete(signature, resourceURL, queryParams);
            discountDataObj = new DiscountResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return discountDataObj;
    }

    public DiscountData getDiscountByPromoCode(String promoCode) throws App42Exception {
        String response = null;
        DiscountData discountDataObj = null;
        Util.throwExceptionIfNullOrBlank(promoCode, "promoCode");
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            Hashtable queryParams = new Hashtable();
            params.put("apiKey", this.apiKey);
            params.put("version", this.version);
            params.put("timeStamp", Util.getUTCFormattedTimestamp());
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, params);
            params.put("promoCode", promoCode);
            String signature = Util.sign(this.secretKey, params);
            String resourceURL = this.version + "/" + this.resource + "/" + "discount/" + promoCode;
            response = RESTConnector.getInstance().executeGet(signature, resourceURL, queryParams);
            discountDataObj = new DiscountResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return discountDataObj;
    }
}

