/*
 * Decompiled with CFR 0.152.
 */
package com.shephertz.app42.paas.sdk.jme.appTab;

import com.shephertz.app42.paas.sdk.jme.App42Exception;
import com.shephertz.app42.paas.sdk.jme.appTab.BandwidthUnit;
import com.shephertz.app42.paas.sdk.jme.appTab.SchemeData;
import com.shephertz.app42.paas.sdk.jme.appTab.SchemeResponseBuilder;
import com.shephertz.app42.paas.sdk.jme.appTab.StorageUnit;
import com.shephertz.app42.paas.sdk.jme.connection.RESTConnector;
import com.shephertz.app42.paas.sdk.jme.util.Util;
import java.util.Hashtable;
import java.util.Vector;
import org.json.jme.JSONArray;
import org.json.jme.JSONObject;

public class SchemeService {
    private String version = "1.0";
    private String resource = "scheme";
    private String packageResource = "package";
    private String apiKey;
    private String secretKey;

    public SchemeService(String apiKey, String secretKey, String baseURL) {
        this.apiKey = apiKey;
        this.secretKey = secretKey;
    }

    public SchemeData createScheme(String schemeName, String description) throws App42Exception {
        String response = null;
        SchemeData schemeDataObj = null;
        Util.throwExceptionIfNullOrBlank(schemeName, "Name");
        Util.throwExceptionIfNullOrBlank(description, "Description");
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            Hashtable queryParams = new Hashtable();
            params.put("apiKey", this.apiKey);
            params.put("version", this.version);
            params.put("timeStamp", Util.getUTCFormattedTimestamp());
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, params);
            JSONObject obj = new JSONObject();
            JSONObject schemeObj = new JSONObject();
            schemeObj.put("name", schemeName);
            schemeObj.put("description", description);
            obj.put("scheme", schemeObj);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"app\":").append(obj.toString()).append("}}");
            params.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, params);
            String resourceURL = this.version + "/" + this.resource;
            response = RESTConnector.getInstance().executePost(signature, resourceURL, queryParams, sb.toString());
            schemeDataObj = new SchemeResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return schemeDataObj;
    }

    public Vector getAllSchemes() throws App42Exception {
        String response = null;
        Vector schemeDataList = null;
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            Hashtable queryParams = new Hashtable();
            params.put("apiKey", this.apiKey);
            params.put("version", this.version);
            params.put("timeStamp", Util.getUTCFormattedTimestamp());
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, params);
            String signature = Util.sign(this.secretKey, params);
            String resourceURL = this.version + "/" + this.resource;
            response = RESTConnector.getInstance().executeGet(signature, resourceURL, queryParams);
            schemeDataList = new SchemeResponseBuilder().buildArrayResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return schemeDataList;
    }

    public SchemeData getSchemeByName(String schemeName) throws App42Exception {
        String response = null;
        SchemeData schemeDataObj = null;
        Util.throwExceptionIfNullOrBlank(schemeName, "Name");
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            Hashtable queryParams = new Hashtable();
            params.put("apiKey", this.apiKey);
            params.put("version", this.version);
            params.put("timeStamp", Util.getUTCFormattedTimestamp());
            params.put("schemeName", schemeName);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, params);
            String signature = Util.sign(this.secretKey, params);
            String resourceURL = this.version + "/" + this.resource + "/" + schemeName;
            response = RESTConnector.getInstance().executeGet(signature, resourceURL, queryParams);
            schemeDataObj = new SchemeResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return schemeDataObj;
    }

    public SchemeData createPackage(String schemeName, SchemeData.PackageData pkgData) throws App42Exception {
        String response = null;
        SchemeData schemeObj = null;
        Util.throwExceptionIfNullOrBlank(schemeName, "schemeName");
        Util.throwExceptionIfNullOrBlank(pkgData, "PackageDetails");
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            Hashtable queryParams = new Hashtable();
            params.put("apiKey", this.apiKey);
            params.put("version", this.version);
            params.put("timeStamp", Util.getUTCFormattedTimestamp());
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, params);
            JSONObject obj = new JSONObject();
            JSONObject packageObj = new JSONObject();
            packageObj.put("name", pkgData.getName());
            packageObj.put("duration", pkgData.getDuration());
            packageObj.put("currency", pkgData.getCurrency());
            packageObj.put("price", pkgData.getPrice());
            packageObj.put("description", pkgData.getDescription());
            obj.put("name", schemeName);
            obj.put("packageDetails", packageObj);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"app\":{\"scheme\":").append(obj.toString()).append("}}}");
            params.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, params);
            String resourceURL = this.version + "/" + this.packageResource;
            response = RESTConnector.getInstance().executePost(signature, resourceURL, queryParams, sb.toString());
            schemeObj = new SchemeResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return schemeObj;
    }

    public SchemeData addStorageInToPackage(String schemeName, String packageName, String storageName) throws App42Exception {
        String response = null;
        SchemeData schemeObj = null;
        Util.throwExceptionIfNullOrBlank(schemeName, "Name");
        Util.throwExceptionIfNullOrBlank(packageName, "PackageDetails");
        Util.throwExceptionIfNullOrBlank(storageName, "StorageName");
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            Hashtable queryParams = new Hashtable();
            params.put("apiKey", this.apiKey);
            params.put("version", this.version);
            params.put("timeStamp", Util.getUTCFormattedTimestamp());
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, params);
            JSONObject obj = new JSONObject();
            obj.put("schemeName", schemeName);
            obj.put("packageName", packageName);
            obj.put("storageName", storageName);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"app\":").append(obj.toString()).append("}}");
            params.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, params);
            String resourceURL = this.version + "/" + this.packageResource + "/package" + "/" + packageName + "/storage" + "/" + storageName;
            response = RESTConnector.getInstance().executePost(signature, resourceURL, queryParams, sb.toString());
            schemeObj = new SchemeResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return schemeObj;
    }

    public SchemeData addBandwidthInToPackage(String schemeName, String packageName, String bandwidthName) throws App42Exception {
        String response = null;
        SchemeData schemeObj = null;
        Util.throwExceptionIfNullOrBlank(schemeName, "Name");
        Util.throwExceptionIfNullOrBlank(packageName, "PackageDetails");
        Util.throwExceptionIfNullOrBlank(bandwidthName, "BandwidthName");
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            Hashtable queryParams = new Hashtable();
            params.put("apiKey", this.apiKey);
            params.put("version", this.version);
            params.put("timeStamp", Util.getUTCFormattedTimestamp());
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, params);
            JSONObject obj = new JSONObject();
            obj.put("schemeName", schemeName);
            obj.put("packageName", packageName);
            obj.put("bandwidthName", bandwidthName);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"app\":").append(obj.toString()).append("}}");
            params.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, params);
            String resourceURL = this.version + "/" + this.packageResource + "/package" + "/" + packageName + "/bandwidth" + "/" + bandwidthName;
            response = RESTConnector.getInstance().executePost(signature, resourceURL, queryParams, sb.toString());
            schemeObj = new SchemeResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return schemeObj;
    }

    public SchemeData createPackageWithUsage(String schemeName, SchemeData.PackageData pkgData) throws App42Exception {
        String response = null;
        SchemeData schemeObj = null;
        Util.throwExceptionIfNullOrBlank(schemeName, "Name");
        Util.throwExceptionIfNullOrBlank(pkgData, "PackageDetails");
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            Hashtable queryParams = new Hashtable();
            params.put("apiKey", this.apiKey);
            params.put("version", this.version);
            params.put("timeStamp", Util.getUTCFormattedTimestamp());
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, params);
            JSONObject obj = new JSONObject();
            SchemeData.PackageData.Storage storage = pkgData.getStorage();
            JSONObject storageObj = new JSONObject();
            storageObj.put("name", storage.getName());
            storageObj.put("price", storage.getPrice());
            storageObj.put("unit", storage.getUnit());
            storageObj.put("space", storage.getSpace());
            storageObj.put("description", storage.getDescription());
            SchemeData.PackageData.Bandwidth bandwidth = pkgData.getBandwidth();
            JSONObject bandwidthObj = new JSONObject();
            bandwidthObj.put("name", bandwidth.getName());
            bandwidthObj.put("price", bandwidth.getPrice());
            bandwidthObj.put("unit", bandwidth.getUnit());
            bandwidthObj.put("bandwidth", bandwidth.getBandwidth());
            bandwidthObj.put("description", bandwidth.getDescription());
            SchemeData.PackageData.Feature feature = pkgData.getFeature();
            JSONObject featureObj = new JSONObject();
            featureObj.put("price", feature.getPrice());
            featureObj.put("name", feature.getName());
            featureObj.put("description", feature.getDescription());
            JSONObject packageObj = new JSONObject();
            packageObj.put("name", pkgData.getName());
            packageObj.put("duration", pkgData.getDuration());
            packageObj.put("price", pkgData.getPrice());
            packageObj.put("currency", pkgData.getCurrency());
            packageObj.put("description", pkgData.getDescription());
            packageObj.put("storage", storageObj);
            packageObj.put("bandwidth", bandwidthObj);
            packageObj.put("feature", featureObj);
            obj.put("name", schemeName);
            obj.put("packageDetails", packageObj);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"app\":{\"scheme\":").append(obj.toString()).append("}}}");
            params.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, params);
            String resourceURL = this.version + "/" + this.packageResource + "/package" + "/" + schemeName;
            response = RESTConnector.getInstance().executePost(signature, resourceURL, queryParams, sb.toString());
            schemeObj = new SchemeResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return schemeObj;
    }

    public SchemeData getAllPackages(String schemeName) throws App42Exception {
        String response = null;
        SchemeData schemeObj = null;
        Util.throwExceptionIfNullOrBlank(schemeName, "Name");
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            Hashtable queryParams = new Hashtable();
            params.put("apiKey", this.apiKey);
            params.put("version", this.version);
            params.put("timeStamp", Util.getUTCFormattedTimestamp());
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, params);
            params.put("schemeName", schemeName);
            String signature = Util.sign(this.secretKey, params);
            String resourceURL = this.version + "/" + this.packageResource + "/" + "scheme" + "/" + schemeName;
            response = RESTConnector.getInstance().executeGet(signature, resourceURL, queryParams);
            schemeObj = new SchemeResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return schemeObj;
    }

    public SchemeData getPackageByPackageName(String schemeName, String packageName) throws App42Exception {
        String response = null;
        SchemeData schemeObj = null;
        Util.throwExceptionIfNullOrBlank(schemeName, "Name");
        Util.throwExceptionIfNullOrBlank(packageName, "packageName");
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            Hashtable queryParams = new Hashtable();
            params.put("apiKey", this.apiKey);
            params.put("version", this.version);
            params.put("timeStamp", Util.getUTCFormattedTimestamp());
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, params);
            params.put("schemeName", schemeName);
            params.put("packageName", packageName);
            String signature = Util.sign(this.secretKey, params);
            String resourceURL = this.version + "/" + this.packageResource + "/" + packageName + "/" + "scheme" + "/" + schemeName;
            response = RESTConnector.getInstance().executeGet(signature, resourceURL, queryParams);
            schemeObj = new SchemeResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return schemeObj;
    }

    public SchemeData addFeatureInToPackage(String schemeName, String packageName, Vector featureList) throws App42Exception {
        String response = null;
        SchemeData schemeObj = null;
        Util.throwExceptionIfNullOrBlank(schemeName, "Name");
        Util.throwExceptionIfNullOrBlank(packageName, "packageName");
        Util.throwExceptionIfNullOrBlank(featureList, "FeatureList");
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            Hashtable queryParams = new Hashtable();
            params.put("apiKey", this.apiKey);
            params.put("version", this.version);
            params.put("timeStamp", Util.getUTCFormattedTimestamp());
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, params);
            JSONArray featureArray = new JSONArray();
            for (int i = 0; i < featureList.size(); ++i) {
                String feature = (String)featureList.elementAt(i);
                featureArray.put(feature);
            }
            JSONObject obj = new JSONObject();
            obj.put("schemeName", schemeName);
            obj.put("packageName", packageName);
            obj.put("featureName", featureArray);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"app\":").append(obj.toString()).append("}}");
            params.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, params);
            String resourceURL = this.version + "/" + this.packageResource + "/package" + "/" + packageName + "/feature";
            response = RESTConnector.getInstance().executePost(signature, resourceURL, queryParams, sb.toString());
            schemeObj = new SchemeResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return schemeObj;
    }

    public SchemeData addLimitToStorage(String schemeName, String packageName, String storageName, Double price, String unit, Double space) throws App42Exception {
        String response = null;
        SchemeData schemeObj = null;
        Util.throwExceptionIfNullOrBlank(schemeName, "Name");
        Util.throwExceptionIfNullOrBlank(packageName, "PackageDetails");
        Util.throwExceptionIfNullOrBlank(storageName, "StorageName");
        StorageUnit.throwExceptionIfNotValid(unit);
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            Hashtable queryParams = new Hashtable();
            params.put("apiKey", this.apiKey);
            params.put("version", this.version);
            params.put("timeStamp", Util.getUTCFormattedTimestamp());
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, params);
            JSONObject obj = new JSONObject();
            obj.put("schemeName", schemeName);
            obj.put("packageName", packageName);
            obj.put("storageName", storageName);
            obj.put("storagePrice", price);
            obj.put("storageUnit", unit);
            obj.put("storageSpace", space);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"app\":").append(obj.toString()).append("}}");
            params.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, params);
            String resourceURL = this.version + "/" + this.packageResource + "/storage" + "/" + storageName;
            response = RESTConnector.getInstance().executePost(signature, resourceURL, queryParams, sb.toString());
            schemeObj = new SchemeResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return schemeObj;
    }

    public SchemeData addLimitToBandwidth(String schemeName, String packageName, String bandwidthName, Double price, String unit, Double bandwidth) throws App42Exception {
        String response = null;
        SchemeData schemeObj = null;
        Util.throwExceptionIfNullOrBlank(schemeName, "Name");
        Util.throwExceptionIfNullOrBlank(packageName, "PackageDetails");
        Util.throwExceptionIfNullOrBlank(bandwidthName, "BandwidthName");
        BandwidthUnit.throwExceptionIfNotValid(unit);
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            Hashtable queryParams = new Hashtable();
            params.put("apiKey", this.apiKey);
            params.put("version", this.version);
            params.put("timeStamp", Util.getUTCFormattedTimestamp());
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, params);
            JSONObject obj = new JSONObject();
            obj.put("schemeName", schemeName);
            obj.put("packageName", packageName);
            obj.put("bandwidthName", bandwidthName);
            obj.put("bandwidthPrice", price);
            obj.put("bandwidthUnit", unit);
            obj.put("bandwidth", bandwidth);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"app\":").append(obj.toString()).append("}}");
            params.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, params);
            String resourceURL = this.version + "/" + this.packageResource + "/bandwidth" + "/" + bandwidthName;
            response = RESTConnector.getInstance().executePost(signature, resourceURL, queryParams, sb.toString());
            schemeObj = new SchemeResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return schemeObj;
    }
}

