/*
 * Decompiled with CFR 0.152.
 */
package com.shephertz.app42.paas.sdk.jme.appTab;

import com.shephertz.app42.paas.sdk.jme.App42Exception;
import com.shephertz.app42.paas.sdk.jme.appTab.Subscribe;
import com.shephertz.app42.paas.sdk.jme.appTab.SubscribeResponseBuilder;
import com.shephertz.app42.paas.sdk.jme.connection.RESTConnector;
import com.shephertz.app42.paas.sdk.jme.util.Util;
import java.util.Hashtable;
import org.json.jme.JSONObject;

public class SubscribeService {
    private String version = "1.0";
    private String resource = "subscribe";
    private String apiKey;
    private String secretKey;

    public SubscribeService(String apiKey, String secretKey, String baseURL) {
        this.apiKey = apiKey;
        this.secretKey = secretKey;
    }

    public Subscribe subscribe(String uName, String schemeName, String packageName, boolean renew) throws App42Exception {
        String response = null;
        Subscribe subscribe = null;
        Util.throwExceptionIfNullOrBlank(uName, "UserName");
        Util.throwExceptionIfNullOrBlank(schemeName, "Name");
        Util.throwExceptionIfNullOrBlank(packageName, "Name");
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            Hashtable queryParams = new Hashtable();
            params.put("apiKey", this.apiKey);
            params.put("version", this.version);
            params.put("timeStamp", Util.getUTCFormattedTimestamp());
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, params);
            JSONObject obj = new JSONObject();
            JSONObject schemeObj = new JSONObject();
            JSONObject pkgObj = new JSONObject();
            pkgObj.put("name", packageName);
            schemeObj.put("packageDetails", pkgObj);
            schemeObj.put("name", schemeName);
            obj.put("userName", uName);
            obj.put("autoRenew", renew);
            obj.put("scheme", schemeObj);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"app\":{\"subscribe\":").append(obj.toString()).append("}}}");
            params.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, params);
            String resourceURL = this.version + "/" + this.resource;
            response = RESTConnector.getInstance().executePost(signature, resourceURL, queryParams, sb.toString());
            subscribe = new SubscribeResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return subscribe;
    }

    public String getAllSusbscriptions() throws App42Exception {
        String response = null;
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            Hashtable queryParams = new Hashtable();
            params.put("apiKey", this.apiKey);
            params.put("version", this.version);
            params.put("timeStamp", Util.getUTCFormattedTimestamp());
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, params);
            String signature = Util.sign(this.secretKey, params);
            String resourceURL = this.version + "/" + this.resource;
            response = RESTConnector.getInstance().executeGet(signature, resourceURL, queryParams);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return response;
    }

    public Subscribe getSusbscriptionsByUserName(String userName) throws App42Exception {
        String response = null;
        Subscribe subscribe = null;
        Util.throwExceptionIfNullOrBlank(userName, "UserName");
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            Hashtable queryParams = new Hashtable();
            params.put("apiKey", this.apiKey);
            params.put("version", this.version);
            params.put("timeStamp", Util.getUTCFormattedTimestamp());
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, params);
            params.put("userName", userName);
            String signature = Util.sign(this.secretKey, params);
            String resourceURL = this.version + "/" + this.resource + "/" + userName;
            response = RESTConnector.getInstance().executeGet(signature, resourceURL, queryParams);
            subscribe = new SubscribeResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return subscribe;
    }

    public Subscribe unSusbscriptions(String userName, String schemeName, String packageName) throws App42Exception {
        String response = null;
        Subscribe subscribe = null;
        Util.throwExceptionIfNullOrBlank(userName, "UserName");
        Util.throwExceptionIfNullOrBlank(schemeName, "Name");
        Util.throwExceptionIfNullOrBlank(packageName, "Name");
        try {
            Hashtable<String, String> params = new Hashtable<String, String>();
            Hashtable queryParams = new Hashtable();
            params.put("apiKey", this.apiKey);
            params.put("version", this.version);
            params.put("timeStamp", Util.getUTCFormattedTimestamp());
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, params);
            params.put("userName", userName);
            params.put("schemeName", schemeName);
            params.put("packageName", packageName);
            String signature = Util.sign(this.secretKey, params);
            String resourceURL = this.version + "/" + this.resource;
            response = RESTConnector.getInstance().executeDelete(signature, resourceURL, queryParams);
            subscribe = new SubscribeResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return subscribe;
    }
}

