/*
 * Decompiled with CFR 0.152.
 */
package com.shephertz.app42.paas.sdk.jme.buddy;

import com.shephertz.app42.paas.sdk.jme.App42Log;
import com.shephertz.app42.paas.sdk.jme.App42ResponseBuilder;
import com.shephertz.app42.paas.sdk.jme.buddy.Buddy;
import com.shephertz.app42.paas.sdk.jme.util.Util;
import java.util.Vector;
import org.json.jme.JSONArray;
import org.json.jme.JSONObject;

public class BuddyResponseBuilder
extends App42ResponseBuilder {
    public Buddy buildResponse(String json) throws Exception {
        JSONObject buddysJSONObj = this.getServiceJSONObject("buddies", json);
        JSONObject buddyJSONObject = buddysJSONObj.getJSONObject("buddy");
        Buddy buddy = this.buildBuddyObject(buddyJSONObject);
        buddy.setStrResponse(json);
        buddy.setResponseSuccess(this.isResponseSuccess(json));
        return buddy;
    }

    public Buddy buildBuddyObject(JSONObject jsonObject) throws Exception {
        Buddy buddy = new Buddy();
        this.buildObjectFromJSONTree(buddy, jsonObject);
        if (jsonObject.has("points") && jsonObject.getJSONObject("points").has("point")) {
            if (jsonObject.getJSONObject("points").get("point") instanceof JSONObject) {
                JSONObject pointJSONObj = jsonObject.getJSONObject("points").getJSONObject("point");
                Buddy.Point point = buddy.new Buddy.Point();
                this.buildObjectFromJSONTree(point, pointJSONObj);
            } else {
                JSONArray pointJSONArray = jsonObject.getJSONObject("points").getJSONArray("point");
                for (int i = 0; i < pointJSONArray.length(); ++i) {
                    JSONObject pointJSONObj = pointJSONArray.getJSONObject(i);
                    Buddy.Point point = buddy.new Buddy.Point();
                    this.buildObjectFromJSONTree(point, pointJSONObj);
                }
            }
        }
        return buddy;
    }

    public Vector buildArrayResponse(String response) throws Exception {
        JSONObject buddysJSONObj = this.getServiceJSONObject("buddies", response);
        Vector<Buddy> buddyList = new Vector<Buddy>();
        if (buddysJSONObj.get("buddy") instanceof JSONArray) {
            JSONArray buddyJSONArray = buddysJSONObj.getJSONArray("buddy");
            for (int i = 0; i < buddyJSONArray.length(); ++i) {
                JSONObject buddyJSONObject = buddyJSONArray.getJSONObject(i);
                Buddy buddy = this.buildBuddyObject(buddyJSONObject);
                buddy.setStrResponse(response);
                buddy.setResponseSuccess(this.isResponseSuccess(response));
                buddyList.addElement(buddy);
            }
        } else {
            JSONObject buddyJSONObject = buddysJSONObj.getJSONObject("buddy");
            Buddy buddy = this.buildBuddyObject(buddyJSONObject);
            buddy.setStrResponse(response);
            buddy.setResponseSuccess(this.isResponseSuccess(response));
            buddyList.addElement(buddy);
        }
        return buddyList;
    }

    public void buildObjectFromJSONTree(Object obj, JSONObject jsonObj) throws Exception {
        block15: {
            block14: {
                if (!(obj instanceof Buddy)) break block14;
                Buddy buddy = (Buddy)obj;
                String[] names = this.getNames(jsonObj);
                if (names == null) break block15;
                for (int i = 0; i < names.length; ++i) {
                    String acceptedOn;
                    String sendedOn;
                    String name = names[i];
                    if (name.equals("userName")) {
                        buddy.setUserName("" + jsonObj.get(name));
                    }
                    if (name.equals("buddyName")) {
                        buddy.setBuddyName("" + jsonObj.get(name));
                    }
                    if (name.equals("groupName")) {
                        buddy.setGroupName("" + jsonObj.get(name));
                    }
                    if (name.equals("ownerName")) {
                        buddy.setOwnerName("" + jsonObj.get(name));
                    }
                    if (name.equals("message")) {
                        buddy.setMessage("" + jsonObj.get(name));
                    }
                    if (name.equals("sendedOn") && jsonObj.get(name) != null && !(sendedOn = "" + jsonObj.get(name)).equals("null")) {
                        App42Log.debug(" SendedOn Not Null " + jsonObj.get(name));
                        buddy.setSendedOn(Util.getDateFromUTCTimeStamp("" + jsonObj.get(name)));
                    }
                    if (!name.equals("acceptedOn") || jsonObj.get(name) == null || (acceptedOn = "" + jsonObj.get(name)).equals("null")) continue;
                    App42Log.debug(" AcceptedOn Not Null " + jsonObj.get(name));
                    buddy.setAcceptedOn(Util.getDateFromUTCTimeStamp("" + jsonObj.get(name)));
                }
                break block15;
            }
            if (obj instanceof Buddy.Point) {
                Buddy.Point point = (Buddy.Point)obj;
                String[] names = this.getNames(jsonObj);
                if (names != null) {
                    for (int i = 0; i < names.length; ++i) {
                        String value;
                        String name = names[i];
                        if (name.equals("latitude") && !(value = "" + jsonObj.get(name)).equals("null") && !value.equals("")) {
                            point.setLatitude(Double.valueOf(value));
                        }
                        if (name.equals("longitude") && !(value = "" + jsonObj.get(name)).equals("null") && !value.equals("")) {
                            point.setLongitude(Double.valueOf(value));
                        }
                        if (name.equals("markerName")) {
                            point.setMarkerName("" + jsonObj.get(name));
                        }
                        if (name.equals("createdOn")) {
                            point.setCreatedOn(Util.getDateFromUTCTimeStamp("" + jsonObj.get(name)));
                        }
                        if (!name.equals("buddyName")) continue;
                        point.setBuddyName("" + jsonObj.get(name));
                    }
                }
            }
        }
    }
}

