/*
 * Decompiled with CFR 0.152.
 */
package com.shephertz.app42.paas.sdk.jme.email;

import com.shephertz.app42.paas.sdk.jme.App42CallBack;
import com.shephertz.app42.paas.sdk.jme.App42Exception;
import com.shephertz.app42.paas.sdk.jme.App42Log;
import com.shephertz.app42.paas.sdk.jme.App42Response;
import com.shephertz.app42.paas.sdk.jme.App42Service;
import com.shephertz.app42.paas.sdk.jme.connection.RESTConnectorAsync;
import com.shephertz.app42.paas.sdk.jme.email.Email;
import com.shephertz.app42.paas.sdk.jme.email.EmailMIME;
import com.shephertz.app42.paas.sdk.jme.email.EmailResponseBuilder;
import com.shephertz.app42.paas.sdk.jme.util.Util;
import java.util.Hashtable;
import org.json.jme.JSONObject;

public class EmailService
extends App42Service {
    private String resource = "email";

    public EmailService(String apiKey, String secretKey, String baseURL) {
        this.apiKey = apiKey;
        this.secretKey = secretKey;
        this.version = "1.0";
    }

    public Email createMailConfiguration(String emailHost, int emailPort, String mailId, String emailPassword, boolean isSSL) throws App42Exception {
        String response = null;
        Email emailObj = null;
        Util.throwExceptionIfNullOrBlank(emailHost, "Host");
        Util.throwExceptionIfNullOrBlank(mailId, "Email Id");
        Util.throwExceptionIfNullOrBlank(emailPassword, "Password");
        Util.throwExceptionIfEmailNotValid(mailId, "EmailAddress");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            JSONObject obj = new JSONObject();
            obj.put("host", emailHost);
            obj.put("port", emailPort);
            obj.put("emailId", mailId);
            obj.put("password", emailPassword);
            obj.put("ssl", isSSL);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"email\":").append(obj.toString()).append("}}");
            App42Log.debug(" Json String : " + sb.toString());
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/configuration";
            response = RESTConnectorAsync.getInstance().executePost(resourceURL, queryParams, sb.toString(), headerParams);
            emailObj = new EmailResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return emailObj;
    }

    public void createMailConfiguration(final String emailHost, final int emailPort, final String mailId, final String emailPassword, final boolean isSSL, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Email email = EmailService.this.createMailConfiguration(emailHost, emailPort, mailId, emailPassword, isSSL);
                    callBack.onSuccess(email);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public App42Response removeEmailConfiguration(String emailId) throws App42Exception {
        String response = null;
        App42Response responseObj = new App42Response();
        Util.throwExceptionIfNullOrBlank(emailId, "Email Id");
        Util.throwExceptionIfEmailNotValid(emailId, "EmailAddress");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("emailId", emailId);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/configuration" + "/" + emailId;
            response = RESTConnectorAsync.getInstance().executeDelete(resourceURL, queryParams, headerParams);
            responseObj.setStrResponse(response);
            responseObj.setResponseSuccess(true);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return responseObj;
    }

    public void removeEmailConfiguration(final String emailId, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    App42Response email = EmailService.this.removeEmailConfiguration(emailId);
                    callBack.onSuccess(email);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Email getEmailConfigurations() throws App42Exception {
        String response = null;
        Email emailObj = null;
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/configuration";
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            emailObj = new EmailResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return emailObj;
    }

    public void getEmailConfigurations(final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Email email = EmailService.this.getEmailConfigurations();
                    callBack.onSuccess(email);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Email sendMail(String sendTo, String sendSubject, String sendMsg, String fromEmail, String emailMime) throws App42Exception {
        String response = null;
        Email emailObj = null;
        Util.throwExceptionIfNullOrBlank(sendTo, "Send To");
        Util.throwExceptionIfNullOrBlank(sendSubject, "Send Subject");
        Util.throwExceptionIfNullOrBlank(sendMsg, "Send Message");
        Util.throwExceptionIfNullOrBlank(fromEmail, "From Email");
        Util.throwExceptionIfNullOrBlank(emailMime, "emailMime");
        Util.throwExceptionIfEmailNotValid(fromEmail, "fromEmail");
        Util.throwExceptionIfEmailNotValid(sendTo, "sendTo");
        EmailMIME.throwExceptionIfNotValid(emailMime);
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            JSONObject obj = new JSONObject();
            obj.put("to", sendTo);
            obj.put("subject", sendSubject);
            obj.put("msg", sendMsg);
            obj.put("emailId", fromEmail);
            obj.put("mimeType", emailMime);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"email\":").append(obj.toString()).append("}}");
            App42Log.debug(" Json String : " + sb.toString());
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource;
            response = RESTConnectorAsync.getInstance().executePost(resourceURL, queryParams, sb.toString(), headerParams);
            emailObj = new EmailResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return emailObj;
    }

    public void sendMail(final String sendTo, final String sendSubject, final String sendMsg, final String fromEmail, final String emailMime, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Email email = EmailService.this.sendMail(sendTo, sendSubject, sendMsg, fromEmail, emailMime);
                    callBack.onSuccess(email);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }
}

