/*
 * Decompiled with CFR 0.152.
 */
package com.shephertz.app42.paas.sdk.jme.imageProcessor;

import com.shephertz.app42.paas.sdk.jme.App42CallBack;
import com.shephertz.app42.paas.sdk.jme.App42Exception;
import com.shephertz.app42.paas.sdk.jme.App42Log;
import com.shephertz.app42.paas.sdk.jme.App42Service;
import com.shephertz.app42.paas.sdk.jme.Config;
import com.shephertz.app42.paas.sdk.jme.imageProcessor.Image;
import com.shephertz.app42.paas.sdk.jme.imageProcessor.ImageProcessResponseBuilder;
import com.shephertz.app42.paas.sdk.jme.util.Util;
import java.io.InputStream;
import java.util.Hashtable;

public class ImageProcessorService
extends App42Service {
    private String resource = "image";
    String baseURL;

    public ImageProcessorService(String apiKey, String secretKey, String baseURL) {
        this.apiKey = apiKey;
        this.secretKey = secretKey;
        this.baseURL = baseURL;
        this.version = "1.0";
    }

    public Image resize(String name, InputStream imageIS, Integer width, Integer height) throws App42Exception {
        String response = null;
        Image imageObj = null;
        Util.throwExceptionIfNullOrBlank(name, "Name");
        Util.throwExceptionIfNullOrBlank(imageIS, "Image Input Stream");
        Util.throwExceptionIfNullOrBlank(width, "Width");
        Util.throwExceptionIfNullOrBlank(height, "Height");
        Util.throwExceptionIfNotValidImageExtension(name, "Name");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            Hashtable<String, String> postParams = new Hashtable<String, String>();
            postParams.put("name", name);
            postParams.put("width", width + "");
            postParams.put("height", height + "");
            signParams = net.oauth.jme.Util.hashtableMerge(signParams, postParams);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceUrl = Config.getInstance().getBaseURL() + this.version + "/" + this.resource + "/resize";
            response = Util.multiPartRequest("imageFile", imageIS, name, queryParams, postParams, headerParams, resourceUrl, Config.getInstance().getAccept());
            imageObj = new ImageProcessResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return imageObj;
    }

    public void resize(final String name, final InputStream imageIS, final Integer width, final Integer height, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Image image = ImageProcessorService.this.resize(name, imageIS, width, height);
                    callBack.onSuccess(image);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Image thumbnail(String name, InputStream imageIS, Integer width, Integer height) throws App42Exception {
        String response = null;
        Image imageObj = null;
        Util.throwExceptionIfNullOrBlank(name, "Name");
        Util.throwExceptionIfNullOrBlank(imageIS, "Image Input Stream");
        Util.throwExceptionIfNullOrBlank(width, "Width");
        Util.throwExceptionIfNullOrBlank(height, "Height");
        Util.throwExceptionIfNotValidImageExtension(name, "Name");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            Hashtable<String, String> postParams = new Hashtable<String, String>();
            postParams.put("name", name);
            postParams.put("width", width + "");
            postParams.put("height", height + "");
            signParams = net.oauth.jme.Util.hashtableMerge(signParams, postParams);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceUrl = Config.getInstance().getBaseURL() + this.version + "/" + this.resource + "/thumbnail";
            response = Util.multiPartRequest("imageFile", imageIS, name, queryParams, postParams, headerParams, resourceUrl, Config.getInstance().getAccept());
            imageObj = new ImageProcessResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return imageObj;
    }

    public void thumbnail(final String name, final InputStream imageIS, final Integer width, final Integer height, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Image image = ImageProcessorService.this.thumbnail(name, imageIS, width, height);
                    callBack.onSuccess(image);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Image scale(String name, InputStream imageIS, Integer width, Integer height) throws App42Exception {
        String response = null;
        Image imageObj = null;
        Util.throwExceptionIfNullOrBlank(name, "Name");
        Util.throwExceptionIfNullOrBlank(imageIS, "Image Input Stream");
        Util.throwExceptionIfNullOrBlank(width, "Width");
        Util.throwExceptionIfNullOrBlank(height, "Height");
        Util.throwExceptionIfNotValidImageExtension(name, "Name");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            Hashtable<String, String> postParams = new Hashtable<String, String>();
            postParams.put("name", name);
            postParams.put("width", width + "");
            postParams.put("height", height + "");
            signParams = net.oauth.jme.Util.hashtableMerge(signParams, postParams);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceUrl = Config.getInstance().getBaseURL() + this.version + "/" + this.resource + "/scale";
            response = Util.multiPartRequest("imageFile", imageIS, name, queryParams, postParams, headerParams, resourceUrl, Config.getInstance().getAccept());
            imageObj = new ImageProcessResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return imageObj;
    }

    public void scale(final String name, final InputStream imageIS, final Integer width, final Integer height, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Image image = ImageProcessorService.this.scale(name, imageIS, width, height);
                    callBack.onSuccess(image);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Image crop(String name, InputStream imageIS, Integer width, Integer height, Integer x, Integer y) throws App42Exception {
        String response = null;
        Image imageObj = null;
        Util.throwExceptionIfNullOrBlank(name, "Name");
        Util.throwExceptionIfNullOrBlank(imageIS, "Image Input Stream");
        Util.throwExceptionIfNullOrBlank(width, "Width");
        Util.throwExceptionIfNullOrBlank(height, "Height");
        Util.throwExceptionIfNullOrBlank(x, "x");
        Util.throwExceptionIfNullOrBlank(y, "y");
        Util.throwExceptionIfNotValidImageExtension(name, "Name");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            Hashtable<String, String> postParams = new Hashtable<String, String>();
            postParams.put("name", name);
            postParams.put("width", width + "");
            postParams.put("height", height + "");
            postParams.put("x", x + "");
            postParams.put("y", y + "");
            signParams = net.oauth.jme.Util.hashtableMerge(signParams, postParams);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceUrl = Config.getInstance().getBaseURL() + this.version + "/" + this.resource + "/crop";
            response = Util.multiPartRequest("imageFile", imageIS, name, queryParams, postParams, headerParams, resourceUrl, Config.getInstance().getAccept());
            imageObj = new ImageProcessResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return imageObj;
    }

    public void crop(final String name, final InputStream imageIS, final Integer width, final Integer height, final Integer x, final Integer y, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Image image = ImageProcessorService.this.crop(name, imageIS, width, height, x, y);
                    callBack.onSuccess(image);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Image resizeByPercentage(String name, InputStream imageIS, Double percentage) throws App42Exception {
        String response = null;
        Image imageObj = null;
        Util.throwExceptionIfNullOrBlank(name, "Name");
        Util.throwExceptionIfNullOrBlank(imageIS, "Image Input Stream");
        Util.throwExceptionIfNullOrBlank(percentage, "Percentage");
        Util.throwExceptionIfNotValidImageExtension(name, "Name");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            Hashtable<String, String> postParams = new Hashtable<String, String>();
            postParams.put("name", name);
            postParams.put("percentage", percentage + "");
            signParams = net.oauth.jme.Util.hashtableMerge(signParams, postParams);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceUrl = Config.getInstance().getBaseURL() + this.version + "/" + this.resource + "/resizePercentage";
            response = Util.multiPartRequest("imageFile", imageIS, name, queryParams, postParams, headerParams, resourceUrl, Config.getInstance().getAccept());
            imageObj = new ImageProcessResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return imageObj;
    }

    public void resizeByPercentage(final String name, final InputStream imageIS, final Double percentage, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Image image = ImageProcessorService.this.resizeByPercentage(name, imageIS, percentage);
                    callBack.onSuccess(image);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Image thumbnailByPercentage(String name, InputStream imageIS, Double percentage) throws App42Exception {
        String response = null;
        Image imageObj = null;
        Util.throwExceptionIfNullOrBlank(name, "Name");
        Util.throwExceptionIfNullOrBlank(imageIS, "Image Input Stream");
        Util.throwExceptionIfNullOrBlank(percentage, "Percentage");
        Util.throwExceptionIfNotValidImageExtension(name, "Name");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            Hashtable<String, String> postParams = new Hashtable<String, String>();
            postParams.put("name", name);
            postParams.put("percentage", percentage + "");
            signParams = net.oauth.jme.Util.hashtableMerge(signParams, postParams);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceUrl = Config.getInstance().getBaseURL() + this.version + "/" + this.resource + "/thumbnailPercentage";
            response = Util.multiPartRequest("imageFile", imageIS, name, queryParams, postParams, headerParams, resourceUrl, Config.getInstance().getAccept());
            imageObj = new ImageProcessResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return imageObj;
    }

    public void thumbnailByPercentage(final String name, final InputStream imageIS, final Double percentage, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Image image = ImageProcessorService.this.thumbnailByPercentage(name, imageIS, percentage);
                    callBack.onSuccess(image);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Image scaleByPercentage(String name, InputStream imageIS, Double percentage) throws App42Exception {
        String response = null;
        Image imageObj = null;
        Util.throwExceptionIfNullOrBlank(name, "Name");
        Util.throwExceptionIfNullOrBlank(imageIS, "Image Input Stream");
        Util.throwExceptionIfNullOrBlank(percentage, "Percentage");
        Util.throwExceptionIfNotValidImageExtension(name, "Name");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            Hashtable<String, String> postParams = new Hashtable<String, String>();
            postParams.put("name", name);
            postParams.put("percentage", percentage + "");
            signParams = net.oauth.jme.Util.hashtableMerge(signParams, postParams);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceUrl = Config.getInstance().getBaseURL() + this.version + "/" + this.resource + "/scalePercentage";
            response = Util.multiPartRequest("imageFile", imageIS, name, queryParams, postParams, headerParams, resourceUrl, Config.getInstance().getAccept());
            imageObj = new ImageProcessResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return imageObj;
    }

    public void scaleByPercentage(final String name, final InputStream imageIS, final Double percentage, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Image image = ImageProcessorService.this.scaleByPercentage(name, imageIS, percentage);
                    callBack.onSuccess(image);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Image convertFormat(String name, InputStream imageIS, String formatToConvert) throws App42Exception {
        String response = null;
        Image imageObj = null;
        Util.throwExceptionIfNullOrBlank(name, "Name");
        Util.throwExceptionIfNullOrBlank(imageIS, "Image Input Stream");
        Util.throwExceptionIfNullOrBlank(formatToConvert, "FormatToConvert");
        Util.throwExceptionIfNotValidImageExtension(name, "Name");
        try {
            if (!(formatToConvert.equalsIgnoreCase("jpg") || formatToConvert.equalsIgnoreCase("jpeg") || formatToConvert.equalsIgnoreCase("gif") || formatToConvert.equalsIgnoreCase("png"))) {
                throw new IllegalArgumentException("The Request parameters are invalid. Supported conversion extensions are jpg, jpeg, gif and png only");
            }
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            Hashtable<String, String> postParams = new Hashtable<String, String>();
            postParams.put("name", name);
            postParams.put("formatToConvert", formatToConvert);
            signParams = net.oauth.jme.Util.hashtableMerge(signParams, postParams);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceUrl = Config.getInstance().getBaseURL() + this.version + "/" + this.resource + "/convertformat";
            response = Util.multiPartRequest("imageFile", imageIS, name, queryParams, postParams, headerParams, resourceUrl, Config.getInstance().getAccept());
            imageObj = new ImageProcessResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return imageObj;
    }

    public void convertFormat(final String name, final InputStream imageIS, final String formatToConvert, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Image image = ImageProcessorService.this.convertFormat(name, imageIS, formatToConvert);
                    callBack.onSuccess(image);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }
}

