/*
 * Decompiled with CFR 0.152.
 */
package com.shephertz.app42.paas.sdk.jme.message;

import com.shephertz.app42.paas.sdk.jme.App42CallBack;
import com.shephertz.app42.paas.sdk.jme.App42Exception;
import com.shephertz.app42.paas.sdk.jme.App42Log;
import com.shephertz.app42.paas.sdk.jme.App42Response;
import com.shephertz.app42.paas.sdk.jme.App42Service;
import com.shephertz.app42.paas.sdk.jme.connection.RESTConnectorAsync;
import com.shephertz.app42.paas.sdk.jme.message.Queue;
import com.shephertz.app42.paas.sdk.jme.message.QueueResponseBuilder;
import com.shephertz.app42.paas.sdk.jme.util.Util;
import java.util.Hashtable;
import org.json.jme.JSONObject;

public class QueueService
extends App42Service {
    private String resource = "queue";
    private String messageResource = "message";

    public QueueService(String apiKey, String secretKey, String baseURL) {
        this.apiKey = apiKey;
        this.secretKey = secretKey;
        this.version = "1.0";
    }

    public Queue createPullQueue(String queueName, String queueDescription) throws App42Exception {
        String response = null;
        Queue queue = null;
        Util.throwExceptionIfNullOrBlank(queueName, "Queue Name");
        Util.throwExceptionIfNullOrBlank(queueDescription, "Queue Description");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("type", "pull");
            JSONObject obj = new JSONObject();
            obj.put("name", queueName);
            obj.put("description", queueDescription);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"queue\":").append(obj.toString()).append("}}");
            App42Log.debug(" Json String : " + sb.toString());
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/pull";
            response = RESTConnectorAsync.getInstance().executePost(resourceURL, queryParams, sb.toString(), headerParams);
            queue = new QueueResponseBuilder().buildRespoonse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return queue;
    }

    public void createPullQueue(final String queueName, final String queueDescription, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Queue queue = QueueService.this.createPullQueue(queueName, queueDescription);
                    callBack.onSuccess(queue);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public App42Response deletePullQueue(String queueName) throws App42Exception {
        String response = null;
        App42Response responseObj = new App42Response();
        Util.throwExceptionIfNullOrBlank(queueName, "Queue Name");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("type", "pull");
            signParams.put("queueName", queueName);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/pull" + "/" + queueName;
            response = RESTConnectorAsync.getInstance().executeDelete(resourceURL, queryParams, headerParams);
            responseObj.setStrResponse(response);
            responseObj.setResponseSuccess(true);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return responseObj;
    }

    public void deletePullQueue(final String queueName, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    App42Response queue = QueueService.this.deletePullQueue(queueName);
                    callBack.onSuccess(queue);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public App42Response purgePullQueue(String queueName) throws App42Exception {
        String response = null;
        App42Response responseObj = new App42Response();
        Util.throwExceptionIfNullOrBlank(queueName, "Queue Name");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("queueName", queueName);
            signParams.put("type", "pull");
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/pull" + "/purge" + "/" + queueName;
            response = RESTConnectorAsync.getInstance().executeDelete(resourceURL, queryParams, headerParams);
            responseObj.setStrResponse(response);
            responseObj.setResponseSuccess(true);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return responseObj;
    }

    public void purgePullQueue(final String queueName, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    App42Response queue = QueueService.this.purgePullQueue(queueName);
                    callBack.onSuccess(queue);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Queue pendingMessages(String queueName) throws App42Exception {
        String response = null;
        Queue queue = null;
        Util.throwExceptionIfNullOrBlank(queueName, "Queue Name");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("queueName", queueName);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/pending" + "/" + queueName;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            queue = new QueueResponseBuilder().buildRespoonse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return queue;
    }

    public void pendingMessages(final String queueName, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Queue queue = QueueService.this.pendingMessages(queueName);
                    callBack.onSuccess(queue);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Queue getMessages(String queueName, long receiveTimeOut) throws App42Exception {
        String response = null;
        Queue queue = null;
        Util.throwExceptionIfNullOrBlank(queueName, "Queue Name");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("queueName", queueName);
            signParams.put("receiveTimeOut", "" + receiveTimeOut);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/messages" + "/" + queueName + "/" + receiveTimeOut;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            queue = new QueueResponseBuilder().buildRespoonse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return queue;
    }

    public void getMessages(final String queueName, final long receiveTimeOut, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Queue queue = QueueService.this.getMessages(queueName, receiveTimeOut);
                    callBack.onSuccess(queue);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Queue sendMessage(String queueName, String msg, long exp) throws App42Exception {
        String response = null;
        Queue queue = null;
        Util.throwExceptionIfNullOrBlank(queueName, "Queue Name");
        Util.throwExceptionIfNullOrBlank(msg, "Message");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("queueName", queueName);
            JSONObject obj = new JSONObject();
            obj.put("message", msg);
            obj.put("expiration", exp);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"payLoad\":").append(obj.toString()).append("}}");
            App42Log.debug(" Json String : " + sb.toString());
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.messageResource + "/" + queueName;
            response = RESTConnectorAsync.getInstance().executePost(resourceURL, queryParams, sb.toString(), headerParams);
            queue = new QueueResponseBuilder().buildRespoonse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return queue;
    }

    public void sendMessage(final String queueName, final String msg, final long exp, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Queue queue = QueueService.this.sendMessage(queueName, msg, exp);
                    callBack.onSuccess(queue);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Queue receiveMessage(String queueName, long receiveTimeOut) throws App42Exception {
        String response = null;
        Queue queue = null;
        Util.throwExceptionIfNullOrBlank(queueName, "Queue Name");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("queueName", queueName);
            signParams.put("receiveTimeOut", "" + receiveTimeOut);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.messageResource + "/" + queueName + "/" + receiveTimeOut;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            queue = new QueueResponseBuilder().buildRespoonse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return queue;
    }

    public void receiveMessage(final String queueName, final long receiveTimeOut, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Queue queue = QueueService.this.receiveMessage(queueName, receiveTimeOut);
                    callBack.onSuccess(queue);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Queue receiveMessageByCorrelationId(String queueName, long receiveTimeOut, String correlationId) throws App42Exception {
        String response = null;
        Queue queue = null;
        Util.throwExceptionIfNullOrBlank(queueName, "Queue Name");
        Util.throwExceptionIfNullOrBlank(correlationId, "Correlation Id");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("queueName", queueName);
            signParams.put("receiveTimeOut", "" + receiveTimeOut);
            signParams.put("correlationId", "" + correlationId);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.messageResource + "/" + queueName + "/" + receiveTimeOut + "/" + correlationId;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            queue = new QueueResponseBuilder().buildRespoonse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return queue;
    }

    public void receiveMessageByCorrelationId(final String queueName, final long receiveTimeOut, final String correlationId, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Queue queue = QueueService.this.receiveMessageByCorrelationId(queueName, receiveTimeOut, correlationId);
                    callBack.onSuccess(queue);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public App42Response removeMessage(String queueName, String messageId) throws App42Exception {
        String response = null;
        App42Response responseObj = new App42Response();
        Util.throwExceptionIfNullOrBlank(queueName, "Queue Name");
        Util.throwExceptionIfNullOrBlank(messageId, "Message Id");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("queueName", queueName);
            signParams.put("messageId", messageId);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.messageResource + "/" + queueName + "/" + messageId;
            response = RESTConnectorAsync.getInstance().executeDelete(resourceURL, queryParams, headerParams);
            responseObj.setStrResponse(response);
            responseObj.setResponseSuccess(true);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return responseObj;
    }

    public void removeMessage(final String queueName, final String messageId, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    App42Response queue = QueueService.this.removeMessage(queueName, messageId);
                    callBack.onSuccess(queue);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }
}

