/*
 * Decompiled with CFR 0.152.
 */
package com.shephertz.app42.paas.sdk.jme.recommend;

import com.shephertz.app42.paas.sdk.jme.App42CallBack;
import com.shephertz.app42.paas.sdk.jme.App42Exception;
import com.shephertz.app42.paas.sdk.jme.App42Log;
import com.shephertz.app42.paas.sdk.jme.App42Response;
import com.shephertz.app42.paas.sdk.jme.App42Service;
import com.shephertz.app42.paas.sdk.jme.Config;
import com.shephertz.app42.paas.sdk.jme.connection.RESTConnectorAsync;
import com.shephertz.app42.paas.sdk.jme.recommend.PreferenceData;
import com.shephertz.app42.paas.sdk.jme.recommend.Recommender;
import com.shephertz.app42.paas.sdk.jme.recommend.RecommenderResponseBuilder;
import com.shephertz.app42.paas.sdk.jme.recommend.RecommenderSimilarity;
import com.shephertz.app42.paas.sdk.jme.util.Util;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import org.json.jme.JSONArray;
import org.json.jme.JSONObject;

public class RecommenderService
extends App42Service {
    private String resource = "recommend";
    private String baseURL;

    public RecommenderService(String apiKey, String secretKey, String baseURL) {
        this.apiKey = apiKey;
        this.secretKey = secretKey;
        this.baseURL = baseURL;
        this.version = "1.0";
    }

    public App42Response loadPreferenceFile(InputStream preferenceFileIS) throws App42Exception {
        String response = null;
        Object recommneder = null;
        Util.throwExceptionIfNullOrBlank(preferenceFileIS, "PreferenceFileStream");
        App42Response responseObj = new App42Response();
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            Hashtable postParams = new Hashtable();
            signParams = net.oauth.jme.Util.hashtableMerge(signParams, postParams);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceUrl = Config.getInstance().getBaseURL() + this.version + "/" + this.resource;
            response = Util.multiPartRequest("preferenceFile", preferenceFileIS, "", queryParams, postParams, headerParams, resourceUrl, Config.getInstance().getAccept());
            responseObj.setResponseSuccess(true);
            responseObj.setStrResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return responseObj;
    }

    public void loadPreferenceFile(final InputStream preferenceFileIS, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    App42Response preference = RecommenderService.this.loadPreferenceFile(preferenceFileIS);
                    callBack.onSuccess(preference);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public App42Response addOrUpdatePreference(Vector preferenceDataList) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(preferenceDataList, "preferenceDataList");
        String response = null;
        App42Response responseObj = new App42Response();
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            JSONArray preferenceDataArray = new JSONArray();
            JSONObject obj = new JSONObject();
            for (int i = 0; i < preferenceDataList.size(); ++i) {
                JSONObject obj1 = new JSONObject();
                PreferenceData preferenceData = (PreferenceData)preferenceDataList.elementAt(i);
                obj1.put("userId", preferenceData.getUserId());
                obj1.put("itemId", preferenceData.getItemId());
                obj1.put("preference", preferenceData.getPreference());
                preferenceDataArray.put(obj1.toString());
            }
            JSONObject preference = new JSONObject();
            preference.put("preference", preferenceDataArray);
            obj.put("preferences", preference);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":").append(obj.toString()).append("}}");
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + "addOrUpdatePreference";
            response = RESTConnectorAsync.getInstance().executePost(resourceURL, queryParams, sb.toString(), headerParams);
            responseObj.setStrResponse(response);
            responseObj.setResponseSuccess(true);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return responseObj;
    }

    public void addOrUpdatePreference(final Vector preferenceDataList, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    App42Response preference = RecommenderService.this.addOrUpdatePreference(preferenceDataList);
                    callBack.onSuccess(preference);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Recommender userBasedNeighborhood(long userId, int size, int howMany) throws App42Exception {
        String response = null;
        Recommender recommneder = null;
        Util.throwExceptionIfHowManyNotValid(howMany, "howMany");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("userId", "" + userId);
            signParams.put("size", "" + size);
            signParams.put("howMany", "" + howMany);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/userBasedNeighborhood" + "/" + userId + "/" + size + "/" + howMany;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            recommneder = new RecommenderResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return recommneder;
    }

    public void userBasedNeighborhood(final long userId, final int size, final int howMany, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Recommender recommender = RecommenderService.this.userBasedNeighborhood(userId, size, howMany);
                    callBack.onSuccess(recommender);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Recommender userBasedThreshold(long userId, double threshold, int howMany) throws App42Exception {
        String response = null;
        Recommender recommneder = null;
        Util.throwExceptionIfHowManyNotValid(howMany, "howMany");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("userId", "" + userId);
            signParams.put("threshold", "" + threshold);
            signParams.put("howMany", "" + howMany);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/userBasedThreshold" + "/" + userId + "/" + threshold + "/" + howMany;
            App42Log.debug("Before  Response is " + response);
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            recommneder = new RecommenderResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new App42Exception(e);
        }
        return recommneder;
    }

    public void userBasedThreshold(final long userId, final double threshold, final int howMany, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Recommender recommender = RecommenderService.this.userBasedThreshold(userId, threshold, howMany);
                    callBack.onSuccess(recommender);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Recommender userBasedNeighborhoodBySimilarity(String recommenderSimilarity, long userId, int size, int howMany) throws App42Exception {
        String response = null;
        Recommender recommneder = null;
        Util.throwExceptionIfNullOrBlank(recommenderSimilarity, "recommenderSimilarity");
        RecommenderSimilarity.throwExceptionIfNotValid(recommenderSimilarity);
        Util.throwExceptionIfHowManyNotValid(howMany, "howMany");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("userId", "" + userId);
            signParams.put("similarity", "" + recommenderSimilarity);
            signParams.put("howMany", "" + howMany);
            signParams.put("size", "" + size);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/userBasedNeighborhood" + "/" + recommenderSimilarity + "/" + userId + "/" + size + "/" + howMany;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            recommneder = new RecommenderResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return recommneder;
    }

    public void userBasedNeighborhoodBySimilarity(final String recommenderSimilarity, final long userId, final int size, final int howMany, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Recommender recommender = RecommenderService.this.userBasedNeighborhoodBySimilarity(recommenderSimilarity, userId, size, howMany);
                    callBack.onSuccess(recommender);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Recommender userBasedThresholdBySimilarity(String recommenderSimilarity, long userId, double threshold, int howMany) throws App42Exception {
        String response = null;
        Recommender recommneder = null;
        Util.throwExceptionIfHowManyNotValid(howMany, "howMany");
        Util.throwExceptionIfNullOrBlank(recommenderSimilarity, "recommenderSimilarity");
        RecommenderSimilarity.throwExceptionIfNotValid(recommenderSimilarity);
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("userId", "" + userId);
            signParams.put("similarity", "" + recommenderSimilarity);
            signParams.put("threshold", "" + threshold);
            signParams.put("howMany", "" + howMany);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/userBasedThreshold" + "/" + recommenderSimilarity + "/" + userId + "/" + threshold + "/" + howMany;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            recommneder = new RecommenderResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return recommneder;
    }

    public void userBasedThresholdBySimilarity(final String recommenderSimilarity, final long userId, final double threshold, final int howMany, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Recommender recommender = RecommenderService.this.userBasedThresholdBySimilarity(recommenderSimilarity, userId, threshold, howMany);
                    callBack.onSuccess(recommender);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Recommender itemBased(long userId, int howMany) throws App42Exception {
        String response = null;
        Recommender recommneder = null;
        Util.throwExceptionIfHowManyNotValid(howMany, "howMany");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("userId", "" + userId);
            signParams.put("howMany", "" + howMany);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/itemBased" + "/" + userId + "/" + howMany;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            recommneder = new RecommenderResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return recommneder;
    }

    public void itemBased(final long userId, final int howMany, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Recommender recommender = RecommenderService.this.itemBased(userId, howMany);
                    callBack.onSuccess(recommender);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Recommender slopeOne(long userId, int howMany) throws App42Exception {
        String response = null;
        Recommender recommneder = null;
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("userId", "" + userId);
            signParams.put("howMany", "" + howMany);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/slopeOne" + "/" + userId + "/" + howMany;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            recommneder = new RecommenderResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return recommneder;
    }

    public void slopeOne(final long userId, final int howMany, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Recommender recommender = RecommenderService.this.slopeOne(userId, howMany);
                    callBack.onSuccess(recommender);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Recommender userBasedThresholdForAll(double threshold, int howMany) throws App42Exception {
        String response = null;
        Recommender recommneder = null;
        Util.throwExceptionIfHowManyNotValid(howMany, "howMany");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("threshold", "" + threshold);
            signParams.put("howMany", "" + howMany);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/userBasedThreshold" + "/all" + "/" + threshold + "/" + howMany;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            recommneder = new RecommenderResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return recommneder;
    }

    public void userBasedThresholdForAll(final double threshold, final int howMany, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Recommender recommender = RecommenderService.this.userBasedThresholdForAll(threshold, howMany);
                    callBack.onSuccess(recommender);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Recommender userBasedNeighborhoodBySimilarityForAll(String recommenderSimilarity, int size, int howMany) throws App42Exception {
        String response = null;
        Recommender recommneder = null;
        Util.throwExceptionIfNullOrBlank(recommenderSimilarity, "recommenderSimilarity");
        RecommenderSimilarity.throwExceptionIfNotValid(recommenderSimilarity);
        Util.throwExceptionIfHowManyNotValid(howMany, "howMany");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("size", "" + size);
            signParams.put("howMany", "" + howMany);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + "userBasedNeighborhood" + "/all" + "/" + size + "/" + howMany;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            recommneder = new RecommenderResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return recommneder;
    }

    public void userBasedNeighborhoodBySimilarityForAll(final String recommenderSimilarity, final int size, final int howMany, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Recommender recommender = RecommenderService.this.userBasedNeighborhoodBySimilarityForAll(recommenderSimilarity, size, howMany);
                    callBack.onSuccess(recommender);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Recommender userBasedThresholdBySimilarityForAll(String recommenderSimilarity, double threshold, int howMany) throws App42Exception {
        String response = null;
        Recommender recommneder = null;
        Util.throwExceptionIfNullOrBlank(recommenderSimilarity, "recommenderSimilarity");
        RecommenderSimilarity.throwExceptionIfNotValid(recommenderSimilarity);
        Util.throwExceptionIfHowManyNotValid(howMany, "howMany");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("threshold", "" + threshold);
            signParams.put("howMany", "" + howMany);
            signParams.put("similarity", "" + recommenderSimilarity);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/userBasedThreshold" + "/all" + "/" + recommenderSimilarity + "/" + threshold + "/" + howMany;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            recommneder = new RecommenderResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return recommneder;
    }

    public void userBasedThresholdBySimilarityForAll(final String recommenderSimilarity, final double threshold, final int howMany, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Recommender recommender = RecommenderService.this.userBasedThresholdBySimilarityForAll(recommenderSimilarity, threshold, howMany);
                    callBack.onSuccess(recommender);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Recommender itemBasedForAll(int howMany) throws App42Exception {
        String response = null;
        Recommender recommneder = null;
        Util.throwExceptionIfHowManyNotValid(howMany, "howMany");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("howMany", "" + howMany);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + "itemBased" + "/all" + "/" + howMany;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            recommneder = new RecommenderResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return recommneder;
    }

    public void itemBasedForAll(final int howMany, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Recommender recommender = RecommenderService.this.itemBasedForAll(howMany);
                    callBack.onSuccess(recommender);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Recommender itemBasedBySimilarityForAll(String recommenderSimilarity, int howMany) throws App42Exception {
        String response = null;
        Recommender recommneder = null;
        Util.throwExceptionIfNullOrBlank(recommenderSimilarity, "recommenderSimilarity");
        RecommenderSimilarity.throwExceptionIfNotValid(recommenderSimilarity);
        Util.throwExceptionIfHowManyNotValid(howMany, "howMany");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("howMany", "" + howMany);
            signParams.put("similarity", recommenderSimilarity);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + "itemBased" + "/all" + "/" + recommenderSimilarity + "/" + howMany;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            recommneder = new RecommenderResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return recommneder;
    }

    public void itemBasedBySimilarityForAll(final String recommenderSimilarity, final int howMany, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Recommender recommender = RecommenderService.this.itemBasedBySimilarityForAll(recommenderSimilarity, howMany);
                    callBack.onSuccess(recommender);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Recommender slopeOneForAll(int howMany) throws App42Exception {
        String response = null;
        Recommender recommneder = null;
        Util.throwExceptionIfHowManyNotValid(howMany, "howMany");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("howMany", "" + howMany);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/slopeOne" + "/all" + "/" + howMany;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            recommneder = new RecommenderResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return recommneder;
    }

    public void slopeOneForAll(final int howMany, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Recommender recommender = RecommenderService.this.slopeOneForAll(howMany);
                    callBack.onSuccess(recommender);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Recommender itemBasedBySimilarity(String recommenderSimilarity, long userId, int howMany) throws App42Exception {
        String response = null;
        Recommender recommneder = null;
        Util.throwExceptionIfNullOrBlank(recommenderSimilarity, "recommenderSimilarity");
        RecommenderSimilarity.throwExceptionIfNotValid(recommenderSimilarity);
        Util.throwExceptionIfHowManyNotValid(howMany, "howMany");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("howMany", "" + howMany);
            signParams.put("userId", "" + userId);
            signParams.put("similarity", recommenderSimilarity);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/itemBased/" + recommenderSimilarity + "/" + userId + "/" + howMany;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            recommneder = new RecommenderResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return recommneder;
    }

    public void itemBasedBySimilarity(final String recommenderSimilarity, final long userId, final int howMany, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Recommender recommender = RecommenderService.this.itemBasedBySimilarity(recommenderSimilarity, userId, howMany);
                    callBack.onSuccess(recommender);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Recommender userBasedNeighborhoodForAll(int size, int howMany) throws App42Exception {
        String response = null;
        Recommender recommneder = null;
        Util.throwExceptionIfHowManyNotValid(howMany, "howMany");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("howMany", "" + howMany);
            signParams.put("size", "" + size);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/userBasedNeighborhood" + "/all" + "/" + size + "/" + howMany;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            recommneder = new RecommenderResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return recommneder;
    }

    public void userBasedNeighborhoodForAll(final int size, final int howMany, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Recommender recommender = RecommenderService.this.userBasedNeighborhoodForAll(size, howMany);
                    callBack.onSuccess(recommender);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public App42Response deleteAllPreferences() throws App42Exception {
        String response = null;
        App42Response responseObj = new App42Response();
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/deleteAllPreferences";
            response = RESTConnectorAsync.getInstance().executeDelete(resourceURL, queryParams, headerParams);
            responseObj.setStrResponse(response);
            responseObj.setResponseSuccess(true);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return responseObj;
    }

    public void deleteAllPreferences(final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    App42Response recommender = RecommenderService.this.deleteAllPreferences();
                    callBack.onSuccess(recommender);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }
}

