/*
 * Decompiled with CFR 0.152.
 */
package com.shephertz.app42.paas.sdk.jme.shopping;

import com.shephertz.app42.paas.sdk.jme.App42CallBack;
import com.shephertz.app42.paas.sdk.jme.App42Exception;
import com.shephertz.app42.paas.sdk.jme.App42Log;
import com.shephertz.app42.paas.sdk.jme.App42Response;
import com.shephertz.app42.paas.sdk.jme.App42Service;
import com.shephertz.app42.paas.sdk.jme.Config;
import com.shephertz.app42.paas.sdk.jme.connection.RESTConnectorAsync;
import com.shephertz.app42.paas.sdk.jme.shopping.Cart;
import com.shephertz.app42.paas.sdk.jme.shopping.CartResponseBuilder;
import com.shephertz.app42.paas.sdk.jme.shopping.PaymentStatus;
import com.shephertz.app42.paas.sdk.jme.util.Util;
import java.util.Hashtable;
import java.util.Vector;
import org.json.jme.JSONObject;

public class CartService
extends App42Service {
    Config config = Config.getInstance();
    private String resource = "cart";
    String baseURL;

    public CartService(String apiKey, String secretKey, String baseURL) {
        this.apiKey = apiKey;
        this.secretKey = secretKey;
        this.baseURL = baseURL;
        this.version = "1.0";
    }

    public Cart createCart(String user) throws App42Exception {
        String response = null;
        Cart cart = null;
        Util.throwExceptionIfNullOrBlank(user, "User");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            JSONObject obj = new JSONObject();
            obj.put("userName", user);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"cart\":").append(obj.toString()).append("}}");
            App42Log.debug(" Json String : " + sb.toString());
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource;
            response = RESTConnectorAsync.getInstance().executePost(resourceURL, queryParams, sb.toString(), headerParams);
            cart = new CartResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return cart;
    }

    public void createCart(final String user, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Cart cart = CartService.this.createCart(user);
                    callBack.onSuccess(cart);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Cart getCartDetails(String cartId) throws App42Exception {
        String response = null;
        Cart cart = null;
        Util.throwExceptionIfNullOrBlank(cartId, "CartId");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("cartId", cartId);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + cartId + "/details";
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            cart = new CartResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return cart;
    }

    public void getCartDetails(final String cartId, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Cart cart = CartService.this.getCartDetails(cartId);
                    callBack.onSuccess(cart);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Cart addItem(String cartID, String itemID, int itemQuantity, double price) throws App42Exception {
        String response = null;
        Cart cart = null;
        Util.throwExceptionIfNullOrBlank(cartID, "CartID");
        Util.throwExceptionIfNullOrBlank(itemID, "ItemID");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            JSONObject obj = new JSONObject();
            JSONObject itemObj = new JSONObject();
            itemObj.put("quantity", itemQuantity);
            itemObj.put("amount", "" + price);
            obj.put("cartId", cartID);
            obj.put("item", itemObj);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"cart\":").append(obj.toString()).append("}}");
            App42Log.debug(" Json String : " + sb.toString());
            signParams.put("itemId", itemID);
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/item/" + itemID;
            response = RESTConnectorAsync.getInstance().executePost(resourceURL, queryParams, sb.toString(), headerParams);
            cart = new CartResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return cart;
    }

    public void addItem(final String cartID, final String itemID, final int itemQuantity, final double price, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Cart cart = CartService.this.addItem(cartID, itemID, itemQuantity, price);
                    callBack.onSuccess(cart);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Cart getItems(String cartId) throws App42Exception {
        String response = null;
        Cart cart = null;
        Util.throwExceptionIfNullOrBlank(cartId, "CartId");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("cartId", cartId);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + cartId;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            cart = new CartResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return cart;
    }

    public void getItems(final String cartId, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Cart cart = CartService.this.getItems(cartId);
                    callBack.onSuccess(cart);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Cart getItem(String cartId, String itemId) throws App42Exception {
        String response = null;
        Cart cart = null;
        Util.throwExceptionIfNullOrBlank(cartId, "CartId");
        Util.throwExceptionIfNullOrBlank(itemId, "ItemId");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("cartId", cartId);
            signParams.put("itemId", itemId);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + cartId + "/" + itemId;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            cart = new CartResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return cart;
    }

    public void getItem(final String cartId, final String itemId, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Cart cart = CartService.this.getItem(cartId, itemId);
                    callBack.onSuccess(cart);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public App42Response removeItem(String cartId, String itemId) throws App42Exception {
        String response = null;
        App42Response responseObj = new App42Response();
        Util.throwExceptionIfNullOrBlank(cartId, "CartId");
        Util.throwExceptionIfNullOrBlank(itemId, "ItemId");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("cartId", cartId);
            signParams.put("itemId", itemId);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + cartId + "/" + itemId;
            response = RESTConnectorAsync.getInstance().executeDelete(resourceURL, queryParams, headerParams);
            responseObj.setStrResponse(response);
            responseObj.setResponseSuccess(true);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return responseObj;
    }

    public void removeItem(final String cartId, final String itemId, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    App42Response cart = CartService.this.removeItem(cartId, itemId);
                    callBack.onSuccess(cart);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public App42Response removeAllItems(String cartId) throws App42Exception {
        String response = null;
        App42Response responseObj = new App42Response();
        Util.throwExceptionIfNullOrBlank(cartId, "CartId");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("cartId", cartId);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + cartId;
            response = RESTConnectorAsync.getInstance().executeDelete(resourceURL, queryParams, headerParams);
            responseObj.setStrResponse(response);
            responseObj.setResponseSuccess(true);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return responseObj;
    }

    public void removeAllItems(final String cartId, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    App42Response cart = CartService.this.removeAllItems(cartId);
                    callBack.onSuccess(cart);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Cart isEmpty(String cartId) throws App42Exception {
        String response = null;
        Cart cart = null;
        boolean cartStatus = false;
        Util.throwExceptionIfNullOrBlank(cartId, "CartId");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("cartId", cartId);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + cartId + "/isEmpty";
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            cart = new CartResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return cart;
    }

    public void isEmpty(final String cartId, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Cart cart = CartService.this.isEmpty(cartId);
                    callBack.onSuccess(cart);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Cart checkOut(String cartID) throws App42Exception {
        String response = null;
        Cart cart = null;
        Util.throwExceptionIfNullOrBlank(cartID, "CartID");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            JSONObject obj = new JSONObject();
            obj.put("cartId", cartID);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"cart\":").append(obj.toString()).append("}}");
            App42Log.debug(" Json String : " + sb.toString());
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/checkOut";
            response = RESTConnectorAsync.getInstance().executePut(resourceURL, queryParams, sb.toString(), headerParams);
            cart = new CartResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return cart;
    }

    public void checkOut(final String cartID, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Cart cart = CartService.this.checkOut(cartID);
                    callBack.onSuccess(cart);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Cart payment(String cartID, String transactionID, String paymentStatus) throws App42Exception {
        String response = null;
        Cart cart = null;
        Util.throwExceptionIfNullOrBlank(cartID, "CartId");
        Util.throwExceptionIfNullOrBlank(transactionID, "TransactionId");
        Util.throwExceptionIfNullOrBlank(paymentStatus, "paymentStatus");
        PaymentStatus.throwExceptionIfNotValid(paymentStatus);
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            JSONObject obj = new JSONObject();
            obj.put("cartId", cartID);
            obj.put("transactionId", transactionID);
            obj.put("status", paymentStatus);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"cart\":").append(obj.toString()).append("}}");
            App42Log.debug(" Json String : " + sb.toString());
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/payment";
            response = RESTConnectorAsync.getInstance().executePut(resourceURL, queryParams, sb.toString(), headerParams);
            cart = new CartResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return cart;
    }

    public void payment(final String cartID, final String transactionID, final String paymentStatus, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Cart cart = CartService.this.payment(cartID, transactionID, paymentStatus);
                    callBack.onSuccess(cart);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Vector getPaymentsByUser(String userId) throws App42Exception {
        String response = null;
        Vector cartList = null;
        Util.throwExceptionIfNullOrBlank(userId, "UserId");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            signParams.put("userId", userId);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/payments" + "/user" + "/" + userId;
            App42Log.debug("resourceURL" + resourceURL);
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            cartList = new CartResponseBuilder().buildArrayResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return cartList;
    }

    public void getPaymentsByUser(final String userId, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Vector cart = CartService.this.getPaymentsByUser(userId);
                    callBack.onSuccess(cart);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Cart getPaymentByCart(String cartId) throws App42Exception {
        String response = null;
        Cart cart = null;
        Util.throwExceptionIfNullOrBlank(cartId, "CartId");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("cartId", cartId);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/payments/cart/" + cartId;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            cart = new CartResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return cart;
    }

    public void getPaymentByCart(final String cartId, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Cart cart = CartService.this.getPaymentByCart(cartId);
                    callBack.onSuccess(cart);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Vector getPaymentsByUserAndStatus(String userId, String paymentStatus) throws App42Exception {
        String response = null;
        Vector cartList = null;
        Util.throwExceptionIfNullOrBlank(userId, "userId");
        Util.throwExceptionIfNullOrBlank(paymentStatus, "paymentStatus");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("userId", userId);
            signParams.put("status", paymentStatus);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/payments" + "/user" + "/" + userId + "/" + paymentStatus;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            cartList = new CartResponseBuilder().buildArrayResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return cartList;
    }

    public void getPaymentsByUserAndStatus(final String userId, final String paymentStatus, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Vector cart = CartService.this.getPaymentsByUserAndStatus(userId, paymentStatus);
                    callBack.onSuccess(cart);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Vector getPaymentsByStatus(String paymentStatus) throws App42Exception {
        String response = null;
        Vector cartList = null;
        Util.throwExceptionIfNullOrBlank(paymentStatus, "PaymentStatus");
        PaymentStatus.throwExceptionIfNotValid(paymentStatus);
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("status", paymentStatus);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/payments" + "/status" + "/" + paymentStatus;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            cartList = new CartResponseBuilder().buildArrayResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return cartList;
    }

    public void getPaymentsByStatus(final String paymentStatus, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Vector cart = CartService.this.getPaymentsByStatus(paymentStatus);
                    callBack.onSuccess(cart);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Vector getPaymentHistoryByUser(String userId) throws App42Exception {
        String response = null;
        Vector cartList = null;
        Util.throwExceptionIfNullOrBlank(userId, "UserId");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("userId", userId);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/payment" + "/history" + "/" + userId;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            cartList = new CartResponseBuilder().buildArrayResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return cartList;
    }

    public void getPaymentHistoryByUser(final String userId, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Vector cart = CartService.this.getPaymentHistoryByUser(userId);
                    callBack.onSuccess(cart);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Vector getPaymentHistoryAll() throws App42Exception {
        String response = null;
        Vector cartList = null;
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/payment" + "/history";
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            cartList = new CartResponseBuilder().buildArrayResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return cartList;
    }

    public void getPaymentHistoryAll(final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Vector cart = CartService.this.getPaymentHistoryAll();
                    callBack.onSuccess(cart);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Cart increaseQuantity(String cartID, String itemID, int itemQuantity) throws App42Exception {
        String response = null;
        Cart cart = null;
        Util.throwExceptionIfNullOrBlank(cartID, "Cart Id");
        Util.throwExceptionIfNullOrBlank(itemID, "Item Id");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            JSONObject obj = new JSONObject();
            obj.put("cartId", cartID);
            obj.put("itemId", itemID);
            obj.put("quantity", itemQuantity);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"cart\":").append(obj.toString()).append("}}");
            App42Log.debug(" Json String : " + sb.toString());
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/increaseQuantity";
            App42Log.debug("resourceURL" + resourceURL);
            response = RESTConnectorAsync.getInstance().executePut(resourceURL, queryParams, sb.toString(), headerParams);
            cart = new CartResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return cart;
    }

    public void increaseQuantity(final String cartID, final String itemID, final int itemQuantity, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Cart cart = CartService.this.increaseQuantity(cartID, itemID, itemQuantity);
                    callBack.onSuccess(cart);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Cart decreaseQuantity(String cartID, String itemID, int itemQuantity) throws App42Exception {
        String response = null;
        Cart cart = null;
        Util.throwExceptionIfNullOrBlank(cartID, "Cart Id");
        Util.throwExceptionIfNullOrBlank(itemID, "Item Id");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            JSONObject obj = new JSONObject();
            obj.put("cartId", cartID);
            obj.put("itemId", itemID);
            obj.put("quantity", itemQuantity);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"cart\":").append(obj.toString()).append("}}");
            App42Log.debug(" Json String : " + sb.toString());
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/decreaseQuantity";
            response = RESTConnectorAsync.getInstance().executePut(resourceURL, queryParams, sb.toString(), headerParams);
            cart = new CartResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return cart;
    }

    public void decreaseQuantity(final String cartID, final String itemID, final int itemQuantity, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Cart cart = CartService.this.decreaseQuantity(cartID, itemID, itemQuantity);
                    callBack.onSuccess(cart);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }
}

