/*
 * Decompiled with CFR 0.152.
 */
package com.shephertz.app42.paas.sdk.jme.shopping;

import com.shephertz.app42.paas.sdk.jme.App42CallBack;
import com.shephertz.app42.paas.sdk.jme.App42Exception;
import com.shephertz.app42.paas.sdk.jme.App42Log;
import com.shephertz.app42.paas.sdk.jme.App42Response;
import com.shephertz.app42.paas.sdk.jme.App42Service;
import com.shephertz.app42.paas.sdk.jme.Config;
import com.shephertz.app42.paas.sdk.jme.connection.RESTConnectorAsync;
import com.shephertz.app42.paas.sdk.jme.shopping.Catalogue;
import com.shephertz.app42.paas.sdk.jme.shopping.CatalogueResponseBuilder;
import com.shephertz.app42.paas.sdk.jme.shopping.ItemData;
import com.shephertz.app42.paas.sdk.jme.util.Util;
import java.io.InputStream;
import java.util.Hashtable;
import org.json.jme.JSONObject;

public class CatalogueService
extends App42Service {
    Config config = Config.getInstance();
    private String resource = "catalogue";
    String baseURL;

    public CatalogueService(String apiKey, String secretKey, String baseURL) {
        this.apiKey = apiKey;
        this.secretKey = secretKey;
        this.baseURL = baseURL;
        this.version = "1.0";
    }

    public Catalogue createCatalogue(String catalogueName, String catalogueDescription) throws App42Exception {
        String response = null;
        Catalogue catalogue = null;
        Util.throwExceptionIfNullOrBlank(catalogueName, "CatalogueName");
        Util.throwExceptionIfNullOrBlank(catalogueDescription, "CatalogueDescription");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            JSONObject obj = new JSONObject();
            obj.put("name", catalogueName);
            obj.put("description", catalogueDescription);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"catalogue\":").append(obj.toString()).append("}}");
            App42Log.debug(" Json String : " + sb.toString());
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource;
            response = RESTConnectorAsync.getInstance().executePost(resourceURL, queryParams, sb.toString(), headerParams);
            catalogue = new CatalogueResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return catalogue;
    }

    public void createCatalogue(final String catalogueName, final String catalogueDescription, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Catalogue catalogue = CatalogueService.this.createCatalogue(catalogueName, catalogueDescription);
                    callBack.onSuccess(catalogue);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Catalogue createCategory(String catalogueName, String categoryName, String categoryDescription) throws App42Exception {
        String response = null;
        Catalogue catalogue = null;
        Util.throwExceptionIfNullOrBlank(catalogueName, "CatalogueName");
        Util.throwExceptionIfNullOrBlank(categoryName, "CategoryName");
        Util.throwExceptionIfNullOrBlank(categoryDescription, "CategoryDescription");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("catalogueName", catalogueName);
            JSONObject obj = new JSONObject();
            obj.put("name", categoryName);
            obj.put("description", categoryDescription);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"catalogue\":{\"categories\":{\"category\":").append(obj.toString()).append("}}}}");
            App42Log.debug(" Json String : " + sb.toString());
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + catalogueName + "/category";
            response = RESTConnectorAsync.getInstance().executePost(resourceURL, queryParams, sb.toString(), headerParams);
            catalogue = new CatalogueResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return catalogue;
    }

    public void createCategory(final String catalogueName, final String categoryName, final String categoryDescription, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Catalogue catalogue = CatalogueService.this.createCategory(catalogueName, categoryName, categoryDescription);
                    callBack.onSuccess(catalogue);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Catalogue addItem(String catalogueName, String categoryName, ItemData itemData) throws App42Exception {
        String response = null;
        Catalogue catalogue = null;
        Util.throwExceptionIfNullOrBlank(catalogueName, "CatalogueName");
        Util.throwExceptionIfNullOrBlank(categoryName, "CategoryName");
        Util.throwExceptionIfNullOrBlank(itemData, "ItemData");
        Util.throwExceptionIfNullOrBlank(itemData.getImageName(), "ImageName");
        Util.throwExceptionIfNotValidExtension(itemData.getImageName());
        try {
            InputStream is = itemData.getImageInputStream();
            Hashtable<String, String> queryParams = new Hashtable<String, String>();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams.put("catalogueName", catalogueName);
            queryParams.put("categoryName", categoryName);
            signParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            Hashtable<String, String> postParams = new Hashtable<String, String>();
            postParams.put("itemId", itemData.getItemId());
            postParams.put("name", itemData.getName());
            postParams.put("description", itemData.getDescription());
            postParams.put("price", "" + itemData.getPrice());
            signParams = net.oauth.jme.Util.hashtableMerge(signParams, postParams);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceUrl = Config.getInstance().getBaseURL() + this.version + "/" + this.resource + "/" + catalogueName + "/" + categoryName + "/item";
            response = Util.multiPartRequest("imageFile", is, itemData.getImageName(), queryParams, postParams, headerParams, resourceUrl, Config.getInstance().getAccept());
            catalogue = new CatalogueResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return catalogue;
    }

    public void addItem(final String catalogueName, final String categoryName, final ItemData itemData, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Catalogue catalogue = CatalogueService.this.addItem(catalogueName, categoryName, itemData);
                    callBack.onSuccess(catalogue);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Catalogue getItems(String catalogueName) throws App42Exception {
        String response = null;
        Catalogue catalogue = null;
        Util.throwExceptionIfNullOrBlank(catalogueName, "CatalogueName");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("catalogueName", catalogueName);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + catalogueName;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            catalogue = new CatalogueResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return catalogue;
    }

    public void getItems(final String catalogueName, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Catalogue catalogue = CatalogueService.this.getItems(catalogueName);
                    callBack.onSuccess(catalogue);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Catalogue getItemsByCategory(String catalogueName, String categoryName) throws App42Exception {
        String response = null;
        Catalogue catalogue = null;
        Util.throwExceptionIfNullOrBlank(catalogueName, "CatalogueName");
        Util.throwExceptionIfNullOrBlank(categoryName, "CategoryName");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("catalogueName", catalogueName);
            signParams.put("categoryName", categoryName);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + catalogueName + "/" + categoryName;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            catalogue = new CatalogueResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return catalogue;
    }

    public void getItemsByCategory(final String catalogueName, final String categoryName, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Catalogue catalogue = CatalogueService.this.getItemsByCategory(catalogueName, categoryName);
                    callBack.onSuccess(catalogue);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public App42Response getItemsCountByCategory(String catalogueName, String categoryName) throws App42Exception {
        String response = null;
        App42Response responseObj = new App42Response();
        Util.throwExceptionIfNullOrBlank(catalogueName, "CatalogueName");
        Util.throwExceptionIfNullOrBlank(categoryName, "CategoryName");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("catalogueName", catalogueName);
            signParams.put("categoryName", categoryName);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + catalogueName + "/" + categoryName + "/count";
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            responseObj.setStrResponse(response);
            responseObj.setResponseSuccess(true);
            responseObj.setTotalRecords(new CatalogueResponseBuilder().getTotalRecords(response));
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return responseObj;
    }

    public void getItemsCountByCategory(final String catalogueName, final String categoryName, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    App42Response catalogue = CatalogueService.this.getItemsCountByCategory(catalogueName, categoryName);
                    callBack.onSuccess(catalogue);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Catalogue getItemsByCategory(String catalogueName, String categoryName, Integer max, Integer offset) throws App42Exception {
        String response = null;
        Catalogue catalogue = null;
        Util.validateMax(max);
        Util.throwExceptionIfNullOrBlank(catalogueName, "CatalogueName");
        Util.throwExceptionIfNullOrBlank(categoryName, "CategoryName");
        Util.throwExceptionIfNullOrBlank(max, "Max");
        Util.throwExceptionIfNullOrBlank(offset, "Offset");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("catalogueName", catalogueName);
            signParams.put("categoryName", categoryName);
            signParams.put("max", "" + max);
            signParams.put("offset", "" + offset);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + "paging" + "/" + catalogueName + "/" + categoryName + "/" + max + "/" + offset;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            catalogue = new CatalogueResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return catalogue;
    }

    public void getItemsByCategory(final String catalogueName, final String categoryName, final Integer max, final Integer offset, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Catalogue catalogue = CatalogueService.this.getItemsByCategory(catalogueName, categoryName, max, offset);
                    callBack.onSuccess(catalogue);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Catalogue getItemById(String catalogueName, String categoryName, String itemId) throws App42Exception {
        String response = null;
        Catalogue catalogue = null;
        Util.throwExceptionIfNullOrBlank(catalogueName, "CatalogueName");
        Util.throwExceptionIfNullOrBlank(categoryName, "CategoryName");
        Util.throwExceptionIfNullOrBlank(itemId, "itemId");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("catalogueName", catalogueName);
            signParams.put("categoryName", categoryName);
            signParams.put("itemId", itemId);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + catalogueName + "/" + categoryName + "/" + itemId;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            catalogue = new CatalogueResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return catalogue;
    }

    public void getItemById(final String catalogueName, final String categoryName, final String itemId, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Catalogue catalogue = CatalogueService.this.getItemById(catalogueName, categoryName, itemId);
                    callBack.onSuccess(catalogue);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public App42Response removeAllItems(String catalogueName) throws App42Exception {
        String response = null;
        App42Response responseObj = new App42Response();
        Util.throwExceptionIfNullOrBlank(catalogueName, "CatalogueName");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("catalogueName", catalogueName);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + catalogueName;
            response = RESTConnectorAsync.getInstance().executeDelete(resourceURL, queryParams, headerParams);
            responseObj.setStrResponse(response);
            responseObj.setResponseSuccess(true);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return responseObj;
    }

    public void removeAllItems(final String catalogueName, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    App42Response catalogue = CatalogueService.this.removeAllItems(catalogueName);
                    callBack.onSuccess(catalogue);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public App42Response removeItemsByCategory(String catalogueName, String categoryName) throws App42Exception {
        String response = null;
        App42Response responseObj = new App42Response();
        Util.throwExceptionIfNullOrBlank(catalogueName, "CatalogueName");
        Util.throwExceptionIfNullOrBlank(categoryName, "CategoryName");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("catalogueName", catalogueName);
            signParams.put("categoryName", categoryName);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + catalogueName + "/" + categoryName;
            response = RESTConnectorAsync.getInstance().executeDelete(resourceURL, queryParams, headerParams);
            responseObj.setStrResponse(response);
            responseObj.setResponseSuccess(true);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return responseObj;
    }

    public void removeItemsByCategory(final String catalogueName, final String categoryName, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Catalogue catalogue = CatalogueService.this.createCatalogue(catalogueName, categoryName);
                    callBack.onSuccess(catalogue);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public App42Response removeItemById(String catalogueName, String categoryName, String itemId) throws App42Exception {
        String response = null;
        App42Response responseObj = new App42Response();
        Util.throwExceptionIfNullOrBlank(catalogueName, "CatalogueName");
        Util.throwExceptionIfNullOrBlank(categoryName, "CategoryName");
        Util.throwExceptionIfNullOrBlank(itemId, "ItemId");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("catalogueName", catalogueName);
            signParams.put("categoryName", categoryName);
            signParams.put("itemId", itemId);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + catalogueName + "/" + categoryName + "/" + itemId;
            response = RESTConnectorAsync.getInstance().executeDelete(resourceURL, queryParams, headerParams);
            responseObj.setStrResponse(response);
            responseObj.setResponseSuccess(true);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return responseObj;
    }

    public void removeItemById(final String catalogueName, final String categoryName, final String itemId, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    App42Response catalogue = CatalogueService.this.removeItemById(catalogueName, categoryName, itemId);
                    callBack.onSuccess(catalogue);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }
}

